$PBExportHeader$u_tabcontrol3d.sru
$PBExportComments$3 D flavor of Tab Control.
forward
global type u_tabcontrol3d from u_tabcontrol
end type
end forward

global type u_tabcontrol3d from u_tabcontrol
end type
global u_tabcontrol3d u_tabcontrol3d

type variables
int offseta,adjusta
int offsetb,adjustb
int offsetc,adjustc
string colora,bordera
string colorb,borderb

end variables

forward prototypes
protected function string resizeroundrectangle (string name, int newx, int newy, int neww, int newh)
protected function string hideroundrectangle (string name)
protected function string showroundrectangle (string name)
protected function string roundrectangle (string name, int x, int y, int w, int h, int cornerrad, string scolor, string pcolor, string pw)
protected function string coverrectangle (int x, int y, int w, int h, string color)
protected function string resizecoverrectangle (int newx, int newy, int neww, int newh)
end prototypes

on constructor;call u_tabcontrol::constructor;//
// u_tabcontrol3d Event constructor inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Description: Create the 3D tab control.

this.yrowoffset = 18
this.xpaneoffset = 5
this.ypaneoffset = 5
this.xtextoffset = 5
this.ytextoffset = 3

this.offseta = 0
this.adjusta = 0
this.offsetb = 3
this.adjustb = 4
this.offsetc = 3
this.adjustc = 6
this.colora = "16777215"
this.bordera = "0"
this.colorb = "8421504"
this.borderb = "8421504"


end on

protected function string resizeroundrectangle (string name, int newx, int newy, int neww, int newh);//
// u_tabcontrol3d Function resizeroundrectangle inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
//     int newx
//     int newy
//     int neww
//     int newh
// 
// Result: string
//
// Description: Resize a round rectangle.

IF newx < 0 THEN newx = -100
IF newy < 0 THEN newy = -100
IF neww < 0 THEN neww = -100
IF newh < 0 THEN newh = -100

return this.resizeobject(name+"a",newx+offseta,newy+offseta,neww - adjusta,newh - adjusta) + &
	this.resizeobject(name+"b",newx+offsetb,newy+offsetb,neww - adjustb,newh - adjustb) + &
	this.resizeobject(name+"c",newx+offsetc,newy+offsetc,neww - adjustc,newh - adjustc)



end function

protected function string hideroundrectangle (string name);//
// u_tabcontrol3d Function hideroundrectangle inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
// 
// Result: string
//
// Description: Hide a round rectangle.

return this.hideobject(name + 'a') + &
	this.hideobject(name + 'b') + &
	this.hideobject(name + 'c')
end function

protected function string showroundrectangle (string name);//
// u_tabcontrol3d Function showroundrectangle inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
// 
// Result: string
//
// Description: Display a round rectangle.

return this.showobject(name + 'a') + &
	this.showobject(name + 'b') + &
	this.showobject(name + 'c')
end function

protected function string roundrectangle (string name, int x, int y, int w, int h, int cornerrad, string scolor, string pcolor, string pw);//
// u_tabcontrol3d Function roundrectangle inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
//     int x
//     int y
//     int w
//     int h
//     int cornerrad
//     string scolor
//     string pcolor
//     string pw
// 
// Result: string
//
// Description: Define a round rectangle.

return super::roundrectangle(name+"a",x+offseta,y+offseta,w - adjusta,h - adjusta,cornerrad,colora,bordera,"1") + &
	super::roundrectangle(name+"b",x+offsetb,y+offsetb,w - adjustb,h - adjustb,cornerrad - adjustb,colorb,borderb,"1") + &
	super::roundrectangle(name+"c",x+offsetc,y+offsetb,w - adjustb,h - adjustc,cornerrad - adjustc,scolor,scolor,"1")

end function

protected function string coverrectangle (int x, int y, int w, int h, string color);//
// u_tabcontrol3d Function coverrectangle inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     int x
//     int y
//     int w
//     int h
//     string color
// 
// Result: string
//
// Description: Cover a rectangle with color.

return super::coverrectangle(x,y,w,h,color) + &
	' rectangle(band=detail x="' + string(x) + &
	'" y="' + string(y) + '" height="' + string(h) + &
	'" width="2" name=coverleft  brush.hatch="6" brush.color="' + &
	this.colora + '" pen.style="0" pen.width="1" pen.color="' + this.colora + &
	'" background.mode="2" background.color="-2134851392") ' + &
	' rectangle(band=detail x="' + string(x + w - 2) + &
	'" y="' + string(y) + '" height="' + string(h) + &
	'" width="2" name=coverright  brush.hatch="6" brush.color="' + &
	this.colorb + '" pen.style="0" pen.width="1" pen.color="' + this.colorb + &
	'" background.mode="2" background.color="-2134851392") '
end function

protected function string resizecoverrectangle (int newx, int newy, int neww, int newh);//
// u_tabcontrol3d Function resizecoverrectangle inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     int newx
//     int newy
//     int neww
//     int newh
// 
// Result: string
//
// Description: Resize the cover of a rectangle.

int h, hl, hr
h = this.coverheight - 3
hl = this.coverheight
hr = this.coverheight
CHOOSE CASE newh
	CASE -1
		h = -1
		hl = -1
		hr = -1
	CASE 1
		h += 3
		hr -= 3
	CASE 2
		hl -= 3
		hr -= 3
	CASE 3
		hl -= 3
		h += 3
END CHOOSE
    
return resizeObject("cover", newx, newy, neww, h) + &
	resizeObject("coverleft", newx, newy, 2, hl) + &
	resizeObject("coverright", newx + neww -2, newy, 2, hr) 
end function

on u_tabcontrol3d.create
call u_tabcontrol::create
end on

on u_tabcontrol3d.destroy
call u_tabcontrol::destroy
end on

