//****************************************************************************
//*                                                                          *
//*    Class: ResponseDialog.java                                            *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: Dialog with response capability                                *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.widgets;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import 							java.awt.*;

//****************************************************************************
//* ResponseDialog                                                           *
//****************************************************************************

public class
ResponseDialog 
extends CenterDialog
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

    public static final int 	NO = 0;
    public static final int 	YES = 1;
    public static final int 	CANCEL = -1;
	
	protected Button 			yes = null, no = null, cancel = null;
    protected MultiLineLabel 	label;
	
//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	public 
	ResponseDialog( Frame parent, String title, String message, String yesLabel, String noLabel, String cancelLabel )
    {
        // Create the window.
        super( parent, title, true );
		
		// Specify a LayoutManager for it
        setLayout( new BorderLayout( 10, 10 ) );

        // Put the message label in the middle of the window.
        label = new MultiLineLabel( message, 20, 20 );
        add( "Center", label );

        // Create a panel of buttons, center the row of buttons in
        // the panel, and put the pane at the bottom of the window.
        Panel p = new Panel();
        p.setLayout( new FlowLayout( FlowLayout.CENTER, 10, 10 ) );

        if ( yesLabel != null )
			p.add( this.yes = new Button( yesLabel ) );
			
        if ( noLabel != null )
			p.add( this.no = new Button( noLabel ) );
			
        if ( cancelLabel != null )
			p.add( cancel = new Button( cancelLabel ) );
			
        add( "South", p );

        // Set the window to its preferred size.
        pack();
        center( false );
    }

//****************************************************************************
//* action                                                                   *
//****************************************************************************

    public boolean 
	action( Event e, Object arg )
    {
        if ( e.target instanceof Button )
		{
            hide();
            dispose();
			
			if ( e.target == yes )
				answer( YES );
			else if ( e.target == no )
				answer( NO );
            else answer( CANCEL );
			
            return( true );
        }
        
		return( false );
    }

//****************************************************************************
//* answer                                                                   *
//****************************************************************************

    protected void 
	answer( int answer )
	{
        switch(answer) {
            case YES: yes(); break;
            case NO:  no(); break;
            case CANCEL: cancel(); break;
        }
    }

    protected void yes() {}
    protected void no() {}
    protected void cancel() {}
}
