//****************************************************************************
//*                                                                          *
//*    Class: OkDialog.java                                                  *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: Generic Dialog with a single button (OK)                       *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.widgets;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import 							java.awt.*;

//****************************************************************************
//* InfoDialog                                                               *
//****************************************************************************

public class
OkDialog
extends CenterDialog
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	Button						myButton;

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

    public
    OkDialog( Frame parent, String title, String message )
    {
        //	Create a dialog with the specified title
        super( parent, title, true );

        //	Create and use a BorderLayout manager with specified margins
        setLayout( new BorderLayout( 10, 10 ) );

        //	Create the message component and add it to the window
        add( "Center", new MultiLineLabel( message, 20, 20 ) );

        myButton = new Button( "&OK" );

		Panel p = new Panel();
        p.setLayout( new FlowLayout( FlowLayout.CENTER, 10, 10 ) );
        p.add( myButton );

		//	Add to bottom of Dialog's layout...
        add( "South", p );

		//	Clean up...
		pack();
    }

//****************************************************************************
//* action                                                                   *
//****************************************************************************

    public boolean
	action( Event e, Object arg )
    {
        if ( e.target == myButton )
		{
            hide();
            dispose();
            return( true );
        }

		return( false );
    }

//****************************************************************************
//* gotFocus                                                                 *
//****************************************************************************

    public boolean
	gotFocus( Event e, Object arg )
	{
        myButton.requestFocus();
        return( true );
    }

}
