//****************************************************************************
//*    Class: TimeOut.java                                                   *
//* Comments: Implements an interface for the CallbackTimer class.           *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.util;

//****************************************************************************
//* TimeOut                                                                  *
//****************************************************************************

/**
 * This interface is used with the CallbackTimer object. If a class 
 * implements this interface it will be eligible to use CallbackTimer
 * objects.
 *
 * @see CallbackTimer
 * @see EventTimer
 *
 * @version		1.00, 1 May 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public interface
TimeOut
{

//****************************************************************************
//* timeOut                                                                  *
//****************************************************************************

	/**
	 * Called when a timer event occurs
	 *
	 * @param source The CallbackTimer that triggered the event
	 */

	public void timeOut( CallbackTimer timer );

}