//****************************************************************************
//*    Class: FileDate.java                                                      *
//* Comments: Extends Java's default date to add a new method                *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.util;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.util.Date;

//****************************************************************************
//* Date                                                                     *
//****************************************************************************

/**
 * An extension of the default Java Date.
 *
 * @see java.util.Date
 *
 * @version		1.00, 1 May 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public class FileDate
extends Date
{

//****************************************************************************
//* toFileString                                                             *
//****************************************************************************

	/**
	 * This method returns the date in a format suitable for using in
	 * file names. This format is YYMMDD, where YY is the year, MM is the
	 * month, and DD is the day.
	 *
	 * @see java.util.Date#toString
	 */

	public String
	toFileString()
	{
		String		retString = "";
		int			m = 1 + getMonth();
		int 		d = getDate();
		int			y = getYear() % 100;

		if ( y < 10 )
			retString += "0";

		retString += y;

		if ( m < 10 )
			retString += "0";

		retString += m;

		if ( d < 10 )
			retString += "0";

		retString += d;

		return( retString );
	}

}