//****************************************************************************
//*    Class: EventTimer.java                                                *
//* Comments: Implements an event timer.                                     *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.util;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.awt.Component;
import							java.awt.Event;

//****************************************************************************
//* EventTimer                                                               *
//****************************************************************************

/**
 * The EventTimer class will generate an ACTION_EVENT when a specified number of
 * milliseconds have elapsed. This is similar to the CallbackTimer class,
 * but it does not require the target class to implement the TimeOut interface.
 * 
 * This class extends Thread so it must be started, and can be suspended while
 * running.
 * 
 * @see CallbackTimer
 * @see TimeOut
 *
 * @version		1.00, 1 May 1996
 * @author		Jerry Ablan, munster@mcs.net
 */
	 
public class
EventTimer
extends Thread
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	private int					myInterval;
	private Component			myTarget;

//****************************************************************************
//* EventTimer                                                               *
//****************************************************************************

	/**
	 * Constructs a EventTimer object.
	 *
	 * @param target The object that is requesting the timer
	 * @param interval The number of milliseconds between notifications
	 */

	public
	EventTimer( Component target, int interval )
	{
		//	Save my values...
		myTarget = target;
		myInterval = interval;

		//	Indicate that this is not a user thread...
		setDaemon( true );
	}

//****************************************************************************
//* run                                                                      *
//****************************************************************************

	/**
	 * The run method is what the thread is supposed to do when active.
	 *
	 */

	public void
	run()
	{
		//	Do this forever!
		while ( true )
		{
			try
			{
				//	Wait until next interval...
				sleep( myInterval );
			}
			catch ( InterruptedException ie ) {}

			//	Post an event...
			myTarget.postEvent( new Event( ( Object )myTarget, Event.ACTION_EVENT, ( Object )this ) );
		}
	}
}