ORIGIN		= Symantec Caf
ORIGIN_VER	= Version 7.22
VERSION		= DEBUG

!IFDEF SUB_DEBUG
DEBUG		= $(SUB_DEBUG)
NDEBUG		= !$(SUB_DEBUG)
!ELSE
DEBUG		= 1
NDEBUG		= 0
!ENDIF

PROJ		= jif
APPTYPE		= JAVA CONSOLE
PROJTYPE	= class

JAVAC		= sj
MAKE		= SMAKE
LNK		= LINK


HEADERS		= 
!IF $(DEBUG)
OUTPUTDIR	= .
CREATEOUTPUTDIR	=
TARGETDIR	= .
CREATETARGETDIR	=

CFLAGS		=  -g 
DEFINES		= 
!ELSE
OUTPUTDIR	= .
CREATEOUTPUTDIR	=
TARGETDIR	= .
CREATETARGETDIR	=

CFLAGS		=  -O 
DEFINES		= 
!ENDIF

MFLAGS		= MASTERPROJ=$(PROJ) 
DEBUGGERFLAGS	=  
PAR		= PROJS BATS OBJS

INCLUDES	= 



OBJS		= 

PROJS		= jiflet\jiflet.prj log\log.prj net\net.prj  \
		util\util.prj Widgets\widgets.prj sql\sql.prj awt\awt.prj 

BATS		= 

PRECOMPILE	=  jiflet?Bjiflet?Pprj  log?Blog?Pprj  net?Bnet?Pprj  \
		 util?Butil?Pprj  Widgets?Bwidgets?Pprj  sql?Bsql?Pprj  awt?Bawt?Pprj 

POSTCOMPILE	= 

.SUFFIXES: .JAVA .CLASS 

.JAVA.CLASS:
	$(JAVAC) $(CFLAGS) $(INCLUDES) $*.java



all:	noteout createdir $(PRECOMPILE) $(OBJS) $(POSTCOMPILE) _done


all2:	createdir $(PRECOMPILE) $(OBJS) $(POSTCOMPILE) _done

noteout:
	REM Output to $(OUTPUTDIR)

createdir:
	$(CREATEOUTPUTDIR)
	$(CREATETARGETDIR)
	
_done:
		REM  Project is up to date

buildall:	clean	all


clean:
		-del jif.dpd
		cd jiflet\.
		$(MAKE) -fjiflet.mak $(MFLAGS) "SUB_DEBUG=$(DEBUG)" $@
		cd ..\log\.
		$(MAKE) -flog.mak $(MFLAGS) "SUB_DEBUG=$(DEBUG)" $@
		cd ..\net\.
		$(MAKE) -fnet.mak $(MFLAGS) "SUB_DEBUG=$(DEBUG)" $@
		cd ..\util\.
		$(MAKE) -futil.mak $(MFLAGS) "SUB_DEBUG=$(DEBUG)" $@
		cd ..\widgets\.
		$(MAKE) -fwidgets.mak $(MFLAGS) "SUB_DEBUG=$(DEBUG)" $@
		cd ..\sql\.
		$(MAKE) -fsql.mak $(MFLAGS) "SUB_DEBUG=$(DEBUG)" $@
		cd ..\awt\.
		$(MAKE) -fawt.mak $(MFLAGS) "SUB_DEBUG=$(DEBUG)" $@

jiflet?Bjiflet?Pprj:
		cd jiflet\.
		$(MAKE) -fjiflet.mak "SUB_DEBUG=$(DEBUG)"

log?Blog?Pprj:
		cd log\.
		$(MAKE) -flog.mak "SUB_DEBUG=$(DEBUG)"

net?Bnet?Pprj:
		cd net\.
		$(MAKE) -fnet.mak "SUB_DEBUG=$(DEBUG)"

util?Butil?Pprj:
		cd util\.
		$(MAKE) -futil.mak "SUB_DEBUG=$(DEBUG)"

Widgets?Bwidgets?Pprj:
		cd widgets\.
		$(MAKE) -fwidgets.mak "SUB_DEBUG=$(DEBUG)"

sql?Bsql?Pprj:
		cd sql\.
		$(MAKE) -fsql.mak "SUB_DEBUG=$(DEBUG)"

awt?Bawt?Pprj:
		cd awt\.
		$(MAKE) -fawt.mak "SUB_DEBUG=$(DEBUG)"





!IF EXIST (jif.dpd)
!INCLUDE jif.dpd
!ENDIF

