//****************************************************************************
//*                                                                          *
//*    Class: AwareLabel.java                                                *
//* Comments: Extends Java's default Label                                   *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.awt;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.awt.*;

//****************************************************************************
//* AwareLabel                                                               *
//****************************************************************************

/**
 * An extension of the default Label
 *
 * @see java.awt.Label
 *
 * @version		1.00, 1 May 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public class AwareLabel
extends Label
implements Aware
{

//****************************************************************************
//* handleEvent                                                              *
//****************************************************************************

	public boolean
	handleEvent( Event event )
	{
		if ( filterEvent( event ) )
			return( false );

		//	Pass it on up...
		return( super.handleEvent( event ) );
	}

//****************************************************************************
//* filterEvent                                                              *
//****************************************************************************

	/**
	* This method checks for certain events. If the event is one we want,
	* we return true which triggers handleEvent() to not handle it.
	* @param event The event to filter
	*/

	public boolean
	filterEvent( Event event )
	{
		switch ( event.id )
		{
			case Event.KEY_PRESS:		//	Tab was pressed...
				if ( event.key == AwarePanel.TAB_KEY &&
					getParent() instanceof AwarePanel )
					return( true );
				break;

			case Event.GOT_FOCUS:		//	Got the focus
			case Event.LOST_FOCUS:		//	Lost the focus
				return( true );
		}

		//	Don't want any others...
		return( false );
	}

//****************************************************************************
//* generateUpdateSQL                                                        *
//****************************************************************************

	/**
	* Stub function.
	* @param addSet If true, adds a SET to the beginning of the statement
	*/

	public String
	generateUpdateSQL( boolean addSet )
	{
		return( "" );
	}

//****************************************************************************
//* generateInsertSQL                                                        *
//****************************************************************************

	/**
	* Stub function.
	* @param addSet If true, adds a SET to the beginning of the statement
	*/

	public String
	generateInsertSQL( boolean addSet )
	{
		return( "" );
	}

//****************************************************************************
//* getSQL                                                                   *
//****************************************************************************

	/**
	* Stub function.
	* @param forWhere Indicates that the return string should include the
	* column name.
	*/

	public String
	getSQL( boolean forWhere )
	{
		return( "" );
	}

}