//****************************************************************************
//*    Class: JifClient.java                                                 *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*  Version: 1.0                                                            *
//*                                                                          *
//* Comments: Communication handler for the server                           *
//*                                                                          *
//****************************************************************************
//*                             Revision History                             *
//****************************************************************************
//* 05.11.96: GHA - Creation                                                 *
//* xx.xx.xx:                                                                *
//****************************************************************************

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.net.*;
import							java.io.*;

//****************************************************************************
//* JifClient                                                               *
//****************************************************************************

public class
JifClient
extends Thread
{
	static int					connectionNumber = 0;
	protected Socket			client;
	protected JifVoyeur			voyeur;
	protected DataInputStream	in;
	protected PrintStream		out;

	public
	JifClient( Socket client, ThreadGroup threadGroup, int priority, JifVoyeur voyeur )
	{
		super( threadGroup, "JifClient-" + connectionNumber++ );
		this.setPriority( priority );

		this.client = client;
		this.voyeur = voyeur;

		try
		{
			in = new DataInputStream( client.getInputStream() );
			out= new PrintStream( client.getOutputStream() );
		}
		catch ( IOException ioe )
		{
			try
			{
				client.close();
			}
			catch ( IOException e ) {}

			System.err.println( "Exception while getting socket streams: " + ioe );
			return;
		}

		//	Start me up!
		start();
	}

	public void
	run()
	{
		String			line;
		StringBuffer	revLine;
		int				len;

		out.println( "Line reversal server version 1.0" );

		try
		{
			while ( true )
			{
				line = in.readLine();

				if ( line == null )
					break;

				len = line.length();
				revLine = new StringBuffer( len );

				for ( int i = len - 1; i >= 0; i-- )
					revLine.insert( len - 1 - i, line.charAt( i ) );

				out.println( revLine );
			}
		}
		catch ( IOException e );

		finally
		{
			try
			{
				client.close();
			}
			catch ( IOException e2 );

			synchronized( voyeur )
			{
				voyeur.notify();
			}

			voyeur.server.log( "Client [" + client.getInetAddress().getHostName() + ":" + client.getPort() + "] closed" );
		}
	}

	public String
	toString()
	{
		return( this.getName() + " connected to: " + client.getInetAddress().getHostName()+":"+client.getPort() );
	}

}