//****************************************************************************
//*                                                                          *
//*    Class: EmployeeRecord.java                                            *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: An employee record                                             *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							jif.sql.*;
import							jif.awt.*;

import 							java.sql.*;

import							imaginary.sql.*;

//****************************************************************************
//* Employee                                                                 *
//****************************************************************************

public class
EmployeeRecord
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	//	An indicator for data changes...
	boolean						dataChange = false;

	//	A variable for each table column...
	int							emp_id;
	String						last_name;
	String						first_name;
	String						mid_name;
	String						ssn;
	String						position;
	String						addr_line_1;
	String						addr_line_2;
	String						city;
	String						state;
	String						zip_code;
	String						home_phone;
	String						work_ext;
	String						email_addr;
	String						web_page_url;
	String						nice_name;

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	public
	EmployeeRecord()
	{
		emp_id = -1;
		last_name = "";
		nice_name = "";
	}

	public
	EmployeeRecord( ResultSet rs )
	{
		try
		{
			//	Suck out the data...
			emp_id = rs.getInteger( 1 );
			last_name = rs.getChar( 2 );
			first_name = rs.getChar( 3 );
			mid_name = rs.getChar( 4 );
			ssn = rs.getChar( 5 );
			position = rs.getChar( 6 );
			addr_line_1 = rs.getChar( 7 );
			addr_line_2 = rs.getChar( 8 );
			city = rs.getChar( 9 );
			state = rs.getChar( 10 );
			zip_code = rs.getChar( 11 );
			home_phone = rs.getChar( 12 );
			work_ext = rs.getChar( 13 );
			email_addr = rs.getChar( 14 );
			web_page_url = rs.getChar( 15 );
		}
		catch ( SQLException e )
		{
			//	Signal an error...
			emp_id = -1;
		}

		//	Format the name...
		nice_name = last_name + ", " + first_name;
	}

//****************************************************************************
//* update                                                                   *
//****************************************************************************

	public boolean
	update( JifConnector theConnector, AwarePanel ap )
	{
		boolean		success = true;

		try
		{
			//	No update if nothing to do...
			if ( dataChange )
			{
				String	sql;

				//	Generate some SQL!
				if ( emp_id == -1 )
				{
					//	Get a new UID!
					SequenceGenerator sg = new SequenceGenerator(
						theConnector, "emp_t", "emp_id" );

					emp_id = sg.getNextValue();

					//	Set the UID!
					ap.setChildValue( "emp_id", emp_id );

					//	Get the SQL!
					sql = ap.generateInsertSQL( "emp_t" );
				}
				else
					sql = ap.generateUpdateSQL( "emp_t" );

				if ( !sql.equals( "" ) )
					theConnector.myStatement.executeUpdate( sql );
			}
		}
		catch ( SQLException e )
		{
			success = false;
		}

		return( success );
	}

//****************************************************************************
//* setDataChange                                                            *
//****************************************************************************

	public boolean
	setDataChange( boolean onOff )
	{
		dataChange = onOff;
		return( dataChange );
	}

}
