//****************************************************************************
//*                                                                          *
//*   Jiflet: PickList.java                                                  *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: A generic picklist class                                       *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.widgets;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import 							java.awt.*;

//****************************************************************************
//* Employee                                                                 *
//****************************************************************************

/**
 * The PickList class enables you to create quick and easy lists of data
 * that the user may choose from.
 */

public abstract class
PickList
extends CenterDialog
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	/**
	 * The button panel
	 */

	protected OkCancelButtonBar	buttonBar = new OkCancelButtonBar();

	/**
	 * The list box that contains the data from which to choose. We
	 * default the list to show 10 rows of data.
	 */

	protected List				myList = new List( 10, false );

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	/**
	 * Constructs a PickList object
	 * @param daddy The parent frame who owns the PickList
	 * @param title The title of the PickList
	 */

	public
	PickList( Frame daddy, String title )
	{
		//	Phone home...
		super( daddy, title, true );

		//	Add list to center of box...
		add( "Center", myList );

		//	Create a button bar panel...
		add( "South", buttonBar );

		//	Disable the Ok button until a selection has been made...
		buttonBar.okButton.disable();

		//	Get the preferred sizes...
		pack();

		//	Resize just a little bit...
		resize( 300, size().height );
	}

//****************************************************************************
//* init                                                                     *
//****************************************************************************

	/**
	 * You must override this in your derived class. This should fill the
	 * picklist with data.
	 */

	public abstract void
	init();

//****************************************************************************
//* action                                                                   *
//****************************************************************************

	/**
	 * The ACTION_EVENT handler for the picklist. Basically just listens for
	 * button presses and notifies the owner of such a click
	 */

    public boolean
	action( Event event, Object arg )
	{
		//	Handle buttons and a list double click!
		if ( event.target == myList || event.target == buttonBar.okButton )
		{
			//	User chose wisely!
			getParent().deliverEvent( new Event( this, Event.ACTION_EVENT,
				( Object )new Integer( myList.getSelectedIndex() ) ) );

			return( true );
        }

		//	Handle a cancel event...
		if ( event.target == buttonBar.cancelButton )
		{
			//	User has cancelled...
			getParent().deliverEvent( new Event( this, Event.ACTION_EVENT,
				( Object )new Integer( -1 ) ) );

			return( true );
		}

		//	Give up to parent...
        return( super.action( event, arg ) );
    }

//****************************************************************************
//* handleEvent                                                              *
//****************************************************************************

	/**
	 * Handles some events for the picklist
	 * @param event The event
	 */

	public boolean
	handleEvent( Event event )
	{
		//	Make a window close event look like a cancel...
		if ( event.target == this && event.id == Event.WINDOW_DESTROY )
		{
			//	Tell owner that the user cancelled
			getParent().deliverEvent( new Event( this, Event.ACTION_EVENT,
				( Object )new Integer( -1 ) ) );

			// Fall through and let base class handle destruction...
		}

		//	Handle list events...
		if ( event.target == myList )
		{
			//	Enable/Disable Ok button based on clicking
			switch ( event.id )
			{
				case Event.LIST_DESELECT:
					buttonBar.okButton.disable();
					return( true );

				case Event.LIST_SELECT:
					buttonBar.okButton.enable();
					return( true );
			}
		}

		//	Give up to parent...
        return( super.handleEvent( event ) );
	}
}
