//****************************************************************************
//*                                                                          *
//* Interface: Aware.java                                                    *
//*  Comments: Interface for all "aware" components to adhere to             *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.awt;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.awt.*;

//****************************************************************************
//* Aware                                                                    *
//****************************************************************************

/**
 * An interface for Components
 *
 * @see java.awt.Component
 *
 * @version		1.00, 1 May 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public interface Aware
{

//****************************************************************************
//* filterEvent                                                              *
//****************************************************************************

	public boolean filterEvent( Event event );

//****************************************************************************
//* generateUpdateSQl                                                        *
//****************************************************************************

	public String generateUpdateSQL( boolean addSet );

//****************************************************************************
//* generateInsertSQL                                                        *
//****************************************************************************

	public String generateInsertSQL( boolean addParen );
	
//****************************************************************************
//* generateSQL                                                              *
//****************************************************************************

	public String getSQL( boolean forWhere );
}