//****************************************************************************
//*    Class: JifVoyeur.java                                                 *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*  Version: 1.0                                                            *
//*                                                                          *
//* Comments: A JIF client thread watcher...                                 *
//*                                                                          *
//****************************************************************************
//*                             Revision History                             *
//****************************************************************************
//* 05.11.96: GHA - Creation                                                 *
//* xx.xx.xx:                                                                *
//****************************************************************************

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.io.*;

//****************************************************************************
//* JifVoyeur                                                                *
//****************************************************************************

public class
JifVoyeur
extends Thread
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	protected JifServer 		server;

//****************************************************************************
//* JifVoyeur                                                                *
//****************************************************************************

	protected
	JifVoyeur( JifServer s )
	{
		super( s.threadGroup, "JifClient JifVoyeur" );
		server = s;
		start();
	}

//****************************************************************************
//* run                                                                      *
//****************************************************************************

	public synchronized void
	run()
	{
		while ( true )
		{
			try
			{
				wait( 5000 );
			}
			catch ( InterruptedException ie ) {}

			synchronized( server.clients )
			{
				for ( int i = 0; i < server.clients.size(); i++ )
				{
					JifClient c = ( JifClient ) server.clients.elementAt( i );

					if ( !c.isAlive() )
					{
						server.clients.removeElementAt( i );
						server.clientList.delItem( i );
						i--;
					}
				}
			}
		}
	}
}