//****************************************************************************
//*                                                                          *
//*    Class: EmployeeUI.java                                                *
//* Comments: A class that implements the user interface for our employee    *
//*           maintenance program.                                           *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* imports                                                                  *
//****************************************************************************

import 							java.awt.*;
import							jif.awt.*;
import							jif.widgets.*;

//****************************************************************************
//* EmployeeUI                                                               *
//****************************************************************************

public class
EmployeeUI
extends AwarePanel
{

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	public
	EmployeeUI()
	{
		//{{INIT_CONTROLS
		setLayout(null);
		resize(460,211);
		idLabel=new Label("ID:", Label.RIGHT);
		idLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(idLabel);
		idLabel.reshape(9,10,80,20);
		fnLabel=new Label("First Name:", Label.RIGHT);
		fnLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(fnLabel);
		fnLabel.reshape(9,34,80,20);
		mnLabel=new Label("Middle Name:", Label.RIGHT);
		mnLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(mnLabel);
		mnLabel.reshape(9,59,80,19);
		lnLabel=new Label("Last Name:", Label.RIGHT);
		lnLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(lnLabel);
		lnLabel.reshape(9,81,80,21);
		addrLabel=new Label("Address:", Label.RIGHT);
		addrLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(addrLabel);
		addrLabel.reshape(9,107,80,20);
		cityLabel=new Label("City:", Label.RIGHT);
		cityLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(cityLabel);
		cityLabel.reshape(9,156,80,20);
		stateLabel=new Label("State:", Label.RIGHT);
		stateLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(stateLabel);
		stateLabel.reshape(9,180,80,25);
		zipLabel=new Label("Zip:", Label.RIGHT);
		zipLabel.setFont(new Font("Dialog",Font.PLAIN,12));
		add(zipLabel);
		zipLabel.reshape(216,180,41,25);

		emp_id=new AwareTextField(32, "emp_id", true );
		emp_id.setNumeric( true );
		add(emp_id);
		emp_id.reshape(90,10,265,20);
		first_name=new AwareTextField(32, "first_name" );
		add(first_name);
		first_name.reshape(90,34,265,20);
		middle_name=new AwareTextField(32, "mid_name" );
		add(middle_name);
		middle_name.reshape(90,59,265,20);
		last_name=new AwareTextField(32, "last_name" );
		add(last_name);
		last_name.reshape(90,81,265,20);
		addr_line_1=new AwareTextField(32, "addr_line_1" );
		add(addr_line_1);
		addr_line_1.reshape(90,107,265,20);
		addr_line_2=new AwareTextField(32, "addr_line_2" );
		add(addr_line_2);
		addr_line_2.reshape(90,132,265,20);
		city=new AwareTextField(32, "city" );
		add(city);
		city.reshape(90,156,265,20);
		state=new AwareTextField(10, "state" );
		add(state);
		state.reshape(90,180,90,20);
		zip_code=new AwareTextField(10, "zip_code" );
		add(zip_code);
		zip_code.reshape(261,180,90,20);
		newButton=new AwareButton("&New");
		newButton.setFont(new Font("Dialog",Font.PLAIN,12));
		add(newButton);
		newButton.reshape(374,15,80,24);
		saveButton=new AwareButton("&Save");
		saveButton.setFont(new Font("Dialog",Font.PLAIN,12));
		add(saveButton);
		saveButton.reshape(374,42,80,26);
		saveButton.disable();
		//}}

		//	Set the focus to the first field...
		setFocus( emp_id );
	}

//****************************************************************************
//* setRecord                                                                *
//****************************************************************************

	/**
	 * Moves data from an EmployeeRecord object to the fields on the screen
	 * for editing.
	 * @param er The EmployeeRecord
	 */

	public void
	setRecord( EmployeeRecord er )
	{
		emp_id.setText( Integer.toString( er.emp_id ) );
		first_name.setText( er.first_name );
		middle_name.setText( er.mid_name );
		last_name.setText( er.last_name );
		addr_line_1.setText( er.addr_line_1 );
		addr_line_2.setText( er.addr_line_2 );
		city.setText( er.city );
		state.setText( er.state );
		zip_code.setText( er.zip_code );
	}

//****************************************************************************
//* getRecord                                                                *
//****************************************************************************

	/**
	 * Moves data from the fields on the screen to an EmployeeRecord object.
	 * @param er The EmployeeRecord
	 */

	public void
	getRecord( EmployeeRecord er )
	{
		try
		{
			er.emp_id = Integer.parseInt( emp_id.getText() );
		}
		catch ( NumberFormatException e )
		{
			er.emp_id = -1;
		}

		er.first_name = first_name.getText();
		er.mid_name = middle_name.getText();
		er.last_name = last_name.getText();
		er.addr_line_1 = addr_line_1.getText();
		er.addr_line_2 = addr_line_2.getText();
		er.city = city.getText();
		er.state = state.getText();
		er.zip_code = zip_code.getText();
	}

//****************************************************************************
//* action                                                                   *
//****************************************************************************

	public boolean
	action( Event event, Object arg )
	{
		//	AwareTextFields generate ACTION_EVENTs when changed...
		if ( event.target instanceof AwareTextField )
		{
			//	Data change notification, pass it up...
			event.target = this;
			getParent().postEvent( event );

			//	Enable save...
			saveButton.enable();
			newButton.disable();

			return( true );
		}

		//	Bubble events up to my parent...
		if ( event.target == newButton || event.target == saveButton )
		{
			//	Disable a save on new...
			if ( event.target == newButton )
				saveButton.disable();

			getParent().postEvent( event );
			return( true );
		}

		return( false );
	}

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	//{{DECLARE_CONTROLS
	Label fnLabel;
	Label mnLabel;
	Label lnLabel;
	Label addrLabel;
	Label cityLabel;
	Label stateLabel;
	Label zipLabel;
	AwareTextField first_name;
	AwareTextField middle_name;
	AwareTextField last_name;
	AwareTextField addr_line_1;
	AwareTextField addr_line_2;
	AwareTextField city;
	AwareTextField state;
	AwareTextField zip_code;
	Label idLabel;
	AwareTextField emp_id;
	Button newButton;
	Button saveButton;
	//}}

}
