//****************************************************************************
//*                                                                          *
//*   Jiflet: Employee.java                                                  *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: Employee Maintenance                                           *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

//	JIF Imports
import 							jif.jiflet.*;
import							jif.widgets.*;
import							jif.sql.*;
import							jif.awt.*;

//	Java Imports
import 							java.awt.*;
import 							java.sql.*;

//	JDBC Imports
import							imaginary.sql.*;

//****************************************************************************
//* Employee                                                                 *
//****************************************************************************

public class
Employee extends Jiflet
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	//	A message for the about box...
	final static String			copyright = "Employee Maintenance v1.00\nCopyright (c) 1996 by Jerry Ablan\nAll Rights Reserved";

	//	Menu stuff...
    Menu 						fileMenu;
    Menu 						editMenu;
    Menu 						helpMenu;

	//	Our employee maintenance panel...
	EmployeeUI					myPanel;

	//	Our employee record...
	EmployeeRecord				myRecord = new EmployeeRecord();

//****************************************************************************
//* main                                                                     *
//****************************************************************************

    public static void
	main( String args[] )
	{
		Jiflet j = new Employee( args );
    }

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	public
	Employee( String args[] )
	{
		 super( "Employee Maintenance", "Employee", args );
	}

//****************************************************************************
//* init                                                                     *
//****************************************************************************

	public void
	init()
	{
		//	Initialize my menus...
        initializeMenus();

		//	Initialize my UI...
		initializeUI();
	}

//****************************************************************************
//* initializeMenus                                                          *
//****************************************************************************

	public void
	initializeMenus()
	{
        MenuBar mb = new MenuBar();

        fileMenu = new Menu( "&File", true );
        fileMenu.add( new MenuItem( "&Connect" ) );
        fileMenu.add( new MenuItem( "Pick &Employee" ) );
        fileMenu.addSeparator();
        fileMenu.add( new MenuItem( "E&xit" ) );
		mb.add( fileMenu );

        editMenu = new Menu( "&Edit" );
        editMenu.add( new MenuItem( "&Undo" ) );
        editMenu.addSeparator();
        editMenu.add( new MenuItem( "Cu&t" ) );
        editMenu.add( new MenuItem( "&Copy" ) );
        editMenu.add( new MenuItem( "&Paste" ) );
        mb.add( editMenu );

        helpMenu = new Menu( "&Help" );
        helpMenu.add( new MenuItem( "&About..." ) );
        mb.add( helpMenu );
		mb.setHelpMenu( helpMenu );

		setMenuBar( mb );
	}

//****************************************************************************
//* initializeUI                                                             *
//****************************************************************************

	public void
	initializeUI()
	{
		//	Resize myself..
		resize( 475, 275 );

		//	Setup my maintenance screen...
		myPanel = new EmployeeUI();
		add( "Center", myPanel );
	}

//****************************************************************************
//* connectToDatabase                                                        *
//****************************************************************************

	public void
	connectToDatabase()
	{
		//	Don't bother if we are connected...
		if ( !getConnector().connected() )
		{
			//	Start waiting...
			startWait();

			//	Disable the menu for the duration...
			fileMenu.getItem( 0 ).disable();
			setStatus( "Connecting to database..." );

			//	Make the connection...
			if ( getConnector().connect( "munster", "", "mars.mcs.net", 4333, "dia" ) )
			{
				//	Enable the new menu item...
				fileMenu.getItem( 0 ).enable();
				fileMenu.getItem( 0 ).setLabel( "&Disconnect" );

				//	Show a status...
				setStatus( "Connected!" );
			}
			else
				setStatus( "Connection failed!" );

			//	We're done!
			endWait();
		}
	}

//****************************************************************************
//* disconnectFromDatabase                                                   *
//****************************************************************************

	public void
	disconnectFromDatabase()
	{
		//	Don't bother if we are not connected...
		if ( getConnector().connected() )
		{
			//	Start waiting...
			startWait();

			//	Disable the menu for the duration...
			fileMenu.getItem( 0 ).disable();
			setStatus( "Disconnecting from database..." );

			//	Make the connection...
			if ( getConnector().disconnect() )
			{
				//	Enable the new menu item...
				fileMenu.getItem( 0 ).enable();
				fileMenu.getItem( 0 ).setLabel( "&Connect" );

				//	Show a status...
				setStatus( "Disconnected!" );
			}
			else
				setStatus( "Disconnection failed!" );

			//	We're done!
			endWait();
		}
	}

//****************************************************************************
//* action                                                                   *
//****************************************************************************

    public boolean
	action( Event event, Object arg )
	{
		//	Change notification from my kid...
		if ( event.target == myPanel )
		{
			myPanel.saveButton.enable();
			myRecord.setDataChange( true );
			return( true );
		}

		//	Handle on screen buttons...
		if ( event.target == myPanel.saveButton )
		{
			//	Move the data back to the EmployeeRecord...
			myPanel.getRecord( myRecord );

			//	Save it...
			if ( myRecord.update( getConnector(), myPanel ) )
			{
				//	Swap buttons...
				myPanel.newButton.enable();
				myPanel.saveButton.disable();

				//	Indicate that it was saved...
				myRecord.setDataChange( false );
			}

			return( true );
		}

		//	Handle picklist events...
		if ( event.target instanceof EmployeePickList )
		{
			int		rv = ( ( Integer )arg ).intValue();

			if ( rv != -1 )
			{
				//	Set our current record...
				myRecord = ( ( EmployeePickList ) event.target ).getRecord( rv );

				//	Display it on the screen...
				myPanel.setRecord( myRecord );
			}

			//	Kill the dialog box...
			( ( EmployeePickList ) event.target ).hide();
			( ( EmployeePickList ) event.target ).dispose();

			//	We handled it...
			return( true );
		}

		//	Handle menu events...
		if ( event.target instanceof MenuItem )
			if ( handleMenuEvents( event, arg ) )
				return( true );

        return( super.action( event, arg ) );
    }

//****************************************************************************
//* handleMenuEvents                                                         *
//****************************************************************************

	protected boolean
	handleMenuEvents( Event event, Object arg )
	{
		String label = ( String ) arg;

		if ( label.equalsIgnoreCase( "&About..." ) )
		{
            OkDialog id = new OkDialog( this, "About...", copyright );
            id.center( true );
            id.show();
            return( true );
        }
		else if ( label.equalsIgnoreCase( "E&xit" ) )
		{
			ResponseDialog rd = new ResponseDialog( this, "Confirmation", "Really quit this program?", "Yes", "No", null );
			rd.center( false );
			rd.show();
            return( true );
        }
		else if ( label.equalsIgnoreCase( "&Connect" ) )
		{
			connectToDatabase();
            return( true );
        }
		else if ( label.equalsIgnoreCase( "&Disconnect" ) )
		{
			disconnectFromDatabase();
            return( true );
        }
		else if ( label.equalsIgnoreCase( "Pick &Employee" ) )
		{
			startWait();
			EmployeePickList epl = new EmployeePickList( this, getConnector() );
			epl.center( true );
			epl.show();
			endWait();
            return( true );
        }

		//	Didn't handle it!
		return( false );
	}

}
