$PBExportHeader$u_tabcontrol.sru
$PBExportComments$ObjectStart tab control - 2D flavor
forward
global type u_tabcontrol from u_custombase
end type
type dw_tab from datawindow within u_tabcontrol
end type
end forward

global type u_tabcontrol from u_custombase
int Width=1418
int Height=857
event getfocus pbm_setfocus
dw_tab dw_tab
end type
global u_tabcontrol u_tabcontrol

type variables
protected:
int         fullwidth, fullheight
int         tabswidth, tabsheight
int         tabgap
int         xrowoffset, yrowoffset
int         xpaneoffset, ypaneoffset
int         xtextoffset, ytextoffset
int         xcoveroffset, ycoveroffset
int         xmargin, ymargin
int         numrows, numcols
int         tabsinrow[9]
int         currentrow, currentcol
int         panewidth, paneheight
int         panex, paney
int         scanrow, scancol
int         coverheight
int         textheight		
long        foldercolor, backgroundcolor

string	panelabel[9,9]
string      paneclass[9,9]
w_tabPane	panewindow[9,9]
boolean     resizepane[9,9]
boolean     openpane[9,9]
boolean     tabenabled[9,9]
boolean     movepane[9,9]
w_tabpane	currPane
boolean     abortPaneChange
w_windowbase	wparent

n_container	sharedData
end variables

forward prototypes
public function string getcurrentpanelabel ()
public function boolean setpanefromlabel (string alabel)
public subroutine abortpanechange ()
public function int resize (int newwidth, int newheight)
protected function string resizeroundrectangle (string name, int newx, int newy, int neww, int newh)
public function integer initialize (string atabspec)
protected function string hideobject (string name)
protected function string showobject (string name)
protected function string hideroundrectangle (string name)
private function int dwclicked ()
public function w_tabpane getnextpane ()
protected function int showtab (int row, int col)
protected function int opentab (int row, int col)
public subroutine openalltabs ()
public function int disabletab (string alabel)
public function int enabletab (string alabel)
public function int move (int newx, int newy)
protected subroutine setgeometry ()
protected function string roundrectangle (string name, int x, int y, int w, int h, int cornerrad, string scolor, string pcolor, string pw)
protected function string resizecoverrectangle (int newx, int newy, int neww, int newh)
protected function string coverrectangle (int x, int y, int w, int h, string color)
public subroutine acceleratorkey ()
public subroutine getfocus ()
protected function boolean checkacceleratorkey (int row, int col)
public function w_tabpane getcurrentpane ()
public function w_tabpane getpanefromlabel (string apanename)
protected function boolean getcoordsfromlabel (string alabel, ref int xcoord, ref int ycoord)
protected function int selecttab (int row, int col)
protected function string resizeobject (string name, int newx, int newy, int neww, int newh)
protected function string showroundrectangle (string name)
public function int hide ()
public function int show ()
public function w_tabpane getfirstpane ()
public subroutine setparentwindow (w_windowbase awindow)
public function w_windowbase getparentwindow ()
public subroutine setnumber (string dataName, real data)
public subroutine setobject (string dataName, powerobject data)
public subroutine setstring (string dataName, string data)
public function real getnumber (string dataName)
public function powerobject getobject (string dataName)
public function string getstring (string dataName)
end prototypes

on getfocus;call u_custombase::getfocus;//
// u_tabcontrol Event getfocus inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Description: Get the item hilighted.

IF IsValid(this.currPane) THEN this.currpane.SetFocus()

end on

public function string getcurrentpanelabel ();//
// u_tabcontrol Function getcurrentpanelabel inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     NONE
// 
// Result: string
//
// Description: Return the label from the current pane.

return panelabel[this.currentrow,this.currentcol]
	
end function

public function boolean setpanefromlabel (string alabel);//
// u_tabcontrol Function setpanefromlabel inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string alabel
// 
// Result: boolean
//
// Description: Set the pane given a label.

int i,j

IF this.getcoordsfromlabel(alabel,i,j) THEN
	return this.selecttab(i,j) <> -1
END IF

return false
end function

public subroutine abortpanechange ();//
// u_tabcontrol Subroutine abortpanechange inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     	NONE
// 
// Description: Do not perform the current pane change.

this.abortPaneChange = TRUE
end subroutine

public function int resize (int newwidth, int newheight);//
// u_tabcontrol Function resize inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     intnewwidth
//     int newheight
// 
// Result: int
//
// Description: Resize a tab pane.

string dwsyntax, si, errtext
int numtabs, tabx, taby, tabw, tabh
int textx, textw
string tabname
int folderx, foldery, folderw, folderh
int coverx, coverw
int tabwidth, i, j, k

SetPointer(Hourglass!)

super::Resize(newwidth,newheight)
dw_tab.Resize(newwidth,newheight)

IF NOT IsValid(this.CurrPane) THEN return -1

this.SetGeometry()

dwsyntax = 'datawindow.detail.height=' + string(this.fullheight) + ' '

tabh = this.tabsheight

FOR i=this.numRows TO 1 step -1
	si="tab" + string(i)
	taby = this.yrowoffset*(this.numrows - i) + this.ymargin
	k = this.currentrow + i - 1
	IF k > this.numrows THEN k -= this.numrows
	numtabs = this.tabsinrow[k]
	tabwidth = (this.tabswidth + this.tabgap)/numtabs
	tabx = this.xmargin + this.xrowoffset*(i - 1)
	tabw = tabwidth - this.tabgap
	textx = tabx + this.xtextoffset
	textw = tabw - 2*this.xtextoffset

	FOR j=1 TO numtabs
		tabname = si + string(j)
		dwsyntax = dwsyntax + this.ResizeRoundrectangle(tabname, tabx, -1, tabw, tabh)
		dwsyntax = dwsyntax + this.ResizeObject(tabname + 'text', textx, -1, textw, -1)
		this.resizepane[k,j] = true
		tabx += tabwidth
		textx += tabwidth
	NEXT
	
	FOR j = numtabs+1 TO this.numcols
		dwsyntax = dwsyntax + this.ResizeRoundRectangle(si + string(j), -1, -1, -1, tabh)
	NEXT
NEXT

numtabs = this.tabsinrow[this.currentrow]
tabwidth = (this.tabswidth + this.tabgap)/numtabs

folderh = this.tabsheight - this.yrowoffset
folderw = tabwidth*numtabs - this.tabgap
dwsyntax = dwsyntax + this.ResizeRoundrectangle("folder", -1, -1, folderw, folderh)

coverx = tabwidth*(this.currentcol - 1) + this.xcoveroffset + this.xmargin
coverw = tabwidth - this.tabgap - 2* this.xcoveroffset
dwsyntax = dwsyntax + this.ResizeCoverRectangle(coverx, -1, coverw, -1)

dwsyntax = dwsyntax + 'i.x="' + string(tabswidth + 20) + '" '

this.currpane.visible = false
errtext = dw_tab.dwModify(dwsyntax)

this.currpane.Resize(this.panewidth, this.paneheight)
this.resizepane[this.currentrow,this.currentcol] = false
this.currpane.visible = true
this.currpane.SetFocus()

IF errtext <> "" THEN
	messagebox("dwmodify", errtext + "~r" + dwsyntax)
	return -1
ELSE
	return 0
END IF
end function

protected function string resizeroundrectangle (string name, int newx, int newy, int neww, int newh);//
// u_tabcontrol Function resizeroundrectangle inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
//     int newx
//     int newy
//     int neww
//     int newh
// 
// Result: string
//
// Description: Resize the objects in a rectangle.

return this.resizeobject(name,newx,newy,neww,newh)

end function

public function integer initialize (string atabspec);//
// u_tabcontrol Function initialize inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string atabspec
// 
// Result: int
//
// Description: Initialize the tab control and its window.

string dwsyntax, scolor, bcolor, si, errtext, rowspec[], panestring
int tabx, taby, tabw, tabh
string textx, texty, textw, texth, tabname
int folderx, foldery, folderw, folderh
int coverx, covery, coverw, coverh
int tabwidth, i, j, k
string temp 
n_fieldstring fs

// make sure that the parent window is known
IF NOT IsValid(this.wparent) THEN return -1

// load tab data from arguments
fs = create n_fieldstring
fs.Initialize(atabspec,"~n")

this.numRows = fs.AsArray(rowspec[])
IF this.numrows < 1 THEN return -1
IF this.numrows > 9 THEN return -1

FOR i = 1 TO this.numrows
	j = 0
	fs.Initialize(rowspec[i],"~t")
	DO
		temp = Trim(fs.CurrentField())
		IF temp = "" THEN exit
		j++
		this.panelabel[i,j] = temp
		fs.NextField()
		this.paneClass[i,j] = Trim(fs.CurrentField())
		this.openpane[i,j] = true
		this.tabenabled[i,j] = true
		fs.NextField()
	LOOP UNTIL temp = ""
	IF j = 0 THEN return -1
	IF j > 9 THEN return -1
	this.tabsInRow[i] = j
	IF j > this.numCols THEN this.numCols = j
NEXT
IF this.numcols < 1 THEN return -1

// set colors
this.foldercolor = this.backColor
this.backgroundcolor = this.wparent.backColor
this.backcolor = this.backgroundcolor

scolor=string(this.foldercolor)
bcolor=string(this.backgroundcolor)

this.SetGeometry()

tabh = this.tabsheight
tabwidth = (this.tabswidth + this.tabgap)/this.numcols
tabw = tabwidth - this.tabgap

texth = string(this.textheight)
textw = string(tabw - 2*this.xtextoffset)

dwsyntax='release 4; datawindow(units=1 color=' + bcolor + ') detail(height=' + &
	string(this.fullheight) + ' color="536870912") table(column=(type=char(10) name=i dbname="i"))'

FOR i=this.numRows TO 1 step -1
	si = "tab" + string(i)
	taby = this.yMargin + this.yrowoffset*(this.numRows - i)
	texty = string(taby + this.ytextoffset)

	FOR j=1 TO this.numCols
		tabname = si + string(j)
		tabx = this.xmargin + this.xrowoffset*(i - 1) + tabwidth*(j - 1)
		textx = string(tabx + this.xtextoffset)

		dwsyntax = dwsyntax + this.Roundrectangle(tabname, tabx, taby, tabw, tabh, 15, scolor, "0", "1")

		dwsyntax = dwsyntax + &
			' text(band=detail color="33554432" alignment="2" border="0" x="' + &
			textx + '" y="' + texty + '" height="'+ texth +'" width="'+ textw + &
			'" text="' + this.panelabel[i,j] + '" name=' + tabname + &
			'text font.face="MS Sans Serif" font.height="-8" font.weight="400" ' + &
			' font.family="2" font.pitch="2" font.charset="0" background.mode="2" background.color="' + &
			scolor + '") ' 
	NEXT
NEXT

folderx = this.xmargin
foldery = this.ymargin + this.yrowoffset*this.numRows
folderh = this.tabsheight - this.yrowoffset
folderw = this.tabswidth - this.tabgap

dwsyntax = dwsyntax + this.Roundrectangle("folder", folderx, foldery, folderw, folderh, 15, scolor, "0", "1")

coverx = this.xcoveroffset + this.xmargin
covery = this.yrowoffset*this.numRows - this.ycoveroffset + this.ymargin
coverh = this.coverheight
coverw = tabwidth - this.tabgap - 2*this.xcoveroffset

dwsyntax = dwsyntax + this.CoverRectangle(coverx,covery,coverw,coverh,scolor)
 
dwsyntax = dwsyntax + ' column(band=detail id=1 border="0" alignment="0" color="16777215" height="1" width="1" x="' + &
   string(tabswidth + 20) + &
   '" y="100"  name=i format="[general]" edit.displayonly=no font.face="MS Sans Serif" font.height="-8" font.weight="400"' + &
   ' font.family="2" font.pitch="2" font.charset="0" background.mode="2" background.color="16777215") ' 


IF dw_tab.dwCreate(dwsyntax, errtext) < 0 THEN
	messagebox("dwcreate failed",dwsyntax + " ~r" + errtext)
	return -1
END IF

i=dw_tab.insertrow(0)
dw_tab.dwModify("i.Visible='0'")

this.currentrow=0
this.currentcol=0
IF this.ShowTab(1,1) < 0 THEN return -1

this.currpane.TriggerObjectStartEvent("paneactive")

return 0
end function

protected function string hideobject (string name);//
// u_tabcontrol Function hideobject inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
// 
// Result: string
//
// Description: HIde the named object.

return name + '.visible="0" '

end function

protected function string showobject (string name);//
// u_tabcontrol Function showobject inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
// 
// Result: string
//
// Description: Make an object visible.

return name + '.visible="1" '
end function

protected function string hideroundrectangle (string name);//
// u_tabcontrol Function hideroundrectangle inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
// 
// Result: string
//
// Description:  HIde the objects in a rectangle.

return this.HideObject(name)
end function

private function int dwclicked ();//
// u_tabcontrol Function dwclicked inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     NONE
// 
// Result: int
//
// Description: If the tab has been clicked...

int row, col
string dwobject

dwobject=dw_tab.dwGetObjectAtPointer( )

IF dwobject <> "" THEN
	IF left(dwobject,3) = 'tab' THEN
		row = integer(mid(dwobject,4,1)) + this.currentrow - 1
		IF row > this.numrows THEN row -= this.numrows
 		col = integer(mid(dwobject,5,1))
		IF ((row <> this.currentrow) OR (col <> this.currentcol)) THEN
			IF this.tabenabled[row,col] THEN
				this.selecttab(row, col)
				return 1
			END IF
		END IF
	END IF
END IF

return -1
end function

public function w_tabpane getnextpane ();//
// u_tabcontrol Function getnextpane inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     NONE
// 
// Result: w_tabpane
//
// Description: Get the next pane.

w_tabpane result

CHOOSE CASE this.scanrow
	CASE 0
		this.scanrow = 1
		this.scancol = 0
	CASE is > this.numrows
		return result
END CHOOSE
      
DO
	this.scancol++
	IF this.scancol > this.tabsinrow[this.scanrow] THEN
		this.scanrow++
		IF this.scanrow > this.numrows THEN return result
		this.scancol = 1
	END IF

	result = this.panewindow[this.scanrow,this.scancol] 
LOOP UNTIL IsValid(result)

return result
end function

protected function int showtab (int row, int col);//
// u_tabcontrol Function showtab inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     introw
//     int col
// 
// Result: int
//
// Description: Display a tab.

int i, j, k, z, numtabs
string dwsyntax, errtext, name, tabname, textcolor
int tabwidth, tabx, taby, tabw, tabh, textx, texty, textw, texth
int coverx, coverw, coverh

IF this.currentcol > 0 THEN
   dwsyntax = 'tab1' + string(this.currentcol) + 'text.font.weight = "400" '
END IF

dwsyntax=dwsyntax + 'tab1' + string(col) + 'text.Font.Weight="700"'

// adjust all tabs if the new tab is not in the front row

IF row <> this.currentrow THEN
	FOR i=1 TO this.numrows
		k = i + row - 1
		IF k > this.numrows THEN k -= this.numrows
		name = " tab" + string(i)
		numtabs = this.tabsInRow[k]
		tabwidth = (this.tabswidth + this.tabgap)/numtabs
		tabx = this.xrowoffset*(i - 1) + this.xmargin
		tabw = tabwidth - this.tabgap
		textx = tabx + this.xtextoffset
		textw = tabw - 2*this.xtextoffset

		FOR j=1 TO numtabs
			tabname = name + string(j)
			IF tabenabled[k,j] THEN
				textcolor = "0"
			ELSE
				textcolor = "6908265"
			END IF
			dwsyntax = dwsyntax + this.resizeroundrectangle(tabname,tabx,-1,tabw,-1) + &
				this.resizeobject(tabname + "text",textx,-1,textw,-1) + &
				tabname + 'text.text="' + this.panelabel[k,j] + '" ' + &
				tabname + 'text.color="' + textcolor + '" ' + &
				this.showroundrectangle(tabname) + this.showobject(tabname + 'text')
			tabx += tabwidth
			textx += tabwidth
		NEXT

		FOR j=numtabs+1 TO this.numcols
			tabname = name + string(j)
			dwsyntax = dwsyntax + this.hideroundrectangle(tabname) + &
				this.hideobject(tabname + 'text')
		NEXT
	NEXT
END IF

numtabs = this.tabsinrow[row]
tabwidth = (this.tabswidth + this.tabgap)/numtabs
coverx = tabwidth*(col - 1) + this.xcoveroffset + this.xmargin
coverw = tabwidth - this.tabgap - 2*this.xcoveroffset

CHOOSE CASE col
CASE 1
	coverh = 1
CASE numtabs
	coverh = 3
CASE else
	coverh = 2
END CHOOSE

dwsyntax = dwsyntax + resizeCoverRectangle(coverx, -1, coverw, coverh) + &
	resizeroundrectangle("folder",-1,-1,tabwidth*numtabs - this.tabgap,-1)

errtext=dw_tab.dwmodify(dwsyntax)
 
IF errtext <> "" THEN
	ClipBoard(errtext + "~r" + dwsyntax)
	messagebox("dwmodify error",dwsyntax + "~r" +errtext)
	return -1
END IF

IF this.openpane[row,col] THEN
	IF this.OpenTab(row,col) < 0 THEN
		return -1
	END IF     
END IF

// hide the old pane
IF IsValid(this.currPane) THEN
	this.currPane.Visible = false
END IF

this.currPane = this.panewindow[row,col]
IF this.movepane[row,col] THEN
	this.currpane.move(this.panex,this.paney)
	this.movepane[row,col] = false
END IF

IF this.resizepane[row,col] THEN
	this.currpane.resize(this.panewidth,this.paneheight)
	this.resizepane[row,col] = false
END IF

this.currPane.Visible = true
this.currPane.Enabled = true
this.currPane.SetFocus()
this.currentrow = row
this.currentcol = col
 
return 1
end function

protected function int opentab (int row, int col);//
// u_tabcontrol Function opentab inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     introw
//     int col
// 
// Result: int
//
// Description: Open a tab pane.

w_tabpane temppane
int ret

SetRedraw(false)
ret = OpenWithParm(temppane, this, this.paneclass[row,col], this.wparent)
IF ret > 0 THEN
	this.panewindow[row,col] = temppane
	temppane.visible = false
	temppane.x = this.panex
	temppane.y = this.paney
	temppane.Resize(this.panewidth,this.paneheight)
	 temppane.BackColor = this.foldercolor
END IF

SetRedraw(true)
this.openpane[row,col] = false
this.resizepane[row,col] = false
this.movepane[row,col] = false

return ret
end function

public subroutine openalltabs ();//
// u_tabcontrol Subroutine openalltabs inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     	NONE
// 
// Description: Open all of the tab panels.

int i, j, numtabs

FOR i = 1 TO numrows
	numtabs = tabsinrow[i]
	FOR j = 1 TO numtabs
		IF this.openpane[i,j] THEN
			this.OpenTab(i,j)
		END IF
	NEXT
NEXT

         

end subroutine

public function int disabletab (string alabel);//
// u_tabcontrol Function disabletab inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string alabel
// 
// Result: int
//
// Description: Disble a tab control.

int row, col
string dwsyntax

IF this.getcoordsfromlabel(alabel,row,col) THEN
	IF this.tabenabled[row,col] THEN
		this.tabenabled[row,col] = false
		row += this.currentrow - 1
		IF row > this.numrows THEN row -= this.numrows
			dwsyntax = 'tab' + string(row) + string(col) + 'text.color="6908265"'
			dw_tab.dwModify(dwsyntax)
		END IF
		RETURN 1
	ELSE
	return -1
END IF
end function

public function int enabletab (string alabel);//
// u_tabcontrol Function enabletab inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string alabel
// 
// Result: integer
//
// Description: Enable a tab control.

int row, col
string dwsyntax

IF this.getcoordsfromlabel(alabel,row,col) THEN
	IF NOT this.tabenabled[row,col] THEN
		this.tabenabled[row,col] = true
		row += this.currentrow - 1
		IF row > this.numrows THEN row -= this.numrows
		dwsyntax = 'tab' + string(row) + string(col) + 'text.color="0"'
		dw_tab.dwModify(dwsyntax)
	END IF
	return 1
ELSE
	return -1
END IF
end function

public function int move (int newx, int newy);//
// u_tabcontrol Function move inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     intnewx
//     int newy
// 
// Result: int
//
// Description: Move the current pane.

int i, j, numtabs, ret = 1

super::move(newx,newy)

this.SetGeometry()

FOR i = 1 TO this.numrows
	numtabs = this.tabsinrow[i]
	FOR j = 1 TO numtabs
		this.movepane[i,j] = true
	NEXT
NEXT

IF isValid(this.currpane) THEN
	ret = this.currpane.move(this.panex, this.paney)
	this.movepane[this.currentrow, this.currentcol] = false
END IF

return ret
end function

protected subroutine setgeometry ();//
// u_tabcontrol Subroutine setgeometry inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     	NONE
// 
// Description: Set the windows boundaries.

this.fullwidth = UnitsToPixels(dw_tab.width, XUnitsToPixels!)
this.fullheight = UnitsToPixels(dw_tab.height, YUnitsToPixels!)

this.tabswidth = &
	this.fullwidth  - 2*this.xMargin - this.xRowOffset*(this.numrows - 1)
this.tabsheight = &
	this.fullheight - 2*this.yMargin - this.yRowOffset*(this.numrows - 1)

this.panewidth = &
	PixelsToUnits(this.tabswidth - 2*this.xPaneOffset, &
	XPixelsToUnits!)
this.paneheight = &
	PixelsToUnits(this.tabsheight - 2*this.yPaneOffset - &
	this.yRowOffset,YPixelsToUnits!)

this.panex = this.x + dw_tab.x + &
	PixelsToUnits(this.xMargin + this.xPaneOffset,XPixelsToUnits!)
this.paney = this.y + dw_tab.y + &
	PixelsToUnits(this.yMargin + this.yPaneOffset + &
	this.numrows*this.yRowOffset,YPixelsToUnits!)

return
end subroutine

protected function string roundrectangle (string name, int x, int y, int w, int h, int cornerrad, string scolor, string pcolor, string pw);   string rad
//
// u_tabcontrol Function roundrectangle inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     stringname
//     int x
//     int y
//     int w
//     int h
//     integer cornerrad
//     string scolor
//     string pcolor
//     string pw
// 
// Result: string
//
// Description: Define a rectangle.

rad = string(cornerrad)
return ' roundrectangle(band=detail x="' + &
	string(x) + '" y="' + string(y) + '" height="' + string(h) + &
	'" width="' + string(w) + '" ellipseheight="' + rad + '" ellipsewidth="' + rad + '" name=' + &
	name + ' brush.hatch="6" brush.color="' + scolor + &
	'" pen.style="0" pen.width="' + pw + '" pen.color="' + pcolor + &
	'" background.mode="2" background.color="-2147483648") '







end function

protected function string resizecoverrectangle (int newx, int newy, int neww, int newh);//
// u_tabcontrol Function resizecoverrectangle inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     int newx
//     int newy
//     int neww
//     int newh
// 
// Result: string
//
// Description: Resize a rectangle.

int h

CHOOSE CASE newh
	CASE -1
		h = -1
	CASE 2
		h = this.coverheight - 3 
	CASE ELSE
		h = this.coverheight
END CHOOSE 

return resizeObject("cover", newx, newy, neww, h)
end function

protected function string coverrectangle (int x, int y, int w, int h, string color);//
// u_tabcontrol Function coverrectangle inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     int x
//     int y
//     int w
//     int h
//     string color
// 
// Result: string
//
// Description: Cover the region with color.

return ' rectangle(band=detail x="' + string(x) + &
	'" y="' + string(y) + '" height="' + string(h) + '" width="' + &
	string(w) + '" name=cover  brush.hatch="6" brush.color="' + &
	color + '" pen.style="0" pen.width="1" pen.color="' + color + &
	'" background.mode="2" background.color="-2134851392") '
end function

public subroutine acceleratorkey ();//
// u_tabcontrol Subroutine acceleratorkey inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     	NONE
// 
// Description: Check for accelerator key on a tab, starting at the
//	right of the current tab and then looping around until we find
//	one.

int row, col, firstcol, lastcol, firstrow, lastrow
row = this.currentrow
firstcol = this.currentcol + 1
lastcol = this.tabsinrow[row]

FOR col = firstcol TO lastcol
	IF this.CheckAcceleratorKey(row,col) THEN
		this.SelectTab(row,col)
		return
	END IF
NEXT

firstrow = this.currentrow + 1
lastrow = this.numrows
FOR row = firstrow TO lastrow
	firstcol = 1
	lastcol = this.tabsinrow[row]
	FOR col = firstcol TO lastcol
		IF this.CheckAcceleratorKey(row,col) THEN
			this.SelectTab(row,col)
			return
		END IF
	NEXT
NEXT

firstrow = 1
lastrow = this.currentrow - 1
FOR row = firstrow TO lastrow
	firstcol = 1
	lastcol = this.tabsinrow[row]
	FOR col = firstcol TO lastcol
		IF this.CheckAcceleratorKey(row,col) THEN
			this.SelectTab(row,col)
			return
		END IF
	NEXT
NEXT
row = this.currentrow
firstcol = 1
lastcol = this.currentcol - 1
for col = firstcol to lastcol
  if this.CheckAcceleratorKey(row,col) then
      this.SelectTab(row,col)
      message.processed = true
      return
  end if
next

// if it was not one of those then check for alt-arrow keys

row = this.currentrow
col = this.currentcol
if keydown(keyrightarrow!) then
   do
      if col < tabsinrow[row] then
         col += 1
      else
         col = 1
         if row < this.numrows then
            row += 1
         else 
            row = 1
         end if
      end if
   loop until this.tabenabled[row,col] or (row=this.currentrow and col=this.currentcol)
elseif keydown(keyleftarrow!) then
   do
      if col > 1 then
         col -= 1
      else
         if row > 1 then
            row -= 1
         else
            row = this.numrows
         end if
         col = this.tabsinrow[row]
      end if
   loop until this.tabenabled[row,col] or (row=this.currentrow and col=this.currentcol)
elseif keydown(keyuparrow!) then
   do
      if row < this.numrows then
         row += 1
      else
         row = 1
      end if
      choose case this.currentcol
      case 1
         col = 1
      case this.tabsinrow[this.currentrow]
         col = this.tabsinrow[row]
      case else
         col = Int(this.currentcol*this.tabsinrow[row]/this.tabsinrow[this.currentrow] + 0.4)
      end choose
   loop until this.tabenabled[row,col] or row=this.currentrow
elseif keydown(keydownarrow!) then
   do
      if row > 1 then
         row -= 1
      else 
         row = this.numrows
      end if
      choose case this.currentcol
      case 1
         col = 1
      case this.tabsinrow[this.currentrow]
         col = this.tabsinrow[row]
      case else
         col = Int(this.currentcol*this.tabsinrow[row]/this.tabsinrow[this.currentrow] + 0.4)
      end choose
   loop until this.tabenabled[row,col] or row=this.currentrow
end if

if row <> this.currentrow or col <> this.currentcol then
   this.selecttab(row,col)
end if

return
end subroutine

public subroutine getfocus ();//
// u_tabcontrol Subroutine getfocus inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     	NONE
// 
// Description: A tab can never have focus.  Give focus to
//	the window associated with the tab.

this.currpane.setfocus()

return
end subroutine

protected function boolean checkacceleratorkey (int row, int col);//
// u_tabcontrol Function checkacceleratorkey inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     int row
//     int col
// 
// Result: boolean
//
// Description: Look for an accelerator key.

string label
int kpos, char

IF this.tabenabled[row,col] THEN
	label = this.panelabel[row,col]
	DO UNTIL label = ""
		kpos = Pos(label, "&")
		IF kpos > 0 THEN
			label = Mid(label,kpos+1)
			IF Left(label,1) = "&" THEN
				label = Mid(label,2)
			ELSEIF label <> "" THEN
				return Keydown(Asc(Upper(label)))
			END IF
		ELSE
			label = ""
		END IF
	LOOP
END IF

return false

end function

public function w_tabpane getcurrentpane ();//
// u_tabcontrol Function getcurrentpane inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     NONE
// 
// Result: w_tabpane
//
// Description: Return the current pane.

return this.currPane


end function

public function w_tabpane getpanefromlabel (string apanename);//
// u_tabcontrol Function getpanefromlabel inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string apanename
// 
// Result: w_tabpane
//
// Description: Get the pane given its name.

int i,j
w_tabpane pwin

FOR i = 1 TO this.numrows
	FOR j = 1 TO this.numcols
		IF this.panelabel[i,j] = apanename THEN
			return this.panewindow[i,j]
		END IF
	NEXT
NEXT

return pwin


end function

protected function boolean getcoordsfromlabel (string alabel, ref int xcoord, ref int ycoord);//
// u_tabcontrol Function getcoordsfromlabel inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string alabel
//     ref int xcoord
//     ref int ycoord
// 
// Result: boolean
//
// Description: Get the region's coordinates from the label.

int i,j,numtabs

FOR i = 1 TO this.numrows
	numtabs = this.tabsinrow[i]
	FOR j = 1 TO numtabs
		IF panelabel[i,j] = alabel THEN
			xcoord = i
			ycoord = j
			return true
		END IF
	NEXT
NEXT

return false

end function

protected function int selecttab (int row, int col);//
// u_tabcontrol Function selecttab inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     int row
//     int col
// 
// Result: int
//
// Description: Select a tab pane.

int ret

SetPointer(HourGlass!)
this.triggerobjectstartevent(this.classname() + "_prepanechange")
IF this.abortpanechange THEN
	this.abortpanechange = false
	return -1
END IF

IF IsValid(this.currPane) THEN
	this.currPane.triggerobjectstartevent("panechange") 
	IF this.abortpanechange THEN
		this.abortpanechange = false
		return -1
	END IF
END IF

ret = this.showtab(row,col)

this.currPane.triggerobjectstartevent("paneactive")

this.triggerobjectstartevent(this.classname() + "_postpanechange")

return ret
end function

protected function string resizeobject (string name, int newx, int newy, int neww, int newh);//
// u_tabcontrol Function resizeobject inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     stringname
//     int newx
//     int newy
//     int neww
//     int newh
// 
// Result: string
//
// Description: Resize an object.

string result

IF newx > 0 THEN result = name + '.x="' + string(newx) + '" '
IF newy > 0 THEN result = result + name + '.y="' + string(newy) + '" '
IF neww > 0 THEN result = result + name + '.width="' + string(neww) + '" '
IF newh > 0 THEN result = result + name + '.height="' + string(newh) + '" '

return result

end function

protected function string showroundrectangle (string name);//
// u_tabcontrol Function showroundrectangle inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     string name
// 
// Result: string
//
// Description: Display a round rectangle.

return this.ShowObject(name)
end function

public function int hide ();//
// u_tabcontrol Function hide inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//		NONE
// 
// Result: int
//
// Description: Hide the pane.

IF IsValid(currPane) THEN
	IF currPane.Hide() = 1 THEN
		RETURN SUPER:: Hide()
	ELSE
		RETURN -1
	END IF
ELSE
	RETURN SUPER::Hide()
END IF

end function

public function int show ();//
// u_tabcontrol Subroutine show inherited from u_tabcontrol
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     	NONE
// 
// Return: int
//
// Description: Show the pane.

IF IsValid(currPane) THEN
   IF currPane.Show() = 1 THEN
      RETURN SUPER::Show()
   ELSE
      RETURN -1
   END IF
ELSE
   RETURN SUPER::Show()
END IF

end function

public function w_tabpane getfirstpane ();//
// u_tabcontrol Function getfirstpane inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     NONE
// 
// Result: window
//
// Description: Get the first pane.

this.scanrow = 0
return this.GetNextPane()
end function

public subroutine setparentwindow (w_windowbase awindow);//
// u_tabcontrol Subroutine setparentwindow inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     window awindow
// 
// Description: Set the parent window.

this.wparent = aWindow

RETURN

end subroutine

public function w_windowbase getparentwindow ();//
// u_tabcontrol Function getparentwindow inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Arguments: 
//     NONE
// 
// Result: w_windowbase
//
// Description: Return the parent window.

return this.wparent


end function

public subroutine setnumber (string dataName, real data);IF NOT IsValid(this.sharedData) THEN
   this.sharedData = CREATE n_container
END IF
this.sharedData.SetNumber(dataName,data)
RETURN
end subroutine

public subroutine setobject (string dataName, powerobject data);IF NOT IsValid(this.sharedData) THEN
   this.sharedData = CREATE n_container
END IF
this.sharedData.SetObject(dataName,data)
RETURN
end subroutine

public subroutine setstring (string dataName, string data);IF NOT IsValid(this.sharedData) THEN
   this.sharedData = CREATE n_container
END IF
this.sharedData.SetString(dataName,data)
RETURN
end subroutine

public function real getnumber (string dataName);real result

IF IsValid(this.sharedData) THEN
   result = this.sharedData.GetNumber(dataName)
ELSE
   SetNull(result)
END IF

RETURN result
end function

public function powerobject getobject (string dataName);powerobject result

IF IsValid(this.sharedData) THEN
   result = this.sharedData.GetObject(dataName)
END IF

RETURN result
end function

public function string getstring (string dataName);string result

IF IsValid(this.sharedData) THEN
   result = this.sharedData.GetString(dataName)
ELSE
   SetNull(result)
END IF

RETURN result
end function

on constructor;call u_custombase::constructor;//
// u_tabcontrol Event constructor inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Description: Initialize the object.

dw_tab.x = 0
dw_tab.y = 0
dw_tab.width = this.width
dw_tab.height = this.height
this.border = false
this.abortpanechange = false
this.xrowoffset = 15
this.yrowoffset = 17
this.xpaneoffset = 4
this.ypaneoffset = 4
this.xtextoffset = 4
this.ytextoffset = 2
this.xcoveroffset = 1
this.ycoveroffset = 0
this.xmargin = 4
this.ymargin = 4
this.tabgap = 3
this.coverheight = 6
this.textheight = 15
  
CHOOSE CASE parent.TypeOf()
	CASE Window!
	this.wparent = parent
END CHOOSE
  

end on

on u_tabcontrol.create
int iCurrent
call u_custombase::create
this.dw_tab=create dw_tab
iCurrent=UpperBound(this.Control)
this.Control[iCurrent+1]=dw_tab
end on

on u_tabcontrol.destroy
call u_custombase::destroy
destroy(this.dw_tab)
end on

type dw_tab from datawindow within u_tabcontrol
int X=23
int Y=29
int Width=37
int Height=37
int TabOrder=10
boolean Border=false
end type

on getfocus;
//
// u_tabcontrol Event getfocus inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Description:
   u_tabcontrol tabcontrol
   tabcontrol = parent
   tabcontrol.SetFocus()
end on

on clicked;
//
// u_tabcontrol Event clicked inherited from u_custombase
//
// (c) Copyright 1994 Greenbrier & Russel, Inc.,
//     All Rights Reserved
//
// Description:
   u_tabcontrol tabcontrol
   tabcontrol = parent
   if tabcontrol.dwClicked() < 0 then beep(1)
end on

