//****************************************************************************
//*                                                                          *
//*   Jiflet: OkCancelButtonBar.java                                         *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: A generic button panel                                         *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.widgets;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import 							java.awt.*;

//****************************************************************************
//* OkCancelButtonBar                                                        *
//****************************************************************************

/**
 * This class implements a standard Ok/Cancel button bar. Many dialogs
 * can use this creating a standard gawk and grope for any application.
 */

public class
OkCancelButtonBar
extends Panel
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	public Button				okButton = new Button( "&Ok" );
	public Button				cancelButton = new Button( "Cancel" );

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	/**
	 * Constructs our button panel
	 */

	public
	OkCancelButtonBar()
	{
		setFont( new Font( "Dialog", Font.PLAIN, 14 ) );
		setLayout( new FlowLayout( FlowLayout.CENTER, 20, 5 ) );
		add( okButton );
		add( cancelButton );
	}

}
