//****************************************************************************
//*                                                                          *
//*    Class: CenterDialog.java                                              *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: A dialog that knows how to center itself...                    *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.widgets;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.awt.*;

//****************************************************************************
//* CenterDialog                                                             *
//****************************************************************************

public class
CenterDialog
extends Dialog
{

//****************************************************************************
//* Constructors                                                             *
//****************************************************************************

	public
	CenterDialog( Frame parent, boolean modal )
	{
		super( parent, modal );
		initialize();
	}

	public
	CenterDialog( Frame parent, String title, boolean modal )
	{
		super( parent, title, modal );
		initialize();
	}

//****************************************************************************
//* handleEvent                                                              *
//****************************************************************************

	public boolean
	handleEvent( Event anEvent )
	{
		if ( anEvent.id == Event.WINDOW_DESTROY )
		{
			hide();
			dispose();
			return( true );
		}

		return( super.handleEvent( anEvent ) );
	}

//****************************************************************************
//* Initialize                                                               *
//****************************************************************************

	protected void
	initialize()
	{
		setFont( new Font( "Dialog", Font.PLAIN, 14 ) );
		setResizable( false );
	}

//****************************************************************************
//* center                                                                   *
//****************************************************************************

	public void
	center( boolean onScreen )
	{
		Rectangle r = bounds();

		if ( onScreen )
		{
			Dimension d = Toolkit.getDefaultToolkit().getScreenSize();

			int newX = ( d.width / 2 ) - ( r.width / 2 );
			int newY = ( d.height / 2 ) - ( r.height /2 );

			move( newX, newY );
		}
		else
			move( ( getParent().bounds().width / 2 ) - ( r.width / 2 ), ( getParent().bounds().height / 2 ) - ( r.height /2 ) );
	}
}