//=====================================================================
//
// file GUIServer.java v1.0
// see file Client.java
// jlouie 7.96
// name this file GUIServer.java and compile with javac
// c:\java\bin>javac -d . .\src\GUIServer.java
// where the source code is in c:\java\bin\src
// and the code is compiled to c:\java\bin
// and then run it from the DOS prompt
// c:\java\bin>java GUIServer
// this code was tested with Sun's JDK 1.02 for Win95,
// Netscape 2.01 Win95 and Telnet over an Ethernet HP NetServer LC network
// this code does _not_ work properly with Sun's JDK 1.02 for Mac or
// earlier versions of the Win95 JDK or Netscape 3.0b4 Mac
// to test this code telnet to 127.0.0.1 8189 from a new DOS prompt
// c:\windows>telnet 127.0.0.1 8189
// or load the Index.htm file with Netscape
// or serve the client applet on a web server and log on with Netscape
// the synchronization scheme is pre-beta!
//
// Ref: "Teach Yourself Java in 21 Days", Lemay & Perkins, Sams Net
// Ref: "Java in a Nutshell", David Flanagan, O'Reilly & Associates
// Ref: "Core Java", Cornell & Horstmann, Sunsoft Press
// Ref: "The Java Programming Language" Arnold & Gosling Addison Wesley
// General Ref: "Code Complete" Steve McConnell, Microsoft Press
//
//=====================================================================

import java.io.*;
import java.net.*;
import java.awt.*;

public class GUIServer extends Thread
{
   // protect the data
   
   private ThreadedEchoHandler threadHandler;
   private Socket so; 
   private PrintStream out;
   private static int port;
   private static ServerSocket ss;
   private static int gac; // active connections, untrusted   
   private static 
    ThreadedEchoHandler[] arrayClients= new ThreadedEchoHandler[GUIServer.MAX_CLIENTS];
      
   // class constants, declared public
   
   public final static int MAX_CLIENTS= 2;      // max number of connections, set to 10
   public final static int DEFAULT_PORT= 8189;
   public final static int MIN_PORT= 1024;
   public final static int MAX_PORT= 32767;     // what _is_ the max value?
   public final static int MAX_QUEUE= 10;       // max queue for incoming, set to 50
   
   public static void main(String[] input)
   {
      GUIServer.port=DEFAULT_PORT;
      if (input.length == 1)
      {
          try {GUIServer.port= Integer.parseInt(input[0]);}   
          catch (NumberFormatException e) {GUIServer.port= DEFAULT_PORT;}
      }
      try
      {
         if ((port < MIN_PORT ) || (port > MAX_PORT)) 
         {
            System.out.println("Illegal Port.");
            GUIServer.port= DEFAULT_PORT;
         }
         new GUIServer(port, MAX_QUEUE).start();
      }     
      catch(Exception e) 
      {
         System.out.println(e);
         System.exit(1);         
      }
   }
   
   public GUIServer(int port, int count)
   {
      try
      {
         ss= new ServerSocket(port, count);
         new ControlPanel(ss);
         System.out.println("Socker Server is up and Running on Port "+port);
         InetAddress hostIP= InetAddress.getLocalHost();
         System.out.println("Hosted on Machine " + hostIP.toString());
      }
      catch(Exception e)
      {
         System.out.println(e);
         System.exit(1);
      }
   }
   
   public void run() // thread here
   {
      int ac,dead;
      String temp="";
      
      while(true)
      {
        try
        {
                ControlPanel.SetMESS(temp + " Waiting.");
                so= null;
                so= ss.accept();
                temp= "Connection accepted.";
                synchronized(arrayClients)
                {
                         ac= 0;      // no active clients    
                        dead= -1;   // no dead clients
                        // use short circuit logical OR
                        for (int i =0; i<MAX_CLIENTS; i++)
                        {
                            if((arrayClients[i] == null)||(!arrayClients[i].isAlive()))
                            { 
                              dead= i;
                            }
                            else ac++;                           
                        }
                        if (dead != -1) // we got a dead one
                        {   
                            arrayClients[dead]= new ThreadedEchoHandler(so);
                            arrayClients[dead].start();
                            ac++;
                        }
                        else 
                        {
                            temp= "Connections full.";
                            if (so != null)
                            {
                                   try{so.close();}
                                   catch(Exception ignored) {;}
                            }                
                        }
                        ControlPanel.SetAC(Integer.toString(ac));
                        gac= ac;
                }
         }
         catch(Exception e) 
         {
                ControlPanel.SetMESS(e.toString());       
         } 
      }      
   }
   
   // encapsulate data members
   
   public static int GetPort() // read only
   {return GUIServer.port;}
   
   public static ServerSocket GetServerSocket()  // read only
   {return GUIServer.ss;}
   
   public static int GetGAC()  // global, active connections
   {return GUIServer.gac;}
   
   public static void NotifyDeath()
   {
      {if (GUIServer.gac > 0) GUIServer.gac--;}
   }
   
   public static void DisconnectAll()
   {
      // use short circuit logical AND
      synchronized(GUIServer.arrayClients)
      {
         for (int i =0; i<GUIServer.MAX_CLIENTS; i++)
         {
            if((GUIServer.arrayClients[i] != null)
              && (GUIServer.arrayClients[i].isAlive())) 
            {GUIServer.arrayClients[i].close();}
         }
      }
      GUIServer.gac= 0;
   }   
}

class ThreadedEchoHandler extends Thread
{
   private Socket so;
   private String str="", lastStr="", data="";
   private DataInputStream in;
   private PrintStream out;
   private static File theFile= new File("Test.txt");
   
   private final static String BREAK= "exit";
   
   ThreadedEchoHandler(Socket so)
   {
      this.so= so;
   }
   
   public void run() // thread here
   {
      int ac;
      
      try
      {
         in= new DataInputStream(so.getInputStream());
         out= new PrintStream(so.getOutputStream());
         data= ReadFile();
         lastStr=str= data;
         out.println(data+" " + "(Enter "+ BREAK + " to disconnect.)\r");
         while((str= in.readLine()) != null)
         {
            out.println(str + " " + "(Enter "+ BREAK + " to disconnect.)\r");
            if (str.trim().equals(BREAK)) break;
            lastStr= str;
         }
      }
      catch(Exception e) 
      {
         System.out.println(e);
      }
      finally
      {
         if (so != null) 
         {
            GUIServer.NotifyDeath();
            this.close();
         }
         ControlPanel.SetAC(Integer.toString(GUIServer.GetGAC()));
         ControlPanel.SetMESS("Closed Connection.");
         try {WriteToFile(lastStr);}
         catch(IOException e)
         {System.out.println("Exception Writing to File: " + e);}
      }   
   }
   
   public void close()
   {
         try
         {
            if (in != null) in.close();
            in= null;
         }
         catch(Exception ignored) {;}
         if (out != null) out.close();
         out= null;
         try
         {
            if (so != null) so.close();
            so= null;
         }
         catch(Exception ignored) {;}
         
   }
     
   public static String ReadFile()
   {
      DataInputStream in= null;
      String data= "Error Reading File.";
      
      synchronized(theFile)
      {
         try
         {
            in= new DataInputStream(new FileInputStream(theFile)); //may throw
            data=in.readLine();
            
         }
         catch (IOException e) 
         {
            System.out.println("Error reading file.");
         }
         finally
         {
            if (in != null)
            {
               try{in.close();} //may throw
               catch(Exception ignored) {;}
            }
            return data;  // consumes any pending exceptions
         }
      }
   }
   
   public static synchronized void WriteToFile(String data) throws IOException
   {
      PrintStream os= null;
      
      synchronized(theFile)
         {
         try
         { 
            os= new PrintStream(new FileOutputStream(theFile)); // may throw
            os.println(data);
         }  
         catch (IOException e) 
         {throw e;}
         finally
         {
            if (os != null){os.close();}
         }
      }
   }
}

class ControlPanel extends Frame
{
   private InetAddress hostIP;
   private String strPort;
   private ServerSocket ss;
   private static TextField mess, ac;
   private MyDialog md;
   private Point p;
   
   public static final int KILL_SERVER= 0;
   public static final int DISCONNECT_ALL= 1;
   public static final int MIN_TYPE=0;
   public static final int MAX_TYPE= DISCONNECT_ALL;
   public static final boolean MODAL= true;
   
   ControlPanel(ServerSocket ss)
   {
     super("Control Panel v1.0 <jlouie 7.96>");
     this.ss= ss;
     setLayout(new GridLayout(5,2,10,10));
     add(new Label("SocketServer on Port:", Label.RIGHT));
     add(new Label(Integer.toString(GUIServer.GetPort()), Label.LEFT));
     add(new Label("Hosted on Machine:", Label.RIGHT));
     try 
     {
      hostIP= InetAddress.getLocalHost();
      strPort= hostIP.toString();
     }
     catch (Exception e) {strPort="Not Available";}
     add(new Label(strPort, Label.LEFT));
     add(new Label("Active Connections:", Label.RIGHT));
     add(ac= new TextField("0",25));
     ac.setEditable(false);
     add(new Label("Message:", Label.RIGHT));
     add(mess= new TextField("25"));
     mess.setEditable(false);
     add(new Button("Kill Server"));
     add(new Button("Disconnect All Clients"));
     p= location();
     this.move(p.x+20, p.y+20);
     this.resize(600,600);
     this.pack();
     this.show();
   }
   
   public boolean handleEvent(Event event)
   {
      if (event.id == Event.WINDOW_DESTROY)
      {
         if ((md == null) || (! md.isShowing()))
         {
            try{md= new MyDialog(this,"Confirm",MODAL,KILL_SERVER,p);}
            catch(IndexOutOfBoundsException e)
            {System.out.println("MyDialog IndexOutOfBounds");}
         }
         return true;
      }
      return super.handleEvent(event);
   }
   
   public boolean action(Event evt, Object obj)
   {
      char ch;
      String str=(String)obj;
      
      if (evt.target instanceof Button)
      {
         ch= str.charAt(0);
         switch(ch)
         {
            case 'K':   // Kill Server
               // use short circuit logical OR
               if ((md == null) || (! md.isShowing()))
               {
                  try{md= new MyDialog(this,"Confirm",MODAL,KILL_SERVER,p);}
                  catch(IndexOutOfBoundsException e)
                  {System.out.println("MyDialog IndexOutOfBounds");}
               }
               return true;
            case 'D':   // Disconnect All Users
               if ((md == null)|| (! md.isShowing()))
               {
                  try{md= new MyDialog(this,"Confirm",MODAL,DISCONNECT_ALL,p);}
                  catch(IndexOutOfBoundsException e)
                  {System.out.println("MyDialog IndexOutOfBounds");}
               }
               return true;
         }
      }
      return super.action(evt,obj);
   }
   
   public static void SetMESS(String inString)
   {ControlPanel.mess.setText(inString);}
   
   public static String GetMESS()
   {return ControlPanel.mess.getText();}
   
   public static void SetAC(String inString)
   {ControlPanel.ac.setText(inString);}
   
   public static String GetAC()
   {return ControlPanel.ac.getText();}
}


class MyDialog extends Dialog  
{
   Button OKbutton, Cancel;
   String mess;
   int boxType;
   
   MyDialog(Frame inFrame, String title, boolean inBoolean, int boxType, Point p)
   throws IndexOutOfBoundsException
   {
      super(inFrame, title, inBoolean);
      if ((boxType < ControlPanel.MIN_TYPE)
         || (boxType > ControlPanel.MAX_TYPE))
         {throw new IndexOutOfBoundsException();}  // exits method, returns null
      this.mess= mess;
      this.boxType= boxType;
      switch (boxType)
      {
         case ControlPanel.KILL_SERVER:
            mess="Kill Server?";
            break;
         case ControlPanel.DISCONNECT_ALL:
            mess="Disconnect All Clients?";
            break;
         default:
            mess="Error";       
      }
      setLayout(new GridLayout(3,2));       add(new Label("REALLY?",Label.LEFT));
      add(new Label(mess,Label.LEFT)); 
      add(OKbutton= new Button("OK"));
      add(Cancel= new Button("Cancel"));
      add(new Label("Control Panel", Label.RIGHT));
      add(new Label("v1.0", Label.LEFT));
      this.move(p.x+40, p.y+40);  // buggy
      this.resize(400,400);
      this.pack();
      this.show();
         /*Font f= Cancel.getFont();
         f= new Font(f.getName(), Font.BOLD, f.getSize());
         Cancel.setFont(f);
         Cancel.setBackground(Color.white);
         this.setBackground(Color.lightGray);*/  // buggy
      Cancel.requestFocus();
   }
   
   public boolean handleEvent(Event event)
   {
      switch (event.id)
      {
         case Event.WINDOW_DESTROY:
            if (this.isShowing()) this.hide();
            return true;
         case Event.KEY_PRESS:                        // user cancelled
            if (event.key == '\n')
               {if (this.isShowing()) this.hide();}   // return key
            return true;  
        default:    
            return super.handleEvent(event);
      }
   }
   
   public boolean action(Event evt, Object obj)
   {
      if (evt.target == Cancel)
      {
         if (this.isShowing()) this.hide();
         return true;
      }
      if (evt.target == OKbutton)
      {
            switch (MyDialog.boxType)
            {
               case ControlPanel.KILL_SERVER:
                  if (this.isShowing()) this.hide();
                  this.dispose();
                  System.exit(1);
                  return true;
               case ControlPanel.DISCONNECT_ALL:
                  GUIServer.DisconnectAll();
                  ControlPanel.SetAC(Integer.toString(GUIServer.GetGAC()));
                  if (this.isShowing()) this.hide();
                  return true;
                default: return true;
             }
      }
      return super.action(evt, obj);
   }
}
