//=================================================================
//
// file Client.java
// a Socket Server (GUIServer.java) applet client
// jlouie 7.96
// name this file Client.java and compile with Javac eg.
// c:\java\bin>javac -d c:/MyWebServer/HTML .\src\Client.java
// where the source code is in c:\java\bin\src
// and the code compiles to c:\MyWebServer\HTML
// not the use of the Unix / and DOS \ with javac!
// warning: select browser option/network/every time/apply when debugging
// with Netscape over a network!
// this applet compiles with Sun's JDK 1.02 Win95
// tested with Netscape 2.0 Win95 over Ethernet
// does not work with Netscape 3.0b4 Mac  (Socket class)
// this applet creates a client socket that spawns 
// two threads, a socket listener and writer.
// call this class from a HTML file
//
//=================================================================


import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;

public class Client extends Applet
{
   public final static int PORT= 8189;
   Socket so;
   DataInputStream in;
   PrintStream out;
   TextField tf;
   TextArea ta;
   StreamReader sr;
   StreamWriter sw;
   
   public void init()
   {
      try
      {
        tf= new TextField();
        ta= new TextArea("Trying to connect to host.");
        setLayout(new BorderLayout());
        add("North", tf);
        add("Center", ta);
        show(); 
        tf.requestFocus();  
         
        so= new Socket(this.getCodeBase().getHost(), PORT);
        in= new DataInputStream(new BufferedInputStream(so.getInputStream()));
        out= new PrintStream(new BufferedOutputStream(so.getOutputStream()));
  
        sr= new StreamReader(in, ta);
        sw= new StreamWriter(out, tf);
        
        int myPriority= sw.getPriority();
        if (myPriority < Thread.MAX_PRIORITY) sr.setPriority(myPriority+1);
        else sw.setPriority(myPriority-1);
      }
      catch(IOException e) {ta.setText("Unable to connect to host.");}
      catch(SecurityException e) 
      {ta.setText("Security Exception.");}
      catch(IllegalArgumentException e) 
      {ta.setText("Bad Priority Parameter.");}
   }
   
   public boolean action(Event evt, Object obj)
   {
      if (evt.target == this.tf)
      {
         sw.resume();      // wake up the writer thread
         return true;
      }
      return super.action(evt, obj);
   }
}

class StreamReader extends Thread
{
   DataInputStream in;
   TextArea ta;
   
   public StreamReader(DataInputStream in, TextArea ta)
   {
      this.in= in;
      this.ta= ta;
      this.start();
   }
   
   public void run()
   {
      String line;
      
      try
      {
         while((line= in.readLine()) != null)
         {
            ta.setText(line);
         }
      }
      catch(IOException e) {ta.setText(e.toString());}
      finally {ta.setText("Connection Closed or Server Busy.");}
   }
}

class StreamWriter extends Thread
{
   TextField tf;
   PrintStream out;
   
   public StreamWriter(PrintStream out, TextField tf)
   {
      this.tf= tf;
      this.out= out;
      this.start();
   }
   
   public void run()
   {
      while(true)
      {
         suspend();                 // wait for textfield input
         out.println(tf.getText()); // OK, get input and write to socket
         out.flush();
         tf.setText("");
      }
   }
}
