/***************************************
  $Header: /home/amb/cxref/RCS/file.c 1.7 1996/02/24 14:53:10 amb Exp $

  C Cross Referencing & Documentation tool. Version 1.0

  Sets up the top level File structure.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1995,96 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

/*+ To control the debugging in this file. +*/
#define DEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "memory.h"
#include "datatype.h"
#include "cxref.h"

/*+ This contains the File that is currently being documented to allow the other functions access to it. +*/
File CurFile=NULL;

/*++++++++++++++++++++++++++++++++++++++
  Creates a new File structure, and sets CurFiel to point to it.

  File NewFile Returns the new file structure.

  char* name The name of the file.
  ++++++++++++++++++++++++++++++++++++++*/

File NewFile(char* name)
{
 CurFile=(File)Malloc(sizeof(struct _File));

 CurFile->comment=NULL;
 CurFile->name=MallocString(name);
 CurFile->includes=NULL;
 CurFile->defines=NULL;
 CurFile->typedefs=NULL;
 CurFile->variables=NULL;
 CurFile->functions=NULL;
 InitStringList(&CurFile->inc_in);
 InitStringList(&CurFile->f_refs);
 InitStringList(&CurFile->v_refs);

 return(CurFile);
}


/*++++++++++++++++++++++++++++++++++++++
  Called when a file comment has been seen. Only the first of multiple comments in a file are used.

  char* comment The comment for the file.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenFileComment(char* comment)
{
 if(!CurFile->comment)
    CurFile->comment=MallocString(comment);
}


/*++++++++++++++++++++++++++++++++++++++
  Deletes a file structure.

  File file The file structure to be deleted.

  This is required to go through each of the elements in the File structure and delete each of them in turn.
  ++++++++++++++++++++++++++++++++++++++*/

void DeleteFile(File file)
{
 if(file->comment) Free(file->comment);
 Free(file->name);

 DeleteStringList(&file->inc_in);
 DeleteStringList(&file->f_refs);
 DeleteStringList(&file->v_refs);

 if(file->includes)
   {
    Include p=file->includes,n;
    do{
       n=p->next;
       if(p->comment) Free(p->comment);
       Free(p->name);
       if(p->includes)          /* Add the included files to the end instead of recursing. */
         {
          AddToLinkedList(n,Include,p->includes);
          p->includes=NULL;
         }
       Free(p);
       p=n;
      }
    while(p);
   }

 if(file->defines)
   {
    Define p=file->defines,n;
    do{
       n=p->next;
       if(p->comment) Free(p->comment);
       Free(p->name);
       if(p->value) Free(p->value);
       DeleteStringList2(&p->args,1);
       Free(p);
       p=n;
      }
    while(p);
   }

 if(file->typedefs)
   {
    Typedef p=file->typedefs,n;
    do{
       n=p->next;
       if(p->comment) Free(p->comment);
       Free(p->name);
       if(p->type) Free(p->type);
       if(p->sutype) DeleteStructUnion(p->sutype);
       Free(p);
       p=n;
      }
    while(p);
   }

 if(file->variables)
   {
    Variable p=file->variables,n;
    do{
       n=p->next;
       if(p->comment) Free(p->comment);
       Free(p->name);
       Free(p->type);
       if(p->defined) Free(p->defined);
       DeleteStringList(&p->visible);
       DeleteStringList(&p->used);
       Free(p);
       p=n;
      }
    while(p);
   }

 if(file->functions)
   {
    Function p=file->functions,n;
    do{
       n=p->next;
       if(p->comment) Free(p->comment);
       Free(p->name);
       if(p->type)    Free(p->type);
       if(p->protofile) Free(p->protofile);
       if(p->cret)    Free(p->cret);
       DeleteStringList2(&p->args,1);
       DeleteStringList(&p->calls);
       DeleteStringList(&p->v_refs);
       DeleteStringList(&p->f_refs);
       DeleteStringList(&p->called);
       Free(p);
       p=n;
      }
    while(p);
   }

 Free(file);
}
