/***************************************
  $Header: /home/amb/cxref/RCS/var.c 1.8 1996/06/16 16:44:28 amb Exp $

  C Cross Referencing & Documentation tool. Version 1.2.

  Collects the variable definition stuff.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1995,96 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

/*+ Control the output of debugging information from this file. +*/
#define DEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "memory.h"
#include "datatype.h"
#include "cxref.h"

/*+ The file that is currently being documented. +*/
extern File CurFile;

/*+ A list of the variables found at each level of the scope. +*/
static StringList2 *variable;

/*+ The number of levels of scope depth allocated. +*/
static int max_scope=0;

/*+ The current scope depth. +*/
static int cur_scope=-1;


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a variable definition is seen.

  char* name The name of the variable.

  char* type The type of the variable.

  int scope The scope of variable that has been seen.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenVariableDefinition(char* name,char* type,int scope)
{
 Variable var;
 int seen=0;

#if DEBUG
 printf("#Var.c# Variable definition for '%s'\n",name);
#endif

 for(var=CurFile->variables;var;var=var->next)
    if(!strcmp(var->name,name))
      {
       var->scope|=scope;
       seen=1;
      }

 if(!seen)
   {
    var=(Variable)Malloc(sizeof(struct _Variable));

    AddToLinkedList(CurFile->variables,Variable,var);

    var->comment=MallocString(GetCurrentComment());
    var->name=MallocString(name);
    var->type=MallocString(type);
    var->scope=scope;
    var->defined=NULL;
    InitStringList(&var->visible);
    InitStringList(&var->used);
    var->next=NULL;
   }
}

/*++++++++++++++++++++++++++++++++++++++
  Called when a new scope is entered.
  ++++++++++++++++++++++++++++++++++++++*/

void UpScope(void)
{
 cur_scope++;

#if DEBUG
 printf("#Var.c# Scope ++ (%2d)\n",cur_scope);
#endif

 if(cur_scope>=max_scope)
   {
    if(max_scope==0)
       variable=Malloc(16*sizeof(StringList2));
    else
       variable=Realloc(variable,(max_scope+16)*sizeof(StringList2));
    max_scope+=16;
   }

 InitStringList2(&variable[cur_scope]);
}


/*++++++++++++++++++++++++++++++++++++++
  Called when an old scope is exited.
  ++++++++++++++++++++++++++++++++++++++*/

void DownScope(void)
{
#if DEBUG
 printf("#Var.c# Scope -- (%2d)\n",cur_scope);
#endif

 DeleteStringList2(&variable[cur_scope],0);

 cur_scope--;
}


/*++++++++++++++++++++++++++++++++++++++
  Add a variable to the list of known variables.

  char* name The name of the variable.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenScopeVariable(char* name)
{
#if DEBUG
 printf("#Var.c# Scope Variable depth %2d '%s'\n",cur_scope,name);
#endif

 AddToStringList2(&variable[cur_scope],name,NULL);
}


/*++++++++++++++++++++++++++++++++++++++
  Check through the scope variables to look for the named one.

  int IsAScopeVariable Returns 1 if the name does refer to a variable that is scoped.

  char* name The name of the variable to search for.
  ++++++++++++++++++++++++++++++++++++++*/

int IsAScopeVariable(char* name)
{
 int i,scope;

#if DEBUG
 printf("#Var.c# Lookup variable '%s'\n",name);
#endif

 for(scope=cur_scope;scope>=0;scope--)
    for(i=0;i<variable[scope].n;i++)
       if(!strcmp(variable[scope].s1[i],name))
          return(1);

 return(0);
}
