/***************************************
  $Header: /home/amb/cxref/RCS/slist.c 1.2 1996/02/24 14:53:54 amb Exp $

  C Cross Referencing & Documentation tool. Version 1.0

  Handle lists of strings.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1995,96 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

/*+ Control the debugging information from this file. +*/
#define DEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "memory.h"
#include "datatype.h"
#include "cxref.h"

/*++++++++++++++++++++++++++++++++++++++
  Called to initialise a new string list.

  StringList* sl The string list to initialise.
  ++++++++++++++++++++++++++++++++++++++*/

void InitStringList(StringList* sl)
{
#if DEBUG
 printf("#Slist.c# Initialise string list\n");
#endif

 sl->n=0;
 sl->s=NULL;
}


/*++++++++++++++++++++++++++++++++++++++
  Called to initialise a new string list 2.

  StringList2* sl The string list 2 to initialise.
  ++++++++++++++++++++++++++++++++++++++*/

void InitStringList2(StringList2* sl)
{
#if DEBUG
 printf("#Slist.c# Initialise string list 2\n");
#endif

 sl->n=0;
 sl->s1=NULL;
 sl->s2=NULL;
}


/*++++++++++++++++++++++++++++++++++++++
  Add a string to the string list, the list stores a Malloced copy of str.

  StringList* sl The string list to add to.

  char* str The string to add.

  int alphalist If true then the list is sorted into alphabetical order.
  ++++++++++++++++++++++++++++++++++++++*/

void AddToStringList(StringList* sl,char* str,int alphalist)
{
 int i;

#if DEBUG
 printf("#Slist.c# Add string %s to the string list\n",str);
#endif

 for(i=0;i<sl->n;i++)
    if(!strcmp(str,sl->s[i]))
       return;

 if(!sl->n)
    sl->s=(char**)Malloc(8*sizeof(char*));
 else
    if(sl->n%8==0)
       sl->s=(char**)Realloc(sl->s,(sl->n+8)*sizeof(char*));

 if(alphalist)
   {
    char *shuffle=NULL;
    for(i=0;i<sl->n;i++)
       if(shuffle)
         {
          char* temp=sl->s[i];
          sl->s[i]=shuffle;
          shuffle=temp;
         }
       else
          if(strcmp(str,sl->s[i])<0)
            {
             shuffle=sl->s[i];
             sl->s[i]=MallocString(str);
            }

    if(!shuffle)
       sl->s[sl->n]=MallocString(str);
    else
       sl->s[sl->n]=shuffle;
   }
 else
    sl->s[sl->n]=MallocString(str);

 sl->n++;
}


/*++++++++++++++++++++++++++++++++++++++
  Add a string to the string list 2, the list stores the values of the arguments.

  StringList2* sl The string list 2 to add to.

  char* str1 The first string to add.

  char* str2 The second string to add.
  ++++++++++++++++++++++++++++++++++++++*/

void AddToStringList2(StringList2* sl,char* str1,char* str2)
{
 if(!sl->n)
   {
    sl->s1=(char**)Malloc(8*sizeof(char*));
    sl->s2=(char**)Malloc(8*sizeof(char*));
   }
 else
    if(sl->n%8==0)
      {
       sl->s1=(char**)Realloc(sl->s1,(sl->n+8)*sizeof(char*));
       sl->s2=(char**)Realloc(sl->s2,(sl->n+8)*sizeof(char*));
      }

 sl->s1[sl->n]=str1;
 sl->s2[sl->n]=str2;

 sl->n++;
}


/*++++++++++++++++++++++++++++++++++++++
  Delete a string list.

  StringList* sl The string list to delete.
  ++++++++++++++++++++++++++++++++++++++*/

void DeleteStringList(StringList* sl)
{
 if(sl->n)
   {
    int i;

    for(i=0;i<sl->n;i++)
       Free(sl->s[i]);

    Free(sl->s);
   }
}


/*++++++++++++++++++++++++++++++++++++++
  Delete a string list 2.

  StringList2* sl The string list 2 to delete.

  int free_them If this is true then the strings are to be freed.
  ++++++++++++++++++++++++++++++++++++++*/

void DeleteStringList2(StringList2* sl,int free_them)
{
 if(sl->n)
   {
    int i;

    if(free_them)
       for(i=0;i<sl->n;i++)
         {
          if(sl->s1[i])Free(sl->s1[i]);
          if(sl->s2[i])Free(sl->s2[i]);
         }

    Free(sl->s1);
    Free(sl->s2);
   }
}
