/***************************************
  $Header: /home/amb/cxref/RCS/preproc.c 1.7 1996/05/20 18:54:01 amb Exp $

  C Cross Referencing & Documentation tool. Version 1.1

  Collects the pre-processing instruction stuff.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1995,96 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

/*+ Control the output of debugging information for this file. +*/
#define DEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "memory.h"
#include "datatype.h"
#include "cxref.h"

/*+ The file that is currently being processed. +*/
extern File CurFile;

/*+ When in a header file, this is set to 1, to allow most of the stuff to be skipped. +*/
int in_header=0;

/*+ The current #define we are looking at. +*/
static Define cur_def=NULL;


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a included file is seen in the current file.

  char* name The name of the included file.

  int flag The flags that GCC leaves in the file
  ++++++++++++++++++++++++++++++++++++++*/

void SeenInclude(char* name,int flag)
{
 static int inc_depth=0;
 static char *inc_type=NULL;
 Include inc;

#if DEBUG
 printf("#Preproc.c# #include %s '%s' (flag=%d)\n",flag&2?"Included":"Return to",name,flag);
#endif

 if(flag&2 && (!inc_type || inc_type[inc_depth-1]==LOCAL))
   {
    Include *t=&CurFile->includes;
    int i;

    for(i=0;i<inc_depth;i++)
      {
       while(*t && (*t)->next)
          t=&(*t)->next;
       t=&(*t)->includes;
      }

    inc=(Include)Malloc(sizeof(struct _Include));

    AddToLinkedList(*t,Include,inc);

    inc->comment=MallocString(GetCurrentComment());
    inc->name=MallocString(name);
    inc->scope=(flag&8)?GLOBAL:LOCAL;
    inc->includes=NULL;
    inc->next=NULL;
   }

 if(flag&2)
   {
    inc_depth++;

    if(inc_depth==1)
       inc_type=(char*)Malloc(16);
    else
       if(!(inc_depth%16))
          inc_type=(char*)Realloc(inc_type,(unsigned)(inc_depth+16));

    if(inc_depth>1 && inc_type[inc_depth-2]==GLOBAL)
       inc_type[inc_depth-1]=GLOBAL;
    else
       inc_type[inc_depth-1]=(flag&8)?GLOBAL:LOCAL;
   }
 else
   {
    inc_depth--;

    if(!inc_depth)
       Free(inc_type),inc_type=NULL;
   }

 if(inc_type)
    in_header=inc_type[inc_depth-1];
 else
    in_header=0;
}


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a #define is seen in the current file.

  char* name The name of the #defined symbol.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenDefine(char* name)
{
 Define def;

#if DEBUG
 printf("#Preproc.c# Defined name '%s'\n",name);
#endif

 def=(Define)Malloc(sizeof(struct _Define));

 AddToLinkedList(CurFile->defines,Define,def);

 def->comment=MallocString(GetCurrentComment());
 def->name=MallocString(name);
 def->value=NULL;
 InitStringList2(&def->args);
 def->next=NULL;

 cur_def=def;
}


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a #define value is seen in the current file.

  char* value The value of the #defined symbol.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenDefineValue(char* value)
{
#if DEBUG
 printf("#Preproc.c# #define value '%s' for %s\n",value,cur_def->name);
#endif

 cur_def->value=MallocString(value);
}


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a #define function argument is seen in the current definition.

  char* name The argument.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenDefineFunctionArg(char* name)
{
#if DEBUG
 printf("#Preproc.c# #define Function arg '%s' in %s()\n",name,cur_def->name);
#endif

 AddToStringList2(&cur_def->args,MallocString(name),SplitComment(&cur_def->comment,name));
}


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a comment is seen in a #define function definition.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenDefineFuncArgComment(void)
{
 char* comment=GetCurrentComment();

#if DEBUG
 printf("#Preproc.c# #define Function arg comment '%s' in %s()\n",comment,cur_def->name);
#endif

 if(!cur_def->args.s2[cur_def->args.n-1])
    cur_def->args.s2[cur_def->args.n-1]=MallocString(comment);
}


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a comment is seen in a #define definition.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenDefineComment(void)
{
 char* comment=GetCurrentComment();

#if DEBUG
 printf("#Preproc.c# #define inline comment '%s' in %s\n",comment,cur_def->name);
#endif

 if(!cur_def->comment)
    cur_def->comment=MallocString(comment);
}
