/***************************************
  $Header: /home/amb/cxref/RCS/comment.c 1.11 1996/06/27 20:10:03 amb Exp $

  C Cross Referencing & Documentation tool. Version 1.2.

  Collects the comments from the parser.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1995,96 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

/*+ Turn on the debugging in this file. +*/
#define DEBUG 0

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "memory.h"
#include "datatype.h"
#include "cxref.h"

/*+ The file that is currently being processed. +*/
extern File CurFile;

/*+ The current (latest comment). +*/
static char* cur_comment=NULL;


/*++++++++++++++++++++++++++++++++++++++
  Function that is called when a comment or part of one is seen. The comment is built up until an end of comment is signaled.

  char* c The comment text. If c==0 then it is a file (/ * * comment * * /) comment
                            if c==1 then it is the other special comment (/ * + comment + * /).
                            if c==2 then it is a normal comment (/ * comment * /).
                            if c==3 then it is not a comment.
  ++++++++++++++++++++++++++++++++++++++*/

void SeenComment(char* c)
{
 static int comment_ended=0;

 switch((int)c)
   {
   case 0:
#if DEBUG
    printf("#Comment.c# Seen comment /**\n%s\n**/\n",cur_comment);
#endif
    SeenFileComment(cur_comment); cur_comment=NULL;
    comment_ended=1;
    break;

   case 1:
#if DEBUG
    printf("#Comment.c# Seen comment /*+\n%s\n+*/\n",cur_comment);
#endif
    comment_ended=1;
    if(SeenFuncIntComment(cur_comment)) cur_comment=NULL;
    break;

   case 2:
#if DEBUG
    printf("#Comment.c# Seen comment /*\n%s\n*/\n",cur_comment);
#endif
    comment_ended=1;
    if(!CurFile->comment) {SeenFileComment(cur_comment); cur_comment=NULL;}
    break;

   case 3:
    comment_ended=0; cur_comment=NULL;
    break;

   default:
    if(comment_ended)
      {comment_ended=0; cur_comment=NULL;}

    cur_comment=ConcatStrings(2,cur_comment,c);
   }
}


/*++++++++++++++++++++++++++++++++++++++
  Provide the current (latest) comment.

  char* GetCurrentComment Returns the current (latest) comment.
  ++++++++++++++++++++++++++++++++++++++*/

char* GetCurrentComment(void)
{
 char* c=cur_comment;

#if DEBUG
    printf("#Comment.c# GetCurrentComment returns <<<%s>>>\n",cur_comment);
#endif

 cur_comment=NULL;

 return(c);
}


/*++++++++++++++++++++++++++++++++++++++
  Set the current (latest) comment.

  char* comment The comment.
  ++++++++++++++++++++++++++++++++++++++*/

void SetCurrentComment(char* comment)
{
#if DEBUG
    printf("#Comment.c# SetCurrentComment set to <<<%s>>>\n",comment);
#endif

 cur_comment=comment;
}


/*++++++++++++++++++++++++++++++++++++++
  A function to split out the arguments etc from a comment, for example the function argument comments are separated using this.

  char* SplitComment Returns the required comment.

  char** original A pointer to the original comment, this is altered in the process.

  char* name The name that is to be cut out from the comment.

  A most clever function that ignores spaces so that 'char* b' and 'char *b' match.
  ++++++++++++++++++++++++++++++++++++++*/

char* SplitComment(char** original,char* name)
{
 char* c=NULL;

 if(*original)
   {
    int l=strlen(name);
    c=*original;

    do{
       int i,j,failed=0;
       char* start=c;

       while(c[0]=='\n')
          c++;

       for(i=j=0;i<l;i++,j++)
         {
          while(name[i]==' ') i++;
          while(c[j]==' ') j++;

          if(!c[j] || name[i]!=c[j])
            {failed=1;break;}
         }

       if(!failed)
         {
          char* old=*original;
          char* end=strstr(c,"\n\n");
          *start=0;
          if(end)
             *original=MallocString(ConcatStrings(2,*original,end));
          else
             if(start==*original)
                *original=NULL;
             else
                *original=MallocString(*original);
          if(end)
             *end=0;
          c=MallocString(&c[j+1]);
          Free(old);
          break;
         }
      }
    while((c=strstr(c,"\n\n")));
   }

 return(c);
}
