//
// Horizontal and Vertical Panel
//

import java.awt.*;

class HPanel extends Panel {
  HGridLayout hgrid;

  public HPanel() {
    this(5, 0, 0);
  }

  public HPanel(int border, int gap, int left) {
    hgrid = new HGridLayout(new Insets(border, border, border, border), gap, 
      left);

    setLayout(hgrid);
  }

  public Component add(int size, Component comp) {
    hgrid.setConstraints(comp, size);
    add(comp);

    return comp;
  }
}

class VPanel extends Panel {
  VGridLayout vgrid;

  public VPanel() {
    this(5, 0, 0);
  }

  public VPanel(int border, int gap, int left) {
    vgrid = new VGridLayout(new Insets(border, border, border, border), gap, 
      left);

    setLayout(vgrid);
  }

  public Component add(int size, Component comp) {
    vgrid.setConstraints(comp, size);
    add(comp);

    return comp;
  }
}
