//
// Hash - Better Hashtable class
//

import java.util.Hashtable;
import java.util.Enumeration;

public class Hash extends Hashtable {
  public int getInt(Object key) {
    Object obj = get(key);

    if (obj instanceof Integer)
      return ((Integer) obj).intValue();
    else
      return (new Integer(obj.toString())).intValue();
  }

  public int getInt(int key) {
    return getInt(new Integer(key));
  }

  public long getLong(Object key) {
    Object obj = get(key);

    if (obj instanceof Long)
      return ((Long) obj).longValue();
    else
      return (new Long(obj.toString())).longValue();
  }

  public long getLong(int key) {
    return getLong(new Integer(key));
  } 

  public float getFloat(Object key) {
    Object obj = get(key);

   if (obj instanceof Float)
      return ((Float) obj).floatValue();
    else
      return (new Float(obj.toString())).floatValue();
  }

  public float getFloat(int key) {
    return getFloat(new Float(key));
  } 

  public String getString(Object key) {
    return get(key).toString();
  }

  public String getString(int key) {
    return getString(new Integer(key));
  }

  public Table getTable(Object key) {
    return (Table) get(key);
  }

  public Table getTable(int key) {
    return (Table) get(new Integer(key));
  }

  public Hash getHash(Object key) {
    return (Hash) get(key);
  }

  public Hash getHash(int key) {
    return (Hash) get(new Integer(key));
  }

  public void set(Object key, Object val) {
    put(key, val);
  }

  public void set(Object key, int val) {
    put(key, new Integer(val));
  }

  public void set(int key, Object val) {
    put(new Integer(key), val);
  }

  public void set(int key, int val) {
    put(new Integer(key), new Integer(val));
  }

  public Table keyNames() {
    Table tb = new Table();
    Enumeration en = keys();

    while (en.hasMoreElements())
      tb.add(en.nextElement());

    return tb;
  } 
}
