;compile this .asm file as normal
;use the link option /cp:70 which will allocate this program
;70 paragraphs of memory
;exe format
DOSSEG

.MODEL  SMALL

.STACK  100h

.DATA

INT_NUMBER      EQU     08h             ;INTERRUPT NUMBER TO HOOK INTO
INT_NUMBER_2    EQU     21h
LOAD_PARAMETERS DW      00h
                DW      0080h           ;COMMAND LINE IN PSP - OFFSET
                DW      @CURSEG         ;       SEGMENT
                DW      005Ch           ;FIRST FCB IN PSP    - OFFSET
                DW      @CURSEG         ;       SEGMENT
                DW      006Ch           ;SECOND FCB IN PSP   - OFFSET
                DW      @CURSEG         ;       SEGMENT

OLD_VECTOR      DD      0h              ;STORAGE FOR OLD INTERRUPT
                                        ;VECTOR
OLD_VECTOR_2    DD      0h
ORIG_VECTOR     DD      0h              ;ORIGINAL VECTOR FOR INT_NUMBER
MEM_SIZE        EQU     200h            ;FUTURE USE FOR INT 21 SERV.4A
PROGRAM_NAME    DB      "STARCON2.EXE",0
CODESTART       EQU     03F4h
ALREADY         DB      00h
DIFFERENCE      EQU     2962h           ;52F7-2995
OFFSET_1        EQU     7B3Eh           ;FIRST OFFSET TO MAKE CHANGES
ORIGINAL_DS     DW      0h

HEADER          DB      "         **TOP**",0Dh,0Ah,0Ah
                DB      "   TIRED OF PROTECTION",0Dh,0Ah,0Ah
                DB      "CRACKED BY THE MAD DOCTOR",0Dh,0Ah,"$"
FAILED_LOAD     DB      0Ah,0Ah,"FAILED TO LOAD PROGRAM",0Dh,0Ah,"$"
NOT_FOUND       DB      "FILE NOT FOUND",0Dh,0Ah,"$"
INSUF_MEMORY    DB      "INSUFFICIENT MEMORY",0Dh,0Ah,"$"

STARCODE        DB      "VEGA",0h,"ANTLIAE",0h,"APODIS",0h,"AQUARII",0h
                DB      "AQUILAE",0h,"ARAE",0h,"ARIETIS",0h,"AURIGAE",0h
                DB      "TRIANGULI",0h,"CAELI",0h,"CAMELOPARDALIS",0h
                DB      "CANCRI",0h,"BRAHE",0h,"KEPLER",0h,"COPERNICUS"
                DB      0h,"CAPRICORNI",0h,"CARINAE",0h,"CASSIOPEIAE",0h
                DB      "TUCANAE",0h,"CEPHEI",0h,"CETI",0h,"CRATERIS",0h
                DB      "CIRCINI",0h,"COLUMBAE",0h,"CHANDRASEKHAR",0h
                DB      "SAGITTAE",0h,"CYGNUS",0h,"CORVI",0h
                DB      "CHAMAELEONIS",0h,"EQUULEI",0h,"DELPHINI",0h
                DB      "DORADUS",0h,"MONOCEROTIS",0h,"CRUCIS",0h
                DB      "ERIDANI",0h,"FORNACIS",0h,"GEMINORUM",0h
                DB      "ALTAIR",0h,"ANTARES",0h,"HOROLOGII",0h,"HYDRAE"
                DB      0h,"ANDROMEDAE",0h,"GROOMBRIDGE",0h,"LACERTAE"
                DB      0h,"LEONIS",0h,"HYADES",0h,"LEPORIS",0h,"LIBRAE"
                DB      0h,"LIPI",0h,"LYNCIS",0h,"FOMALHAUT",0h
                DB      "MENKAR",0h,"MICROSCOPII",0h,"DRACONIS",0h
                DB      "ORIONIS",0h,"NORMAE",0h,"OCTANTIS",0h
                DB      "OPHIUCHI",0h,"MUSCAE",0h,"PAVONIS",0h,"PEGASI"
                DB      0h,"PERSEI",0h,"PHOENICIS",0h,"PICTORIS",0h
                DB      "PISCIUM",0h,"HYGINUS",0h,"PUPPIS",0h,"PYXIDIS"
                DB      0h,"RETICULI",0h,"ARIANNI",0h,"SAGITTARII",0h
                DB      "SCORPII",0h,"SCULPTORIS",0h,"SCUTI",0h
                DB      "SERPENTIS",0h,"SEXTANTIS",0h,"TAURI",0h
                DB      "TELESCOPII",0h,"BOOTIS",0h,"OLBER",0h
                DB      "CENTAURI",0h,"PTOLEMAE",0h,"GORNO",0h
                DB      "VELORUM",0h,"VIRGINIS",0h,"VOLANTIS",0h
                DB      "VULPECULAE",0h,"LALANDE",0h,"LUYTEN",0h,"INDI"
                DB      0h,"LACAILLE",0h,"GICLAS",0h,"KRUEGER",0h
                DB      "LYRAE",0h,"WOLF",0h,"SAURUS",0h,"RAYNET",0h
                DB      "ZEEMAN",0h,"VELA",0h,"MIRA",0h,"CERENKOV",0h
                DB      "MERSENNE",0h,"MAKSUTOV",0h,"KLYSTRON",0h
                DB      "METIS",0h,"MENSAE",0h,"ILLUMINATI",0h
                DB      "VITALIS",0h,"HERCULIS",0h,"GRUIS",0h,"SQUIDI"
                DB      0h,"ALMAGEST",0h,"ALCOR",0h,"ALGOL",0h
                DB      "BETELGEUSE",0h,"ALDEBARAN",0h,"ACHERNAR",0h
                DB      "PROCYON",0h,"RIGEL",0h,"BELLATRIX",0h
                DB      "MIZAR",0h,"HYPERION",0h,"REGULUS",0h
                DB      "ORGANON",0h,"POLLUX",0h,"CAPELLA",0h,"DENEB"
                DB      0h,"CANOPUS",0h,"SIRIUS",0h,"SOL",0h
                DB      "ARCTURUS",0h,"LENTILIS",0h



.CODE

LOADER          PROC

        JMP     START

INTERRUPT_ENTRY_2       PROC    FAR
        PUSHF
        PUSH    AX
        PUSH    BP
        CMP     AX,3524h
        JNZ     QUIT_2
        MOV     AX,SP
        MOV     BP,AX
        CMP     [BP+6],0199h
        JNZ     QUIT_2
        PUSH    SP
        PUSH    DS
        PUSH    ES
        PUSH    BX
        PUSH    DX
        MOV     AL,INT_NUMBER
        MOV     AH,35h
        INT     21h                     ;GET INT VECTOR FOR INT21
                                        ;AND PUT INTO ES:BX
        MOV     AX,DGROUP
        MOV     DS,AX
        MOV     WORD PTR OLD_VECTOR[0],BX     ;SAVE OLD INT VECTORS
        MOV     WORD PTR OLD_VECTOR[2],ES
        MOV     DX,OFFSET INTERRUPT_ENTRY
        MOV     AX,CS
        MOV     DS,AX
        MOV     AL,INT_NUMBER
        MOV     AH,25h
        INT     21h                     ;PUT NEW INT VECTOR IN FOR
                                        ;INTERRUPT_ENTRY
        POP     DX
        POP     BX
        POP     ES                      ;
        POP     DS                      ;
        POP     SP

QUIT_2:

        POP     BP
        POP     AX
        POPF
        JMP     DWORD PTR CS:OLD_VECTOR_2

INTERRUPT_ENTRY_2       ENDP


INTERRUPT_ENTRY         PROC    FAR
        PUSHF                           ;SAVE NEEDED REGISTERS
        PUSH    AX
        PUSH    DS
        PUSH    ES
        MOV     AX,DS
        MOV     ES,AX
        MOV     AX,DGROUP
        MOV     DS,AX
        CMP     [ALREADY],01h
        JZ      QUIKQUIT
        CMP     BYTE PTR ES:[OFFSET_1+0],"T"
        JNZ     QUIKQUIT
        CMP     BYTE PTR ES:[OFFSET_1+1],"O"
        JNZ     QUIKQUIT
        CMP     BYTE PTR ES:[OFFSET_1+2],"P"
        JNZ     QUIKQUIT


                                        ;**THIS IS WHERE THE FUN BEGINS**
        PUSH    BX                      ;SAVE MORE REGISTERS
        PUSH    CX
        PUSH    DX
        PUSH    SI
        PUSH    DI
        PUSH    BP
        PUSH    SP
        MOV     CX,ES                   ;STORE ES IN CX FOR LATER
        MOV     AX,ES
        ADD     AX,DIFFERENCE           ;AX=527F  (THE PROGRAM CS)
        MOV     ES,AX                   ;ES=AX
     
        MOV     DI,CODESTART            ;03F4h -PARENT PROGRAM CS:03F4
        MOV     BX,OFFSET STARCODE      ;MY CODE LOCATION

SCAN:

        MOV     AL,BYTE PTR ES:[DI]        ;ENEMY INFO
        CMP     AL,61h                  ;IS THE LETTER SMALL (>=61) OR
        JB      CONTINUE                ;CAPITAL
        SUB     AL,20h                  ;SMALL--TURN IT INTO A CAPITAL

CONTINUE:
        
        CMP     BYTE PTR [BX],AL     ;DS:BX (MY CODE) TO THEIRS IN AL
        JNZ     FOUND
        INC     DI
        INC     BX
        JMP     SCAN

FOUND:

        MOV     [ALREADY],01h      ;SO WE DON'T REPEAT THIS
        MOV     ES,CX
        MOV     DI,OFFSET_1        ;
        XOR     AX,AX
        
REPEAT:

        MOV     AL,BYTE PTR [BX]
        MOV     BYTE PTR ES:[DI],AL
        INC     BX
        INC     DI
        OR      AX,AX
        JNZ     REPEAT

DONE:

        POP     SP
        POP     BP
        POP     DI
        POP     SI
        POP     DX
        POP     CX
        POP     BX

QUIKQUIT:

        POP     ES
        POP     DS
        POP     AX
        POPF

        JMP     DWORD PTR CS:OLD_VECTOR ;JMP TO THE REST OF THE
                                        ;INTERRUPT

INTERRUPT_ENTRY         ENDP

START           PROC

        MOV     BX,DGROUP               ;INITIALIZE DS TO THE DATA
        MOV     DS,BX                   ;SEGMENT
        MOV     DX,OFFSET HEADER
        MOV     AH,9
        INT     21h                     ;PRINT A TITLE
        PUSH    DS
        PUSH    DS
        MOV     AL,INT_NUMBER_2
        MOV     AH,35h
        INT     21h                     ;GET INT VECTOR FOR INT21
                                        ;AND PUT INTO ES:BX
        MOV     WORD PTR OLD_VECTOR_2[0],BX     ;SAVE OLD INT VECTORS
        MOV     WORD PTR OLD_VECTOR_2[2],ES
        MOV     AL,INT_NUMBER
        MOV     AH,35h                  ;SAVE THE ORIGINAL INT 8 VECTOR
        INT     21h
        MOV     WORD PTR ORIG_VECTOR[0],BX
        MOV     WORD PTR ORIG_VECTOR[2],ES
        MOV     DX,OFFSET INTERRUPT_ENTRY_2
        MOV     AX,CS
        MOV     DS,AX
        MOV     AL,INT_NUMBER_2
        MOV     AH,25h
        INT     21h                     ;PUT NEW INT VECTOR IN FOR
                                        ;INTERRUPT_ENTRY
        POP     DS                      ;RE-INITIALIZE DS AND ES TO
        POP     ES                      ;THE DATA SEGMENT
        MOV     DX,OFFSET PROGRAM_NAME
        MOV     BX,OFFSET LOAD_PARAMETERS
        MOV     AX,4B00h                ;LOAD PROGRAM, NAME AT DS:DX,
        INT     21h                     ;PARAMETERS AT ES:BX
        JNC     RESTORE                 ;JMP IF LOAD WAS SUCCESSFUL
        PUSH    AX
        MOV     AH,9                    ;PRINT THAT LOAD FAILED
        MOV     DX,OFFSET FAILED_LOAD
        INT     21h
        POP     AX
        CMP     AX,8                    ;IF AX=8 THEN THERE WAS
        JE      NO_MEMORY               ;INSUFFICIENT MEMORY
        CMP     AX,2
        JNE     RESTORE                 ;IF NOT 2 OR 8 THEN ?--
                                        ;JUST RESTORE AND EXIT
        MOV     DX,OFFSET NOT_FOUND     ;IF AX=2 THEN THE FILE WAS NOT
        JMP     PRINT_ERROR             ;FOUND

NO_MEMORY:

        MOV     DX,OFFSET INSUF_MEMORY

PRINT_ERROR:

        MOV     AH,9
        INT     21h

RESTORE:

        LDS     DX,DWORD PTR OLD_VECTOR_2
        MOV     AL,INT_NUMBER_2         ;RESTORE OLD INTERRUPT VECTOR
        MOV     AH,25h
        INT     21h
        MOV     AX,DGROUP
        MOV     DS,AX
        LDS     DX,DWORD PTR ORIG_VECTOR
        MOV     AL,INT_NUMBER
        MOV     AH,25h
        INT     21h
        MOV     AX,4C00h                ;EXIT TO DOS
        INT     21h

START           ENDP
LOADER          ENDP
        END     LOADER

