//*************************************************************
//  File name: init.c
//
//  Description:
//
//      Routines which initialize the application and instance.
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Modified by GGB on 7/28/93
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//*************************************************************

#include "global.h"

//*************************************************************
//
//  InitApplication()
//
//  Purpose:
//
//		Initializes the application (window classes)
//
//
//  Parameters:
//
//      HANDLE hInstance - Instance handle from WinMain.
//      
//
//  Return: (BOOL)
//
//      TRUE  - Window class was initialized and registered.
//      FALSE - Window class not initialized and registered.
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Modified by GGB on 7/28/93
//
//*************************************************************

BOOL InitApplication (HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style         = CS_HREDRAW|CS_VREDRAW;             
    wc.lpfnWndProc   = MainWndProc;
    wc.cbClsExtra    = 0;           
    wc.cbWndExtra    = 0;           
    wc.hInstance     = hInstance;    
    wc.hIcon         = LoadIcon(hInstance, "MAINICON");
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = COLOR_APPWORKSPACE+1;
    wc.lpszMenuName  = szMainMenu;  
    wc.lpszClassName = szMainClass;

    if ( !RegisterClass(&wc) )
        return(FALSE);

    return(TRUE);

} //*** InitApplication

//*************************************************************
//
//  InitInstance()
//
//  Purpose:
//
//		Initializes each instance (window creation)
//
//
//  Parameters:
//
//      HANDLE hInstance - Instance handle of application.
//      int    nCmdShow  - How window is initially displayed.
//      
//
//  Return: (BOOL)
//
//      TRUE  - Window created and displayed.
//      FALSE - Window not created.
//
//
//  Comments:
//
//
//  History:    Date       Author     Comment
//              12/12/91   MSM        Modified by GGB on 7/28/93
//
//*************************************************************

BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{

    ghInst = hInstance;

    ghWndMain = CreateWindow( szMainClass, 
                              "Plotting TrueType Sample Application",  
                              WS_OVERLAPPEDWINDOW,           
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              CW_USEDEFAULT,
                              NULL,
                              NULL,
                              hInstance,
                              NULL );

    if (!ghWndMain)
        return(FALSE);

    ShowWindow(ghWndMain, nCmdShow);
    UpdateWindow(ghWndMain);

    return(TRUE);

} //*** InitInstance

/*** EOF: init.c ***/
