//*************************************************************
//  File name: global.h
//
//  Description: 
//      Global include file for #defines and prototypes
//
//  History:    Date       Author     Comment
//              7/28/93    GGB
//*************************************************************

#include <windows.h>
#include <commdlg.h>


/* Menu Defines */
    #define IDM_ABOUT      100
    #define IDM_PRINT      101
    #define IDM_PRINTSETUP 102
    #define IDM_FONTS      103
    #define IDM_EXIT       110
    #define IDM_STATIC1    200

/* Function Prototypes */

    int  PASCAL     WinMain (HANDLE, HANDLE, LPSTR, int);
    long FAR PASCAL MainWndProc (HWND, unsigned, WORD, LONG);
    BOOL FAR PASCAL About (HWND, unsigned, WORD, LONG);
    void            SelectFont (HWND hWnd);
    BOOL            GetPrinterReady (HWND hWnd);
    BOOL            PrintIt(HWND hWnd, LPPRINTDLG lpPD, HDC hPrnDC);
    int  FAR PASCAL PrintAbortDlg (HWND hWnd, unsigned msg, WORD wParam, LONG lParam);
    BOOL FAR PASCAL PrintAbortProc (HDC hDC, short code);
    void            DrawGlyphOutlines(HDC hdc,int xWidth,int yHeight);
    FIXED           FloatToFixed( double d );
    void            DrawXMark( HDC hdc, POINTFX ptfx, int xText, int yText);
    int             MapFY( FIXED fy );
    int             MapFX( FIXED fx );

/* Init.c */
    BOOL InitApplication(HANDLE);
    BOOL InitInstance (HANDLE, int);

/* EXTERNS for Global Variables */
    extern HANDLE       ghInst;
    extern HWND         ghWndMain;

    extern char         szMainMenu[];
    extern char         szMainClass[];

    extern BOOL         gbAbort;
    extern HWND         ghDlgAbort;
    extern HFONT        ghScreenFont;

/*** EOF: global.h ***/
