//
// Project: Toolbars under IBM User Interface Class Libraries
// File:    Toolbar.cpp
// Author:  Stewart Hyde
// Created: Nov   29, 1993
// Updated: Nov   30, 1993
//
// Description:
//

#include <iapp.hpp>                     //IApplication Class
#include "toolbar.hpp"
#include "toolbar.h"


ToolBar::ToolBar(unsigned long windowId)        //Define Toolbar Constructor
    : IFrameWindow (                            //Call IFrameWindow constructor
      IFrameWindow::menuBar,                  //  Get Menu Bar from Resource File
      windowId)                                 //  Main Window ID
{
    handleEventsFor(this);              //Set self as command event handler
    setFocus();                         //Set focus to main window
    show();                             //Set to show main window
} /* end ToolBar :: ToolBar(...) */

Boolean ToolBar::command(ICommandEvent& cEvent)    //Define command member function
{
    if (cEvent.commandId() == MI_CLOSE) //Is Command Event Id = Close Id
    {                                   //  Yes, the command is close
      close();                          //  Let's close the main window
      return true;                      //  Normally, you would return true
    };                                  //  to indicate command processed
    return false;                       //Return Command not Processed
} /* end Bar :: command(...) */


MainWin::MainWin(unsigned long windowId)        //Define Toolbar Constructor
    : IFrameWindow (                            //Call IFrameWindow constructor
      IFrameWindow::defaultStyle()              //  Use default styles plus
      | IFrameWindow::menuBar,                  //  Get Menu Bar from Resource File
      windowId)                                 //  Main Window ID
{
   IString aString("Simple Toolbar Example");  //Create text string for static text
   IStaticText * staticText=new        //Create Static Text Control
      IStaticText(5002, this, this);    //  Pass in myself as parent & owner
   staticText->setText(aString);       //Set text in Static Text Control

   setupMenuBar(windowId);

   createTopToolBar();
   createSideBar();


   handleEventsFor(this);              //Set self as command event handler
   setClient(staticText);              //Set button control in Client Area
   setFocus();                         //Set focus to main window
   show();                             //Set to show main window
} /* end ToolBar :: ToolBar(...) */

MainWin::~MainWin()
{
   destroyTopToolBar();
   destroySideBar();
}


void MainWin :: setupMenuBar(unsigned long windowId)  //Setup Menu Bar                       
{                                       //                                     
  menuBar=new IMenuBar(windowId,        //Create Menu Bar for main window     
    this);                              //  Set self as parent                 .
    fToolBarActive = false; 
    fSideBarActive = false; 
    ICommandHandler::handleEventsFor(this);//Set self as command event handler  
} /* end MainWin :: setupMenuBar() */                       



void MainWin::createTopToolBar()
{
   if (!fToolBarActive)
   {
      //
      // Not create the toolbar by setting up a frame extension for a frame
      // window that a collect of bitmaps for items...
      //
	   menuBar->disableItem(MI_ENABLE_TOP);	 
	   menuBar->enableItem(MI_DISABLE_TOP);	 


      myToolBar = new ToolBar(WND_BAR);
      addExtension(myToolBar,IFrameWindow::aboveClient, 40);         
      fToolBarActive = true;
   }
}


void MainWin::destroyTopToolBar()
{
   if (fToolBarActive)
   {

	   menuBar->enableItem(MI_ENABLE_TOP);	 
	   menuBar->disableItem(MI_DISABLE_TOP);	 


      removeExtension(myToolBar);
      delete myToolBar;
      fToolBarActive = false;
   }
}


void MainWin::createSideBar()
{
   if (!fSideBarActive)
   {
      //
      // Not create the sidebar by setting up a frame extension for a frame
      // window that a collect of bitmaps for items...
      //
	   menuBar->disableItem(MI_ENABLE_SIDE);	 
	   menuBar->enableItem(MI_DISABLE_SIDE);	 


      mySideBar = new ToolBar(WND_SIDE);
      addExtension(mySideBar,IFrameWindow::rightOfClient, 40);         
      fSideBarActive = true;
   }
}


void MainWin::destroySideBar()
{
   if (fSideBarActive)
   {

	   menuBar->enableItem(MI_ENABLE_SIDE);	 
	   menuBar->disableItem(MI_DISABLE_SIDE);	 


      removeExtension(mySideBar);
      delete mySideBar;
      fSideBarActive = false;
   }
}


Boolean MainWin::command(ICommandEvent& cEvent)    //Define command member function
{
    switch (cEvent.commandId())
    {
      case MI_CLOSE:
         close();
         break;
      case MI_ENABLE_TOP:
         createTopToolBar();
         break;
      case MI_DISABLE_TOP:
         destroyTopToolBar();
         break;
      case MI_ENABLE_SIDE:
         createSideBar();
         break;
      case MI_DISABLE_SIDE:
         destroySideBar();
         break;
      default:
         return false;
    }                        
    return true;                       //Return Command not Processed
} /* end Toolbar :: command(...) */


void main()                             //Main Procedure with no parameters
{
  MainWin mainWindow(WND_MAIN);         //Create main window on the desktop
  IApplication::current().run();        //Get current application & start runnig
} /* end main */

