


STRFTIME(3)            C LIBRARY FUNCTIONS            STRFTIME(3)



NAME
     strftime - generate formatted time information

SYNOPSIS
     #include <sys/types.h>
     #include <time.h>

     size_t strftime(char *s, size_t maxsize, const char *format,
          const struct tm *timeptr);

DESCRIPTION
     The following description is transcribed verbatim  from  the
     December  7,  1988 draft standard for ANSI C.  This draft is
     essentially identical in technical content to the final ver-
     sion of the standard.

     The strftime  function  places  characters  into  the  array
     pointed  to  by  s as controlled by the string pointed to by
     format.  The format shall be a multibyte character sequence,
     beginning and ending in its initial shift state.  The format
     string consists of zero or more  conversion  specifiers  and
     ordinary  multibyte characters.  A conversion specifier con-
     sists of a % character followed by a character  that  deter-
     mines  the  behavior of the conversion specifier.  All ordi-
     nary multibyte characters (including  the  terminating  null
     character)  are copied unchanged into the array.  If copying
     takes place between objects that  overlap  the  behavior  is
     undefined.   No more than maxsize characters are placed into
     the  array.   Each  conversion  specifier  is  replaced   by
     appropriate  characters  as described in the following list.
     The appropriate characters are  determined  by  the  LC_TIME
     category  of  the current locale and by the values contained
     in the structure pointed to by timeptr.

     %a   is replaced by the locale's abbreviated weekday name.

     %A   is replaced by the locale's full weekday name.

     %b   is replaced by the locale's abbreviated month name.

     %B   is replaced by the locale's full month name.

     %c   is replaced by the locale's appropriate date  and  time
          representation.

     %d   is replaced by the day of the month as a decimal number
          (01-31).

     %H   is replaced by the hour (24-hour clock)  as  a  decimal
          number (00-23).

     %I   is replaced by the hour (12-hour clock)  as  a  decimal



Sun Release 4.1           Last change:                          1






STRFTIME(3)            C LIBRARY FUNCTIONS            STRFTIME(3)



          number (01-12).

     %j   is replaced by the day of the year as a decimal  number
          (001-366).

     %m   is replaced by the month as a decimal number (01-12).

     %M   is replaced by the minute as a decimal number (00-59).

     %p   is replaced by the locale's  equivalent  of  the  AM/PM
          designations associated with a 12-hour clock.

     %S   is replaced by the second as a decimal number (00-61).

     %U   is replaced by the week number of the year  (the  first
          Sunday  as the first day of week 1) as a decimal number
          (00-53).

     %w   is replaced by the  weekday  as  a  decimal  number  [0
          (Sunday)-6].

     %W   is replaced by the week number of the year  (the  first
          Monday  as the first day of week 1) as a decimal number
          (00-53).

     %x   is replaced by the locale's appropriate date  represen-
          tation.

     %X   is replaced by the locale's appropriate time  represen-
          tation.

     %y   is replaced by the year without century  as  a  decimal
          number (00-99).

     %Y   is replaced by the  year  with  century  as  a  decimal
          number.

     %Z   is replaced by the time zone name or  abbreviation,  or
          by no characters if no time zone is determinable.

     %%   is replaced by %.

     If a conversion specifier is  not  one  of  the  above,  the
     behavior is undefined.

RETURNS
     If the total number of resulting  characters  including  the
     terminating  null  character  is  not more than maxsize, the
     strftime function returns the number  of  characters  placed
     into the array pointed to by s not including the terminating
     null character.  Otherwise, zero is returned  and  the  con-
     tents of the array are indeterminate.



Sun Release 4.1           Last change:                          2






STRFTIME(3)            C LIBRARY FUNCTIONS            STRFTIME(3)



NON-ANSI EXTENSIONS
     If SYSV_EXT is defined when the routine  is  compiled,  then
     the  following  additional  conversions  will  be available.
     These are borrowed from the System  V  _c_f_t_i_m_e(3)  and  _a_s_c_f_-
     _t_i_m_e(3) routines.

     %D   is equivalent to specifying %m/%d/%y.

     %e   is replaced by the day of  the  month,  padded  with  a
          blank if it is only one digit.

     %h   is equivalent to %b, above.

     %n   is replaced with a newline character (ASCII LF).

     %r   is equivalent to specifying %I:%M:%S %p.

     %R   is equivalent to specifying %H:%M.

     %T   is equivalent to specifying %H:%M:%S.

     %t   is replaced with a TAB character.

     If SUNOS_EXT is defined when the routine is  compiled,  then
     the  following  additional  conversions  will  be available.
     These are borrowed from the SunOS version of _s_t_r_f_t_i_m_e.

     %k   is replaced by the hour (24-hour clock)  as  a  decimal
          number  (0-23).  Single digit numbers are padded with a
          blank.

     %l   is replaced by the hour (12-hour clock)  as  a  decimal
          number  (1-12).  Single digit numbers are padded with a
          blank.

POSIX 1003.2 EXTENSIONS
     If POSIX2_DATE is  defined,  then  all  of  the  conversions
     available with SYSV_EXT and SUNOS_EXT are available, as well
     as the following additional conversions:

     %C   The century, as a number between 00 and 99.

     %u   is replaced by the  weekday  as  a  decimal  number  [1
          (Monday)-7].

     %V   is replaced by the week number of the year  (the  first
          Monday  as the first day of week 1) as a decimal number
          (01-53).  The method for determining the week number is
          as  specified by ISO 8601 (to wit: if the week contain-
          ing January 1 has four or more days in  the  new  year,
          then  it is week 1, otherwise it is week 53 of the pre-
          vious year and the next week is week 1).



Sun Release 4.1           Last change:                          3






STRFTIME(3)            C LIBRARY FUNCTIONS            STRFTIME(3)



     The  text  of  the  POSIX  standard  for  the  _d_a_t_e  utility
     describes %U and %W this way:

     %U   is replaced by the week number of the year  (the  first
          Sunday  as the first day of week 1) as a decimal number
          (00-53).  All days in a new year  preceding  the  first
          Sunday are considered to be in week 0.

     %W   is replaced by the week number of the year  (the  first
          Monday  as the first day of week 1) as a decimal number
          (00-53).  All days in a new year  preceding  the  first
          Monday are considered to be in week 0.

     In addition, the alternate representations  %Ec,  %EC,  %Ex,
     %Ey,  %EY, %Od, %Oe, %OH, %OI, %Om, %OM, %OS, %Ou, %OU, %OV,
     %Ow, %OW, and %Oy are recognized, but their normal represen-
     tations are used.

VMS EXTENSIONS
     If VMS_EXT is defined, then the following additional conver-
     sion is available:

     %v   The date in VMS format (e.g. 20-JUN-1991).

SEE ALSO
     _t_i_m_e(2), _c_t_i_m_e(3), _l_o_c_a_l_t_i_m_e(3), _t_z_s_e_t(3)

BUGS
     This version does not handle  multibyte  characters  or  pay
     attention  to  the  setting of the LC_TIME environment vari-
     able.

     It is not clear what is ``appropriate'' for  the  C  locale;
     the values returned are a best guess on the author's part.

CAVEATS
     The pre-processor symbol  POSIX_SEMANTICS  is  automatically
     defined, which forces the code to call _t_z_s_e_t(3) whenever the
     TZ environment variable has changed.  If this  routine  will
     be used in an application that will not be changing TZ, then
     there may be some performance improvements by  not  defining
     POSIX_SEMANTICS.

AUTHOR
     Arnold Robbins

     INTERNET: arnold@skeeve.atl.ga.us
     UUCP:     emory!skeeve!arnold
     Phone:    +1 404 248 9324

ACKNOWLEDGEMENTS
     Thanks to Geoff Clare  <gwc@root.co.uk>  for  helping  debug



Sun Release 4.1           Last change:                          4






STRFTIME(3)            C LIBRARY FUNCTIONS            STRFTIME(3)



     earlier versions of this routine, and for advice about POSIX
     semantics.   Additional  thanks  to   Arthur   David   Olsen
     <ado@elsie.nci.nih.gov>  for some code improvements.  Thanks
     also to Tor Lillqvist <tml@tik.vtt.fi> for code fixes to the
     ISO 8601 code.


















































Sun Release 4.1           Last change:                          5



