TITLE   HANDLER.ASM -- Sample Windows DLL ISR
;****************************************************************************
;
;   PROGRAM: handler.asm
;
;   PURPOSE: 
;
;   FUNCTIONS:
;
;   Copyright (c) 1991 Microsoft Corporation. All rights reserved.
;
;****************************************************************************   

        .286
memM    EQU 1                   ;Medium memory model

        .xlist
        include windows.inc
        include cmacros.inc
        include handler.inc
        .list


nHookVector   EQU 09h
DOS_SetVector EQU 2500h
DOS_GetVector EQU 3500h

sBegin  Data
staticD dOldVector,0
staticW nCount,0
staticW hWndApp,0
sEnd

sBegin  Code
        assumes cs,Code
        assumes ds,Data
;****************************************************************************
;  FUNCTION: LibMain(HANDLE, WORD, WORD, LPSTR)
;
;  PURPOSE:  Is called by LibEntry.  LibEntry is called by Windows when
;            the DLL is loaded.  The LibEntry routine is provided in
;            the LIBENTRY.OBJ in the SDK Link Libraries disk.  (The
;            source LIBENTRY.ASM is also provided.)  
;
;            LibEntry initializes the DLL's heap, if a HEAPSIZE value is
;            specified in the DLL's DEF file.  Then LibEntry calls
;            LibMain.  The LibMain function below satisfies that call.
;            
;            The LibMain function should perform additional initialization
;            tasks required by the DLL. LibMain should return a value of 1
;            if the initialization is successful.
;          
;****************************************************************************   
cProc LibMain, <FAR,PUBLIC>, <si,di>
parmW	hModule;
parmW   wDataSeg;
parmW   cbHeapSize;
parmD   lpszCmdLine;
        
cBegin  LibMain
        cCall   Install_Handler,<>
        mov     ax,1
cEnd    LibMain


;****************************************************************************
;   FUNCTION:  WEP(int)
;
;   PURPOSE:  Performs cleanup tasks when the DLL is unloaded.  WEP() is
;             called automatically by Windows when the DLL is unloaded (no
;             remaining tasks still have the DLL loaded). 
;
;******************************************************************************/
cProc WEP, <FAR,PUBLIC>, <si,di>
parmW   bSystemExit

cBegin  WEP
        int 1
        cCall   De_Install_Handler,<>
        mov     ax,1
cEnd    WEP


;****************************************************************************
;   FUNCTION:  SetISRWindow(HWND)
;
;   PURPOSE:  This routine receives the handle to the window that should
;             receive ISRM_RUPT messages.
;
;****************************************************************************   
cProc SetISRWindow, <FAR,PUBLIC>, <si,di>
parmW   hWnd
cBegin  SetISRWindow
        int 1
        mov     ax,hWnd
        mov     hWndApp,ax
cEnd    SetISRWindow



;****************************************************************************
;   FUNCTION:  GetISRCount()
;
;   PURPOSE:  This function simply returns the value of nCount to the
;             caller.
;
;****************************************************************************   
cProc GetISRCount, <FAR,PUBLIC>, <si,di>
cBegin  GetISRCount 
        mov     ax,nCount
cEnd    GetISRCount 


;****************************************************************************
;   FUNCTION:  Do_Int()
;
;   PURPOSE:  This routine is called by the ISR in the Install_Handler
;             routine. Note that this routine is EXPORTED, so when it
;             is called, DS is loaded with the default data segment of
;             this DLL. Thus, the routine has access to dOldVector, so
;             it can call the next interrupt handler in the chain.
;
;
;****************************************************************************   
cProc Do_Int, <FAR,PUBLIC>, <si,di>
cBegin  Do_Int

        pushf
        call    DWORD PTR dOldVector ; do DOS timer

        inc     nCount
        cmp     hWndApp,0
        jz      doiexit

        mov     bx,ISRM_RUPT
        sub     ax,ax
        cCall   PostMessage,<hWndApp,bx,nCount,ax,ax>
        jmp     doiexit

        xor     ax,ax
        mov     hWndApp,ax
doiexit:

cEnd    Do_Int


;****************************************************************************
;   FUNCTION:  Install_Handler()
;
;   PURPOSE:  This routine saves the interrupt vector "nHookVector" in
;             the global variable "dOldVector". Then, it installs a small
;             ISR at that vector which calls the routine "Do_Int()" when
;             the interrupt occurs.
;          
;
;****************************************************************************   
cProc Install_Handler, NEAR, <si,di>
cBegin  Install_Handler

        push    bx                      ;Save previous handler
        push    es
        mov     ax,DOS_GetVector + nHookVector
        int     21h
        mov     WORD PTR dOldVector,bx
        mov     WORD PTR dOldVector+2,es
        pop     es
        pop     bx


        push    ds                      ;Install handle
        push    dx                      ;
        push    cs
        pop     ds
        mov     dx,OFFSET MyISR
        mov     ax,DOS_SetVector + nHookVector
        int     21h
        pop     dx      ;
        pop     ds      ;

        jmp     set_exit

MyISR:                          ;Our ISR
            pusha
            push    ds
            push    es

            cCall   Do_Int              ;Do Interrupt Handling

            pop     es
            pop     ds
            popa
            iret                        ;exit MyISR
                
set_exit:                           ;exit Install_Handler                    

cEnd    Install_Handler


;****************************************************************************
;   FUNCTION:  De_Install_Handler()
;
;   PURPOSE:  Restores the interrupt vector "nHookVector" with the address
;             at "dOldVector".
;
;****************************************************************************   
cProc De_Install_Handler, NEAR, <si,di>
cBegin  De_Install_Handler

        push    ds                      ;
        push    dx                      ;
        mov     dx,WORD PTR dOldVector
        mov     ax,WORD PTR dOldVector+2
        cmp     dx,0                    ;were we installed?
        jnz     dih_go
        cmp     ax,0
        jz      dih_skip
dih_go:
        mov     ds,ax
        mov     ax,DOS_SetVector + nHookVector
        int     21h
dih_skip:
        pop     dx      ;
        pop     ds      ;

cEnd    De_Install_Handler



sEnd
        end
