#include <ole2.h>
#include <dispatch.h> 
#include <olenls.h>

// Dialog IDs
#define IDD_CREATEOBJECT  100
#define IDD_SETPROPERTY   101
#define IDD_GETPROPERTY   102
#define IDD_INVOKEMETHOD  103

// Control IDs
#define IDC_NAME        200
#define IDC_VALUE       201
#define IDC_ENGLISH     202
#define IDC_FRENCH      203
#define IDC_GERMAN      204
#define IDC_STRING      205
#define IDC_INT         206
#define IDC_REAL        207
#define IDC_RETURNVALUE 208

// Menu-item IDs
#define IDM_CREATEOBJECT  300
#define IDM_SETPROPERTY   301
#define IDM_GETPROPERTY   302
#define IDM_INVOKEMETHOD  303
#define IDM_RELEASEOBJECT 304    

// MAX len of string table entries
#define STR_LEN   100

// String table constants
#define IDS_PROGNAME                   1
#define IDS_CANNOTDISPLAYRETURNVALUE   2
#define IDS_ERROR                      3

// Locale IDs for the languages that are supported
#define LCID_ENGLISH MAKELCID(MAKELANGID(0x09, 0x01))
#define LCID_FRENCH  MAKELCID(MAKELANGID(0x0c, 0x01))  
#define LCID_GERMAN  MAKELCID(MAKELANGID(0x07, 0x01))

// Function prototypes
int PASCAL WinMain (HINSTANCE, HINSTANCE, LPSTR, int);
BOOL InitApplication (HINSTANCE);
BOOL InitInstance (HINSTANCE, int);
BOOL InitOle(void);
void UninitOle();
LRESULT __export CALLBACK MainWndProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

BOOL __export CALLBACK CreateObjectDlgFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL __export CALLBACK SetPropertyDlgFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL __export CALLBACK GetPropertyDlgFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL __export CALLBACK InvokeMethodDlgFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);

HRESULT CreateObject(LPSTR lpszProgID, IDispatch FAR* FAR* ppdisp);
HRESULT SetProperty(LPSTR lpszPropName, LPSTR lpszValue, VARTYPE vt, LCID lcid, LPDISPATCH pdisp);
HRESULT GetProperty(LPSTR lpszPropName, LCID lcid, LPDISPATCH pdisp);
HRESULT InvokeMethod(LPSTR lpszMethodName, LCID lcid, LPDISPATCH pdisp);
void DisplayReturnValue(LPVARIANTARG lpvarg);
void ReportError(HRESULT hr, LPSTR szFuncName, LPSTR szFileName, int nLineNumber);

typedef struct _dlgdata
{
    char    szName[100];        // ProgID, property name or method name.     
    char    szValue[100];       // Property value. Read as a string.
    VARTYPE vt;                 // Property type.
    LCID    lcid;               // Locale ID.
} DLGDATA, FAR* LPDLGDATA;

