;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   ppdbg.inc
;
;   Macros to set and clear printer port bits
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


LPT1    equ 3BCH
LPT2    equ 378H
LPT3    equ 278H

DBGPORT equ LPT1

PPDBGSET MACRO maskbits

        push ax
        push dx

        mov dx, DBGPORT
        mov ah, maskbits

        pushf
        cli             ; we want this atomic

        in al, dx
        or al, ah
        out dx, al

        popf

        pop dx
        pop ax

        ENDM


PPDBGCLEAR MACRO maskbits

        push ax
        push dx

        mov dx, DBGPORT
        mov ah, maskbits
        not ah

        pushf
        cli             ; we want this atomic

        in al, dx
        and al, ah
        out dx, al

        popf

        pop dx
        pop ax

        ENDM
