; Unsigned comparison of two 64-bit numbers
;   result preserves sign logic of ExtSub()
;
; Tim Victor, January 5, 1993
;
; Callable from C as follows:
; int ExtCmp(src, dest);
;
;   returns:
;      1 if dest > src
;      0 if dest = src
;     -1 if dest < src
;
        .model  small
        .code
        public _ExtCmp
_ExtCmp proc near

        push bp         ; save caller's stack frame
        mov  bp,sp      ; address stack frame of this call
        push si
        push di

        mov  si,[bp+4]  ; source address
        mov  di,[bp+6]  ; dest address

        mov  ax,[di+6]  ; compare high words first
        sub  ax,[si+6]
        jne  retrnval

        mov  ax,[di+4]
        sub  ax,[si+4]
        jne  retrnval

        mov  ax,[di+2]
        sub  ax,[si+2]
        jne  retrnval

        mov  ax,[di]
        sub  ax,[si]
        je   exithere   ; return 0 if equal

retrnval:
        mov  ax,1
        ja   exithere   ; flags unchanged since last cmp
        mov  ax,-1

exithere:
        pop  di
        pop  si
        pop  bp

        ret

_ExtCmp endp
        end

