;compile this .asm file as normal
;use the link option /cp:60 which will allocate this program
;60 paragraphs of memory
;exe format
DOSSEG

.MODEL  SMALL

.STACK  100h

.DATA

INT_NUMBER      EQU     21h             ;INTERRUPT NUMBER TO HOOK INTO
LOAD_PARAMETERS DW      00h
                DW      0080h           ;COMMAND LINE IN PSP - OFFSET
                DW      @CURSEG         ;       SEGMENT
                DW      005Ch           ;FIRST FCB IN PSP    - OFFSET
                DW      @CURSEG         ;       SEGMENT
                DW      006Ch           ;SECOND FCB IN PSP   - OFFSET
                DW      @CURSEG         ;       SEGMENT

OLD_VECTOR      DD      0H              ;STORAGE FOR OLD INTERRUPT
                                        ;VECTOR
MEM_SIZE        EQU     200h            ;FUTURE USE FOR INT 21 SERV.4A
PROGRAM_NAME    DB      "HUMANS.EXE",0  ;**********must be changed!!!
OFFSET_1        EQU     94A3h           ;FIRST OFFSET TO MAKE CHANGES
VALUE_1         EQU     0DBh            ;THESE ARE THE NEW VALUES TO BE
HEADER          DB      "         **TOP**",0Dh,0Ah,0Ah
                DB      "   TIRED OF PROTECTION",0Dh,0Ah,0Ah
                DB      "CRACKED BY THE MAD DOCTOR",0Dh,0Ah,"$"
FAILED_LOAD     DB      0Ah,0Ah,"FAILED TO LOAD PROGRAM",0Dh,0Ah,"$"
NOT_FOUND       DB      "FILE NOT FOUND",0Dh,0Ah,"$"
INSUF_MEMORY    DB      "INSUFFICIENT MEMORY",0Dh,0Ah,"$"


.CODE

LOADER          PROC

        JMP     START

INTERRUPT_ENTRY         PROC    FAR
        PUSHF
        PUSH    AX                      ;SAVE NEEDED REGISTERS
        PUSH    BX
        PUSH    BP
        PUSH    DS
        CMP     AH,49h
        JNZ     QUIT
        MOV     AX,SP
        MOV     BP,AX
        CMP     [BP+0Ah],8F9Bh
        JNZ     QUIT
        MOV     AX,[BP+0Ch]
        MOV     DS,AX
        MOV     BX,OFFSET_1             ;FIRST OFFSET
        MOV     AL,VALUE_1
        MOV     [BX],AL                 ;MOV VALUE_1 INTO DS:OFFSET_1
        
QUIT:
        POP     DS
        POP     BP                      ;RESTORE NEEDED REGISTERS
        POP     BX
        POP     AX
        POPF
        JMP     DWORD PTR CS:OLD_VECTOR ;JMP TO THE REST OF THE
                                        ;INTERRUPT

INTERRUPT_ENTRY         ENDP

START           PROC

        MOV     BX,DGROUP               ;INITIALIZE DS TO THE DATA
        MOV     DS,BX                   ;SEGMENT
        MOV     DX,OFFSET HEADER
        MOV     AH,9
        INT     21h                     ;PRINT A TITLE
        PUSH    DS
        PUSH    DS
        MOV     AL,INT_NUMBER
        MOV     AH,35h
        INT     21h                     ;GET INT VECTOR FOR INT21
                                        ;AND PUT INTO ES:BX
        MOV     WORD PTR OLD_VECTOR[0],BX     ;SAVE OLD INT VECTORS
        MOV     WORD PTR OLD_VECTOR[2],ES
        MOV     DX,OFFSET INTERRUPT_ENTRY
        MOV     AX,CS
        MOV     DS,AX
        MOV     AL,INT_NUMBER
        MOV     AH,25h
        INT     21h                     ;PUT NEW INT VECTOR IN FOR
                                        ;INTERRUPT_ENTRY
        POP     DS                      ;RE-INITIALIZE DS AND ES TO
        POP     ES                      ;THE DATA SEGMENT
        MOV     DX,OFFSET PROGRAM_NAME
        MOV     BX,OFFSET LOAD_PARAMETERS
        MOV     AX,4B00h                ;LOAD PROGRAM, NAME AT DS:DX,
        INT     21h                     ;PARAMETERS AT ES:BX
        JNC     RESTORE                 ;JMP IF LOAD WAS SUCCESSFUL
        PUSH    AX
        MOV     AH,9                    ;PRINT THAT LOAD FAILED
        MOV     DX,OFFSET FAILED_LOAD
        INT     21h
        POP     AX
        CMP     AX,8                    ;IF AX=8 THEN THERE WAS
        JE      NO_MEMORY               ;INSUFFICIENT MEMORY
        CMP     AX,2
        JNE     RESTORE                 ;IF NOT 2 OR 8 THEN ?--
                                        ;JUST RESTORE AND EXIT
        MOV     DX,OFFSET NOT_FOUND     ;IF AX=2 THEN THE FILE WAS NOT
        JMP     PRINT_ERROR             ;FOUND
NO_MEMORY:
        MOV     DX,OFFSET INSUF_MEMORY
PRINT_ERROR:
        MOV     AH,9
        INT     21h
RESTORE:
        LDS     DX,DWORD PTR OLD_VECTOR
        MOV     AL,INT_NUMBER           ;RESTORE OLD INTERRUPT VECTOR
        MOV     AH,25h
        INT     21h
        MOV     AX,4C00h                ;EXIT TO DOS
        INT     21h

START           ENDP
LOADER          ENDP
        END     LOADER

