**************************************************************************
*                                                                        *
*  PRICELST.PRG                                                          *
*                                                                        *
*  Sample Price List printing program utilizing HPPCL 5 functions.       *
*  Requires an HP LaserJet series IIIP, III, IIID, IIIsi, IV, or         *
*  or later model printer.                                               *
*                                                                        *
**************************************************************************

FUNCTION PriceLst()

  LOCAL i, j, k, nLine
  LOCAL nDiff :=  0.15, ;
        nCol1 :=  1.5, ;
        nCol2 :=  3.1, ;
        nCol3 :=  5.625, ;
        nCol4 :=  6.625, ;
        nCol5 :=  8

  ****
  * Create Price List Array:
  * Generally, this type of information would come from a database
  *
  * { { Part name, { { Item, { { contents, weight, price }, ... } } },
  *   { Part name, { { Item, { { contents, weight, price }, ... } } }, ... }
  ****
  LOCAL aParts := {                                                 ;
                    { "All Purpose Cleaners",                       ;
                      {                                             ;
                        { "All Cleaners",                           ;
                          {                                         ;
                            {            "Quart",    1,    3.00 },  ;
                            {           "Gallon",    4,   11.00 },  ;
                            {       "2.5 gallon",   10,   25.00 },  ;
                            {         "5 gallon",   20,   45.00 },  ;
                            {       "3x5 gallon",   60,  120.00 },  ;
                            {      "10x5 gallon",  218,  400.00 }   ;
                          }                                         ;
                        }                                           ;
                      }                                             ;
                    },                                              ;
                    { "Window Cleaner",                             ;
                      {                                             ;
                        { "Commercial Ammonia Formula",             ;
                          {                                         ;
                            {            "Quart",    1,    2.00 },  ;
                            {           "Gallon",    4,    7.00 },  ;
                            {       "2.5 gallon",   10,   14.00 },  ;
                            {         "5 gallon",   20,   25.00 },  ;
                            {       "3x5 gallon",   60,   70.00 },  ;
                            {      "10x5 gallon",  218,  240.00 }   ;
                          }                                         ;
                        }                                           ;
                      }                                             ;
                    },                                              ;
                    { "Specialty Cleaners",                         ;
                      {                                             ;
                        { "Wood cleaners",                          ;
                          {                                         ;
                            {           "Gallon",    4,    4.00 },  ;
                            {         "5 gallon",   20,   18.00 }   ;
                          }                                         ;
                        },                                          ;
                        { "Metal polish",                           ;
                          {                                         ;
                            {    "16 Ounce Tube",  1.5,    3.50 },  ;
                            {    "24 Ounce Tube",  2.0,    4.50 }   ;
                          }                                         ;
                        },                                          ;
                        { "Plastic cleaner",                        ;
                          {                                         ;
                            {           "Gallon",    4,    4.00 },  ;
                            {         "5 gallon",   20,   18.00 }   ;
                          }                                         ;
                        },                                          ;
                        { "Carpet cleaner",                         ;
                          {                                         ;
                            {         "5 Gallon",   20,   18.00 },  ;
                            {       "3x5 gallon",    4,   45.00 }   ;
                          }                                         ;
                        },                                          ;
                        { "Upholstery cleaner",                     ;
                          {                                         ;
                            {           "Gallon",    4,    4.00 }   ;
                          }                                         ;
                        },                                          ;
                        { "Spot remover",                           ;
                          {                                         ;
                            {            "Quart",   .5,    3.50 }   ;
                          }                                         ;
                        },                                          ;
                        { "Germicidal cleaner",                     ;
                          {                                         ;
                            {           "Gallon",    4,    5.00 },  ;
                            {         "5 gallon",   20,   22.00 }   ;
                          }                                         ;
                        },                                          ;
                        { "Hand cleaner",                           ;
                          {                                         ;
                            {           "Gallon",    5,    4.50 },  ;
                            {         "5 gallon",   20,   20.00 }   ;
                          }                                         ;
                        },                                          ;
                        { "Asphault cleaner",                       ;
                          {                                         ;
                            {         "5 Gallon",   20,   18.00 }   ;
                          }                                         ;
                        },                                          ;
                        { "Adhesive remover",                       ;
                          {                                         ;
                            {    "24 Ounce Tube",    1,    4.00 }   ;
                          }                                         ;
                        }                                           ;
                      }                                             ;
                    },                                              ;
                    { "Special Orders",                             ;
                      {                                             ;
                      }                                             ;
                    }                                               ;
                  }

  SETCOLOR('w/b')
  @ 3,0 CLEAR

  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape ver 3.0 - Sample Price List Printing Program'

  ****
  * Display screen message
  ****
  ShowBox('Printing Sample Price List...')

  *************************************************************************
  * BEGIN PRINTING PRICE LIST USING ESCAPE                                *
  *************************************************************************

  hpPrintOn()
  hpConfig('LETTER', 'P', 1, 'IIIP')
  hpSetFont( 'UNIVERS','I',, 15 )

  hpPhysical(.T.)

  ****
  * Draw the company logo
  ****

  ****
  * Parameters for circle are <center row>, <center col>, <radius>,
  * <border thickness in dots>, <% gray>, <pattern #>, <units of measure>
  ****
  hpIGrayBox( .25, .3, 1.9, 2.8, 1, 20 )
  hpCircle( 1.2, 1.05, .55, 1, 100, 0, 'I' )
  hpAtSay( 1.1, .65, hpReverse( "THE", 100), "I" )
  hpSetFont( 'UNIVERS','I',, 24 )
  hpAtSay( 1.4, .65, hpReverse( "SPOT",100 ) + " SHOP", "I" )
  hpIGrayBox( 1.5, 1.05, 1.55, 2.65, 1, 80 )
  hpIGrayBox( 1.6, 1.05, 1.65, 2.65, 1, 80 )
  hpIGrayBox( 1.7, 1.05, 1.75, 2.65, 1, 80 )

  hpSetFont( 'CGTIMES','I',, 24 )

  ****
  * Display the title of the report
  ****
  hpIGrayBox( .68, 4, .75, 5.75, 1, 100 )
  hpIAtSay( .75, 6, "Price List" )

  hpSetFont( 'CGTIMES','I',, 12 )
  hpIAtSay( 1, 6, DTOC( DATE() ) )

  hpSetFont( 'CGTIMES','I',, 10 )

  ****
  * Draw square bullets
  ****
  hpIGrayBox( 1.20, 4, 1.26, 4.06, 1, 100 )
  hpIGrayBox( 1.35, 4, 1.41, 4.06, 1, 100 )
  hpIGrayBox( 1.50, 4, 1.56, 4.06, 1, 100 )
  hpIGrayBox( 1.65, 4, 1.71, 4.06, 1, 100 )
  hpIGrayBox( 1.80, 4, 1.86, 4.06, 1, 100 )

  ****
  * ... and their corresponding messages
  ****
  hpIAtSay( 1.25, 4.25, "$15 minimum order." )
  hpIAtSay( 1.40, 4.25, "Prices FOB Portland, OR.")
  hpIAtSay( 1.55, 4.25, "Prices subject to change without notice." )
  hpIAtSay( 1.70, 4.25, "Shipment via UPS or most convenient carrier." )
  hpWrap( "All orders shipped COD unless prepaid by check, money order, credit card", 1.85, 4.25, 3, .8, "I" )

  ****
  * Start at 2.25 inches down
  ****
  nLine := 2.25

  ****
  * Start the report
  ****
  FOR i := 1 TO LEN( aParts )

    ****
    * Draw head line
    ****
    hpIGrayBox( nLine, 1.4, nLine+.10, 2.5, 1, 100 )
    hpIGrayBox( nLine+.05, 1.4, nLine+0.10, 8.25, 1, 100 )
    nLine += nDiff*1.5

    hpSetFont( 'CGTIMES','I',, 12 )
    hpIAtSay( nLine, nCol1, hpBold( aParts[i, 1] ) )

    IF LEN( aParts[i, 2] ) > 0

      hpSetFont( 'CGTIMES','I',, 9 )
      hpIAtSay( nLine, nCol2, hpBold( "Item" ) )
      hpIRJust( hpBold( "Net Contents" ), nLine, nCol3 )
      hpICenter( hpBold( "Shipping wt." ), nLine, nCol4 )
      hpIRJust( hpBold( "Price" ), nLine, nCol5 )

      nLine += nDiff   //.10

      hpSetFont( 'CGTIMESI','I',, 8 )
      hpIRJust( "U.S. Measure", nLine, nCol3 )
      hpICenter( "Pounds", nLine, nCol4 )
      hpIRJust( "U.S. $", nLine, nCol5 )

      nLine += nDiff/2

      hpIBox( nLine, nCol2-.05, nLine, 8.25 )
      nLine += nDiff

      hpSetFont( 'CGTIMES','I',, 10 )

      FOR j := 1 TO LEN( aParts[i, 2] )

        ****
        * Draw line to separate items
        ****
        IF j > 1
          hpIBox( nLine, nCol2-.05, nLine, 8.25 )
          nLine += nDiff*.6 // .10
        ENDIF

        ****
        * Item name
        ****
        hpIAtSay( nLine, nCol2, aParts[i, 2, j, 1] )

        FOR k := 1 TO LEN( aParts[i, 2, j, 2] )
          hpIRJust( aParts[i, 2, j, 2, k, 1], nLine, nCol3 )
          hpIRJust( ALLTRIM( STR( aParts[i, 2, j, 2, k, 2] ) ), nLine, nCol4 )
          hpIRJust( ALLTRIM( STR( aParts[i, 2, j, 2, k, 3] ) ), nLine, nCol5 )
          nLine += nDiff  // 0.15
        NEXT
      NEXT
    ENDIF
  NEXT

  ****
  * Finish up price list
  ****
  hpSetFont( 'CGTIMES','I',, 10 )

  nLine += nDiff/2
  hpIBox( nLine, nCol2-.05, nLine, 8.25 )
  nLine += nDiff

  hpWrap( "Please call our toll free number for our full color catalog of over 100 " + ;
          "industrial and household cleaning products.", nLine, nCol2, nCol5-nCol2, 1, "I" )

  nLine += nDiff * hpMLCount("Buy a half-drum of hardener (27.5 gallons) at half the full drum price " + ;
                             "when also buying a full drum of resin.", nCol5-nCol2, "I" )

  hpIBox( nLine, nCol2-.05, nLine, 8.25 )
  nLine += nDiff

  hpIAtSay( nLine, nCol2, "Special discounts apply for large volume orders in the following quantities:" )
  nLine += nDiff

  ****
  * Two more square bullets
  ****
  hpIGrayBox( nLine-.05, nCol2, nLine + 0.01, nCol2 + 0.06, 1, 100 )
  hpIAtSay( nLine, nCol2 + .25, "Industrial cleaners - 55 gallon (drum)." )
  nLine += nDiff                 

  hpIGrayBox( nLine-.05, nCol2, nLine + 0.01, nCol2 + 0.06, 1, 100 )
  hpIAtSay( nLine, nCol2 + .25, "Household cleaners - 20x5 gallons." )

  ****
  * Draw little address at bottom left corner
  ****
  hpSetFont( 'CGTIMES','I',, 8 )
  hpIGrayBox( 9.9, .25, 9.93, 1.375, 1, 100 )

  hpIAtSay( 10, .35, hpbold( "The Spot Shop" ) )
  hpIAtSay( 10.13, .35, "PO Box 89073" )
  hpIAtSay( 10.26, .35, "Portland, OR  93502" )
  hpIAtSay( 10.39, .35, "800/426-3410" )

  hpReset()
  hpPrintOff()

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  INKEY(1)

RETURN NIL
