* All reported problems are fixed:
* 
*   The squishing of words when justifying text
*   hpTrans(), hpC2I(), hpC2M() all checked out okay.  See samples below.
*   hpSetFont no longer re-loads tables when selecting fonts.
* 
* Enhancements:
*   
*   hpJust() and hpWrap() now return the number of lines it printed.
*     See example below and compare it to how you originally had to count 
*     lines.
*   Bolding, underlining, superscripts and subscripts can be incorporated
*     into wrapping and justifying.  See samples below.
*   PCX files can now be rotated in 90 degree increments.  See samples below.


#define SPACING  0.25
#define WIDTH    3.3
#define LEFTCOL  0.3
#define RIGHTCOL 4.4
#define RULER    "I"

Procedure Problem
Local text[10],line,totlines

text[1] :=  hpUnderLine(hpBold("Administrator:"))+"  This term means the firm or organization named in the Schedule of "
text[1]+=   "Insurance authorized by you and approved by us to perform certain administrative "
text[1]+=   "functions with respect to this Policy brought about through an Administrative "+;
            "Service Only agreement.  The Administrator may not be changed without prior written "
text[1]+=   "approval from us."

text[2] :=  hpUnderLine( hpBold( "Aggregate Stop-Loss (ASL) Benefits:"))+" are Policy Benefit Payments for Program Benefits "
text[2]+=   "shown under ASL Benefits in the Schedule of Insurance, less any amounts which are our "
text[2]+=   "liability based upon the Individual Stop Loss and Hospital Supplement provisions, and "
text[2]+=   "less any amounts which are your liability based upon the Policyholder's ISL Deductible.  "
text[2]+=   "In the first stop-loss year, ASL benefits must be incurred during the stop-loss year "
text[2]+=   "(or during the run-in period) and paid during the stop loss year.  [During the second "
text[2]+=   "and subsequent stop loss years must be incurred on or after the coverage effective date "
text[2]+=   "for Aggregate Stop Loss Insurance loss years, ASL benefits must be incurred during the "
text[2]+=   "stop-loss year and paid during the stop-loss year.]  The amount of ASL Benefits that you "
text[2]+=   "are liable for funding is explained in the section entitled 'Your Liability'.  Policy Benefit "
text[2]+=   "Payments paid during the Terminal Protection Period are also ASL Benefits."

text[3] :=  hpUnderLine( hpBold( "Aggregate Limitation Factor:" ))+"  is a factor which is multiplied by the Yearly Payment Limit "
text[3]+=   "or the Minimum Yearly Payment Limit, whichever is greater, to calculate the maximum ASL "+;
            "Benefits reimbursed by us in the current stop loss year that we can recover from you in "
text[3]+=   "future stop-loss years or in the Terminal Protection Period.  The factor is shown in the "
text[3]+=   "Schedule of Insurance."

text[4] :=  hpUnderLine( hpBold( "ASL Percentage:" ))+"  is a percentage which is divided into the Yearly Payment Limit or the Minimum "
text[4]+=   "Yearly Payment Limit, whichever is greater.  The result is used to calculate the additional "
text[4]+=   "amount, if any, above the Terminal Payment Limit which may be your liability during the Terminal "
text[4]+=   "Protection Period.  The percentage is shown in the Schedule of Insurance and the additional "
text[4]+=   "Policyholder liability, if any, is explained in the section entitled 'After This Policy Ends'."

text[5] :=  hpUnderLine( hpBold( "ASL Co-Pay Limit:" ))+"  is the maximum amount of ASL Benefits for which you are liable based upon the "+;
            "ASL Co-Pay Percentage.  The ASL Co-Pay Limit is shown in the Schedule of Insurance."

text[6] :=  hpUnderLine( hpBold("Benefit Funding Account:" ) )+ "  means the bank account from which benefit payments, "+;
            "for which you are liable, are paid."

text[7] :=  hpUnderLine( hpBold( "Benefits are Incurred:" ))+"  (1) for major medical expense, on the date the convered "
text[7]+=   "service or supply is furnished to the covered person; (2) for employee weekly "
text[7]+=   "loss of time expense insurance, the date for which income is being replaced; and "
text[7]+=   "(3) for dental expense insurance, the date described in the Dental Expense "
text[7]+=   "provisions of the Program."

text[8] :=  hpBold( hpUnderLine("Benefits become Paid:" ) )+ "  on the date an EOB is issued.  Adjustments to benefits are "+;
            "considered paid on the date the original EOB was issued."

text[9] :=  "Benefits become paid on the date a check is mailed to them. Adjustments to "
text[9]+=   "benefits are considered paid on the date the original check was mailed."

text[10] := hpUnderLine( hpBold( "Claim Liability Factors:"))+"  are factors used in calculating the Monthly Amount.  Your "
text[10]+=  "claim liability factors are shown in the Schedule of Insurance."+hpSub("1")

clear
@ 11,0 say 'Printing... (the justification in this sample is written)'
@ 12,0 say '             to work with a series III printer)'
@ 14,0 say 'This may take a while.  Four PCX files are being printed.'
@ 15,0 say 'Also, 90 and 270 degree rotations take longer.'

HpPrintOn()

HpConfig('LETTER', 'P', 1, 'III')

HpSetFont('UNIVERS','I',,12)
HpCenter(hpBold('DEFINITIONS'),1)

////////////////////////////////////
//         P A G E   # 1          //
////////////////////////////////////

// Page #1: Column #1 //
HpSetFont('UNIVERS','I',,10)
line     := 0.75
totlines := HpJust(text[1],line,LEFTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[2],line,LEFTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[3],line,LEFTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[4],line,LEFTCOL,WIDTH,1,RULER)

// Page #1: Column #2 //
line     := 0.75
totlines := HpJust(text[5],0.75,RIGHTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[6],line,RIGHTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[7],line,RIGHTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[8],line,RIGHTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[9],line,RIGHTCOL,WIDTH,1,RULER)
line     := line+HpL2I(totlines)+SPACING
totlines := HpJust(text[10],line,RIGHTCOL,WIDTH,1,RULER)

/////////////////
//  PCX Rotation - new last parameter options (90,180,270)
/////////////////

line     := line+HpL2I(totlines)+SPACING
hpPcx( line, RIGHTCOL, "SCHED.PCX", "I" )
hpPcx( line, RIGHTCOL+1.5, "SCHED.PCX", "I", 300, .F., 100, 90 )
hpPcx( line+1.5, RIGHTCOL, "SCHED.PCX", "I", 300, .F., 100, 180 )
hpPcx( line+1.5, RIGHTCOL+1.5, "SCHED.PCX", "I", 300, .F., 100, 270 )

hpAtSay( line + 3, RIGHTCOL, hpSuper('1') + " Notice the Rotations...", "I" )

/////////////////////
//  Test of hpTrans()
/////////////////////
eject
hpSetFont('COURIER 10', 'I')

? 'WITH HPTRANS (all characters print)'
FOR I=1 TO 30
  ? HPTRANS( CHR(I) )
NEXT

? 'WITHOUT HPTRANS (the eject is caused by the form feed character)'
FOR I=1 TO 30
  ? CHR(I)
NEXT


/////////////////////
//  Test of Conversion functions
/////////////////////
eject
// Select a 10 char/inch font
hpSetFont('COURIER 10', 'I')

// Set positioning to physical mode
hpPhysical(.T.)


hpAtSay(2, 2, 'This is 2" across (20 columns)', 'I') 
hpAtSay(3, hpC2I(20), 'This is also 2" across, using hpC2I()', 'I')

hpAtSay(5, 2, 'This is 2" across (20 columns)', 'I')
hpAtSay(hpI2M(6), hpC2M(20), 'This is also 2" across, using hpC2M()', 'M')

hpAtSay(8  , 2, hpBold("Remember, the hpC2?() functions don't work with proportional"), 'I')
hpAtSay(8.2, 2, hpBold('fonts since there is no such thing as a column when using'), 'I')
hpAtSay(8.4, 2, hpBold('these fonts'), 'I')
HpClrFonts()

HpReset()
HpPrintOff()

clear

RETURN
