**************************************************************************
*                                                                        *
*  SAMPLES.PRG                                                           *
*                                                                        *
*  Main program for ESCAPE! ver 3.0 samples                              *
*                                                                        *
**************************************************************************

#xcommand DEFAULT <xVar> TO <xValue> => ;
  IF <xVar> == NIL; <xVar> := <xValue>; END


#include "setcurs.ch"
#include "inkey.ch"

PROCEDURE MAIN()

LOCAL aMainChoice := { "A. Sample Printout", ;
                       "B. Calendar" , ;
                       "C. Font List" , ;
                       "D. Cartridge List" , ;
                       "E. General Ledger" , ;
                       "F. Envelope" , ;
                       "G. Overlay/Macro Example" , ;
                       "H. Word Wrapping Example" , ;
                       "I. HPPCL 5 Examples - HP III/IV's only" , ;
                       "J. Order Form" , ;
                       "X. Exit"  }

LOCAL aPCL5Choice := { "A. Invoice", ;
                       "B. Price List" , ;
                       "X. Exit to Main Menu" }

LOCAL nMainChoice := 1
LOCAL nSubChoice  := 1
LOCAL cHPPCLScreen
LOCAL GETLIST
LOCAL aMenuColor := { "bg/b", "n/w", "w+/w", "r/w" }

  SET EXCLUSIVE OFF
  SET SCOREBOARD OFF
  SET CONFIRM ON

  // Display initioal information screen
  SETCOLOR('W+/B')
  CLEAR SCREEN
  ShowBox({' ', ;
          'All of the samples, which can be printed using the following program,', ;
          'have been created entirely with ESCAPE! ver. 3.0 and CA-Clipper 5.0x.', ;
          ' ', ;
          'An HP LaserJet IIx or greater printer is required to print the samples.', ;
          'Additional HPPCL 5 samples can be printed if you have a series III', ;
          'or IV type printer.' , ;
          ' ', ;
          'Press any key to continue...', ;
          ' '})
  INKEY(0)

  // Display Menu
  WHILE (.T.)
    DispMenu("Escape! ver 3.0 - Program Samples", "Select a Menu Option", ;
      aMainChoice, @nMainChoice, aMenuColor)
    DO CASE
    CASE nMainChoice == 1
      SubMenu('SAMPLE.PRG', { || Sample() }, aMenuColor)

    CASE nMainChoice == 2
      SubMenu('CALENDAR.PRG', { || Calendar() }, aMenuColor)

    CASE nMainChoice == 3
      SubMenu('HPFONTS.PRG', { || hpFonts() }, aMenuColor)

    CASE nMainChoice == 4
      SubMenu('HPCARTS.PRG', { || hpCarts() }, aMenuColor)

    CASE nMainChoice == 5
      SubMenu('GENLEDGR.PRG', { || GenLedgr() }, aMenuColor)

    CASE nMainChoice == 6
      SubMenu('ENV.PRG', { || Env() }, aMenuColor)

    CASE nMainChoice == 7
      SubMenu('OVERLAY.PRG', { || Overlay() }, aMenuColor)

    CASE nMainChoice == 8
      SubMenu('WRAP.PRG', { || Wrap() }, aMenuColor)

    CASE nMainChoice == 9
      WHILE (.T.)
        DispMenu("", "Select a HPPCL 5 Option", aPCL5Choice, ;
          @nSubChoice, aMenuColor, .F., 9, 40)
        cHPPCLScreen := SAVESCREEN(0, 0, MAXROW(), MAXCOL())
        DO CASE
        CASE nSubChoice == 1
          SubMenu('INVOICE.PRG', { || Invoice() }, aMenuColor)
        CASE nSubChoice == 2
          SubMenu('PRICELST.PRG', { || PriceLst() }, aMenuColor)
        CASE nSubChoice == 0 .or. nSubChoice == 3
          EXIT
        ENDCASE
        RESTSCREEN(0, 0, MAXROW(), MAXCOL(), cHPPCLScreen)
      END

    CASE nMainChoice == 10
      SubMenu('ORDERFRM.PRG', { || OrderFrm() }, aMenuColor)

    CASE nMainChoice == 0 .OR. nMainChoice == 11
      EXIT
    ENDCASE

  END

  SETCOLOR('W+/B')
  CLEAR SCREEN
  ShowBox('Thank you for trying ESCAPE!')
  INKEY(2)
  SET COLOR TO
  CLEAR

RETURN

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
FUNCTION DispMenu( cSysname, cMnuname, aChoices, nChoice, aMenuColor, lClear, nStartRow, nStartCol )

LOCAL nX, nJ, nKey, nCol, nMax, nXMid, nMidPoint, lOneCol, nM, I
LOCAL nIndex, nLine, nBase, nLen
LOCAL nArrayLen := LEN( aChoices )
LOCAL aRow[nArrayLen], aCol[nArrayLen], aKey[nArrayLen], aMid[nArrayLen]
LOCAL nBoxHeight
LOCAL cOldColor

  SET CURSOR OFF

  DEFAULT nChoice TO 1
  DEFAULT lClear TO .T.

  nChoice := MAX( nChoice, 1 )
  cOldcolor := SETCOLOR()

  IF lClear
    SETCOLOR("w/b")
    SetAttrib(3, 0, 23, 79, aMenuColor[1], chr(176))

    SETCOLOR("w+/bg")
    @ 0, 0, 2, 79 BOX 'Ŀ '
    @ 1, 2 SAY cSysname
    @ 1, 70 SAY DTOC(DATE())
  END

  // Set nMax to length of menu title.
  nMax := LEN(cMnuname)

  // Find length of longest menu choice
  AEVAL( aChoices, { | cName | nMax := MAX( nMax, LEN( cName ) ) } )

  // Find box coordinates
  nMidPoint := ROUND( (nArrayLen-1) / 2, 0)

  // Add 3 lines FOR Menu Title.
  nBoxHeight := nArrayLen + 3

  IF nBoxHeight > 14
    // Two Column Menu
    lOneCol := .F.
    IF nStartRow == NIL
      nLine := 12 - round((round(nBoxHeight/2, 0)+5)/2, 0)  // top line
    ELSE
      nLine := nStartRow
    END
    nBase := nLine+ROUND(nBoxHeight/2, 0)+5       // bottom line
    IF nStartCol == NIL
      nCol := 35-nMax                             // starting column of box
    ELSE
      nCol := nStartCol
    END
    nLen := (nMax * 2) + 8                        // width of box
  ELSE
    // One Column Menu
    lOneCol := .T.
    IF nStartRow == NIL
      nLine := 12 - round( (nBoxHeight+4) / 2, 0) // top line
    ELSE
      nLine := nStartRow
    END
    nBase   := nLine + nBoxHeight + 4             // bottom line
    IF nStartCol == NIL
      nCol  := 39 - round( nMax / 2, 0) - 3       // starting column of box
    ELSE
      nCol  := nStartCol
    END
    nLen    := nMax + 6                           // width of box
  END
  nMax += 4
  nLine++

  // Add width to the box to accomodate borders
  nLen++

  SETCOLOR('w+/w')
  @ 24, 0 CLEAR
  @ 24, 0
  @ 24, 2 SAY "Use     or     keys, then press"
  @ 24, 40 SAY ', or hit the letter of your selection.'

  SETCOLOR('gr+/w')
  @ 24, 06 SAY ' ' + chr(24) + ' '
  @ 24, 13 SAY ' ' + chr(25) + ' '
  @ 24, 34 SAY ' ' + chr(17) + chr(196) + chr(217) + ' '

  SETCOLOR(aMenuColor[1])

  // Draw surrounding box and line below menu title
  SETCOLOR("n/w")
  @ nLine, nCol, nBase, nCol+nLen BOX 'Ŀ '
  @ nLine+2, nCol+1 TO nLine+2, nCol+nLen-1
  Shadow(nLine, nCol, nBase, nCol+nLen)

  SETCOLOR("w+/w")
  @ nLine+1, nCol+1 SAY PADC( cMnuname, nLen-1 )

  nLine += 3
  nCol += 4
  nJ := 0

  SETCOLOR(aMenuColor[2])

  FOR nIndex := 1 TO nArrayLen-1
    aKey[nIndex] := ''
    IF lOneCol .OR. nIndex <= ROUND((nArrayLen-1)/2, 0)
      IF !EMPTY(aChoices[nIndex])
        nJ++
        @ nLine + nIndex, nCol SAY aChoices[nIndex]
        aKey[nJ] := LEFT( aChoices[nIndex], 1)
      END

      aRow[nIndex] := nLine+nIndex
      aCol[nIndex] := nCol

    ELSE

      IF !EMPTY(aChoices[nIndex])
        nJ++
        @ nLine+nIndex-ROUND((nArrayLen-1)/2, 0), nCol+nMax SAY aChoices[nIndex]
        aKey[nJ] := LEFT( aChoices[nIndex], 1 )
      ENDIF

      aRow[nIndex] := nLine + nIndex - ROUND( (nArrayLen-1 ) / 2, 0)
      aCol[nIndex] := nCol + nMax

    ENDIF
  NEXT

  nJ++

  IF lOneCol
    @ nBase - 2, nCol SAY aChoices[nArrayLen] // space last option down 1
    aKey[nJ] := LEFT( aChoices[nArrayLen], 1)
    aRow[nArrayLen] := nBase - 2
    aCol[nArrayLen] := nCol

  ELSE

    @ nBase-1, 39-ROUND(LEN(aChoices[nArrayLen])/2, 0) SAY aChoices[nArrayLen]
    aKey[nJ] := LEFT( aChoices[nArrayLen], 1)
    aRow[nArrayLen] := nBase-1
    aCol[nArrayLen] := 39 - LEN(aChoices[nArrayLen]) / 2

  ENDIF

  nM := nJ

  // Determine starting differences between 2 columns, IF more than 1 col
  nXMid := nMidPoint
  FOR nJ := 1 TO nMidPoint
    IF EMPTY(aChoices[nJ])
      nXMid--
    ENDIF
  NEXT

  // Determine left/right arrow positions
  FOR nJ := 1 TO nMidPoint
    IF EMPTY(aChoices[nJ])
      nXMid++
    ENDIF
    IF EMPTY(aChoices[nJ+nMidPoint])
      nXMid--
    ENDIF
    aMid[nJ] := nXMid
    aMid[nJ+nMidPoint] := nXMid
  NEXT

  /* Initialize position
  Accomodate FOR EMPTY array positions by setting nZ to the absolute
  position within the array that corresponds to the starting choice nX
  is just a counter
  */

  i := FindPosition( nChoice, aChoices )
  nX := nChoice

  SETCOLOR(aMenuColor[3])
  @ aRow[i], aCol[i] SAY aChoices[i]
  SETCOLOR(aMenuColor[4])
  @ aRow[i], aCol[i]-2 SAY ''
  SETCOLOR(aMenuColor[2])

  WHILE (.T.)
    nKey := INKEY(0)

    DO CASE
      // Escape
    CASE nKey = 27 .or. chr(nKey) = '0'
      nChoice := 0
      EXIT

    CASE nKey = 13
      nChoice := nX
      EXIT

    CASE (UPPER(CHR(nKey)) >= 'A' .AND. UPPER(CHR(nKey)) <= 'Z') .OR. ;
      (UPPER(CHR(nKey)) >= '0' .and. UPPER(CHR(nKey)) <= '9')

      IF ( nJ := ASCAN(aKey, UPPER(CHR(nKey))) ) > 0
        nChoice := nJ

        // Dull current menu choice
        SETCOLOR(aMenuColor[2])
        @ aRow[i], aCol[i] - 2 SAY "  " + aChoices[i]

        // High-light selected menu choice
        i := FindPosition( nChoice, aChoices )
        SET CURSOR OFF

        SETCOLOR(aMenuColor[3])
        @ aRow[i], aCol[i] SAY aChoices[i]
        SETCOLOR(aMenuColor[4])
        @ aRow[i], aCol[i]-2 SAY ''
        SETCOLOR(aMenuColor[2])

        EXIT
      ENDIF

    CASE nKey = 24 // down arrow
      SETCOLOR(aMenuColor[2])

      @ aRow[i], aCol[i] - 2 SAY "  " + aChoices[i]

      i := IIF(i >= nArrayLen, i, i+1)

      WHILE (EMPTY(aChoices[i]))
        i := IIF(i >= nArrayLen, i, i+1)
      END

      nX := IIF(nX >= nM, nX, nX + 1)

      SETCOLOR(aMenuColor[4])
      @ aRow[i], aCol[i]-2 SAY ""

      SETCOLOR(aMenuColor[3])
      @ aRow[i], aCol[i] SAY aChoices[i]

    CASE nKey = 5                                                                                             // up arrow
      SETCOLOR(aMenuColor[2])
      @ aRow[i], aCol[i] - 2 SAY "  " + aChoices[i]

      i := IIF(i <= 1, i, i-1)

      WHILE (EMPTY(aChoices[i]))
        i := IIF(i <= 1, i, i-1)
      END

      nX := IIF(nX <= 1, nX, nX - 1)

      SETCOLOR(aMenuColor[4])
      @ aRow[i], aCol[i] - 2 SAY ""

      SETCOLOR(aMenuColor[3])
      @ aRow[i], aCol[i] SAY aChoices[i]

    CASE nKey = 4     // right arrow
      DO CASE
      CASE lOneCol
        TONE(100, 2)
      CASE i + nMidPoint >= nArrayLen
        TONE(100, 4)
      CASE EMPTY( aChoices[ i + nMidPoint] )
        TONE(100, 4)
      OTHERWISE
        SETCOLOR(aMenuColor[2])
        @ aRow[i], aCol[i] - 2 SAY "  "+ aChoices[i]
        i += nMidPoint
        nX := IIF( nX + aMid[i] > nM, nX, nX + aMid[i])
        SETCOLOR(aMenuColor[4])
        @ aRow[i], aCol[i]-2 SAY ""

        SETCOLOR(aMenuColor[3])
        @ aRow[i], aCol[i] SAY aChoices[i]

      END

    CASE nKey = 19     // LEFT arrow
      DO CASE
      CASE lOneCol
        TONE(100, 2)
      CASE i - nMidPoint <= 0
        TONE(100, 4)
      CASE EMPTY(aChoices[i-nMidPoint])
        TONE(100, 4)
      OTHERWISE
        SETCOLOR(aMenuColor[2])
        @ aRow[i], aCol[i]-2 SAY "  "+aChoices[i]
        nX := IIF(nX-aMid[i] <= 0, nX, nX - aMid[i])
        i -= nMidPoint

        SETCOLOR(aMenuColor[4])
        @ aRow[i], aCol[i]-2 SAY CHR(16)

        SETCOLOR(aMenuColor[3])
        @ aRow[i], aCol[i] SAY aChoices[i]

      END
    END
  END

  SETCOLOR(cOldcolor)
  SET CURSOR ON

RETURN (nChoice)

// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
FUNCTION FindPosition( nChoice, aChoices )
LOCAL nX := 0, nZ := 0

  WHILE (nX < nChoice)
    nZ++
    IF !EMPTY(aChoices[nZ])
      nX++
    END
  END
RETURN (nZ)


* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
PROCEDURE SHADOW( nTop, nLeft, nBottom, nRight )
  SetAttrib(nTop+1, nRight+1, nBottom+1, nRight+1, "n+")
  SetAttrib(nBottom+1, nLeft+1, nBottom+1, nRight+1, "n+")
RETURN

// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
PROCEDURE SubMenu( cFileName, bFunction, aMenuColor )

LOCAL aSubChoice := { "1. Print Sample", ;
                      "2. View Program Source Code" , ;
                      "3. Print Program Source Code" , ;
                      "0. Exit to Main Menu" }

LOCAL nPrintSubChoice := 1
LOCAL cSubScreen

  WHILE (.T.)

    DispMenu("", "Select an Option", aSubChoice, @nPrintSubChoice, ;
      aMenuColor, .F., 11, 11)

    cSubScreen := SAVESCREEN(0, 0, MAXROW(), MAXCOL())

    DO CASE

    CASE nPrintSubChoice == 1
      EVAL(bFunction)
    CASE nPrintSubChoice == 2
      ViewCode(cFileName, 'Escape ver. 3.0 - ' + cFileName + ' Code Sample')
    CASE nPrintSubChoice == 3
      hpDump( cFileName, "2" )
    CASE nPrintSubChoice == 0 .OR. nPrintSubChoice == 4
      EXIT
    ENDCASE

    RESTSCREEN(0, 0, MAXROW(), MAXCOL(), cSubScreen)

  END

RETURN

// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
PROCEDURE ViewCode( cFile, cTitle )

LOCAL cOldColor := SETCOLOR('w/b')

  @ 3, 0 CLEAR
  @ 3, 0 TO 23, 79 DOUBLE

  SETCOLOR("w+/bg")
  @ 0, 0 CLEAR TO 2, 79
  @ 0, 0 TO 2, 79
  @ 1, 2 say cTitle

  SETCOLOR('w+/w')
  @ 24, 0
  @ 24, 16 SAY "Use   and   keys to view code, or <esc> to exit"

  SETCOLOR('gr+/w')
  @ 24, 20 SAY chr(24)
  @ 24, 26 SAY chr(25)
  @ 24, 50 SAY '<esc>'

  SETCOLOR('w+/b')
  SET CURSOR ON
  MEMOEDIT(MEMOREAD(cFile), 4, 2, 22, 78, .F., '', 150, 2)
  SET CURSOR OFF

  SETCOLOR(cOldColor)

RETURN

// /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
PROCEDURE SetAttrib( nTop, nLeft, nBottom, nRight, cColor, cChar )
LOCAL cScreen, cText := "", i, nWidth := nRight-nLeft+1
  IF cChar != NIL
    DispBox(nTop, nLeft, nBottom, nRight, REPLICATE(cChar, 9), cColor)
  ELSE
    cScreen := SAVESCREEN( nTop, nLeft, nBottom, nRight)
    FOR i := 1 to LEN(cScreen) STEP 2
      cText += SUBSTR(cScreen, i, 1)
    NEXT
    FOR i := nTop to nBottom
      DevPos(i, nLeft)
      DispOut(SUBSTR(cText, (i-nTop)*nWidth+1, nWidth), cColor)
    NEXT
END

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
PROCEDURE ShowBox(Message,cBoxColor,cMsgColor,nSecs,nBorder)

LOCAL nMaxLen := 0
LOCAL nTopText, nIndex, nLeftText, nTopRow, nLeftCol, nBottRow, nRightCol
LOCAL aMessage
LOCAL cOldColor, cScreen

  IF VALTYPE(Message) = 'C'
    ****
    * If a character string was passed, change it to a one element array
    ****
    aMessage := { Message }
  ELSE
    aMessage := Message
  ENDIF

  IF cBoxColor = NIL
    cBoxColor := 'N/W'
  ENDIF
  IF cMsgColor = NIL
    cMsgColor := 'W+/W'
  ENDIF
  IF nSecs = NIL
    nSecs := 0
  ENDIF
  IF nBorder = NIL
    nBorder := 1
  ENDIF

  nTopText := 12 - INT(LEN(aMessage)/2) 

  ****
  * boundary checks
  ****
  IF nTopText < 2
    nTopText := 2
  ENDIF
  nBottRow := nTopText + LEN(aMessage)
  IF nBottRow > 23
    nTopText := nTopText - (nBottRow-23)
  ENDIF

  ****
  * determine longest line
  ****
  FOR nIndex := 1 TO LEN(aMessage)
    nMaxLen := MAX(nMaxLen, LEN(aMessage[nIndex]))
  NEXT

  nLeftText := 40-ROUND(nMaxLen/2,0)  && starting column of text
  ****
  * boundary checks
  ****
  IF nLeftText < 2  
    nLeftText := 2
  ENDIF
  nRightCol := nLeftText + nMaxLen + 1
  IF nRightCol > 79
    nLeftText := nLeftText - (nRightCol-79)
  ENDIF

  nTopRow   := nTopText - 1
  nBottRow  := nTopText + len(aMessage)
  nLeftCol  := nLeftText - 2
  nRightCol := nLeftText + nMaxLen + 1
 
  IF nSecs > 0
    cScreen := savescreen(nTopRow, nLeftCol, nBottRow+1, nRightCol+1)
  ENDIF

  ****
  * Draw box
  ****
  cOldColor := SETCOLOR(cBoxColor)
  @ nTopRow, nLeftCol CLEAR TO nBottRow, nRightCol
  DO CASE
    CASE nBorder == 1
      @ nTopRow, nLeftCol TO nBottRow, nRightCol
    CASE nBorder == 2
      @ nTopRow, nLeftCol TO nBottRow, nRightCol double
  ENDCASE

  ****
  * Draw shadows
  ****
  SetAttrib(nTopRow+1,nRightCol+1,nBottRow+1,nRightCol+1,"n+/n")
  SetAttrib(nBottRow+1,nLeftCol+1,nBottRow+1,nRightCol,"n+/n")

  ****
  * Display messages
  ****
  SETCOLOR(cMsgColor)
  FOR nIndex = 1 to LEN(aMessage)
    @ nTopText+nIndex-1,nLeftText SAY aMessage[nIndex]
  NEXT

  SETCOLOR(cOldColor)

  IF nSecs > 0
    KEYBOARD ""
    INKEY(nSecs)
    RESTSCREEN(nTopRow, nLeftCol, nBottRow+1, nRightCol+1, cScreen)
  ENDIF
RETURN

