**************************************************************************
*                                                                        *
*  HPFONTS.PRG                                                           *
*                                                                        *
*  Prints out a two column list of the font names supported by Escape.   *
*                                                                        *
**************************************************************************
#include "samples.ch"

FUNCTION hpFonts()

  ****
  * column positions
  ****
  LOCAL nFont1  := 1.25
  LOCAL nPitch1 := 2.5
  LOCAL nPoint1 := 3.5
  LOCAL nFont2  := nFont1  + 3
  LOCAL nPitch2 := nPitch1 + 3
  LOCAL nPoint2 := nPoint1 + 3

  LOCAL nCol
  LOCAL cCol
  LOCAL nLine                     && line counter 
  LOCAL nLastLn := 49
  LOCAL lGray   := .F.            && specifies whether a gray bar should be printed.

  FIELD Fontname, Pitch, Point, Fix_Prop

  ****
  * Display screen title
  ****
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape ver 3.0 - Sample Report Written with Escape'

  ****
  * Display screen messages
  ****
  ShowBox('Indexing...')

  USE FONTS 
  INDEX ON Fontname TO tempfonts

  *************************************************************************
  * BEGIN PRINTING REPORT USING ESCAPE                                    *
  *************************************************************************

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Downloading Fonts...')

  hpPrintOn()

  hpDownload("OPT12B.POR", 1, "LPT1",, DOWNLOADCHARS)
  hpDownload("OPT10.POR", 2, "LPT1",, DOWNLOADCHARS)

  hpPrintOff()
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Printing Font Name Report...')
  hpPrintOn()

  ****
  * Select the defaults of internal 10 pitch Courier font, and letter size
  * paper, Portrait orientation and 1 copy.
  ****
  hpConfig()

  DO WHILE .NOT. EOF()

    ****
    * Set font to the default internal Courier 10 font
    ****
    hpSetFont("OPT12B.POR","SF")

    ****
    * print surrounding box and shadow
    ****
    hpIBox(hpL2I(3), .5, hpL2I(55), 7.5)
    // hpIBoxShadow() is a UDF which can be found in EXAMPLES.PRG
    hpIBoxShadow(hpL2I(3), .5, hpL2I(55), 7.5, .16, 20)

    nLine := 7

    ****
    * Print title 
    ****
    hpICenter("List of HP LaserJet Font Names", hpL2I(nLine) )
    hpICenter("Supported by Escape", hpL2I(nLine+1) )

    ****
    * Print box and shadow surrounding title
    ****
    hpIBox(hpL2I(5), 2, hpL2I(10), 6.1)
    // hpIBoxShadow() is a UDF which can be found in EXAMPLES.PRG
    hpIBoxShadow(hpL2I(5), 2, hpL2I(10), 6.1, .16, 20)

    hpSetFont("OPT10.POR","SF")

    nLine += 8.8

    ****
    * Print column headings
    ****
    hpIAtSay( hpL2I(nLine), nFont1,  hpBold("FONT NAME"))
    hpIAtSay( hpL2I(nLine), nPitch1, hpBold("PITCH"))
    hpIAtSay( hpL2I(nLine), nPoint1, hpBold("POINT"))
    hpIAtSay( hpL2I(nLine), nFont2,  hpBold("FONT NAME"))
    hpIAtSay( hpL2I(nLine), nPitch2, hpBold("PITCH"))
    hpIAtSay( hpL2I(nLine), nPoint2, hpBold("POINT"))

    ****
    * Draw top double line
    **** 
    nLine++
    hpIBox(hpL2I(nLine), nFont1-.1, hpL2I(nLine), nPoint2+hpS2I("POINT"), 2)

    ****
    * Print font list
    ****
    FOR nCol = 1 TO 2
      cCol  := iif(nCol = 1,'1','2')
      nLine := 18
      lGray := .F.

      DO WHILE nLine <= nLastLn .AND. .NOT. EOF()
        hpIAtSay(hpL2I(nLine), iif(nCol == 1, nFont1, nFont2), Fontname)
        DO CASE
          CASE Fix_Prop == 'F'
            hpIAtSay(hpL2I(nLine), iif(nCol == 1, nPitch1, nPitch2), Pitch)
            hpIAtSay(hpL2I(nLine), iif(nCol == 1, nPoint1, nPoint2), Point)
          CASE Fix_Prop == 'P'
            hpIAtSay(hpL2I(nLine), iif(nCol == 1, nPitch1, nPitch2), "Prop")
            hpIAtSay(hpL2I(nLine), iif(nCol == 1, nPoint1, nPoint2), Point)
          CASE Fix_Prop == 'S'
            hpIAtSay(hpL2I(nLine), iif(nCol == 1, nPitch1, nPitch2), "Scalable")
        ENDCASE

        ****
        * draw a gray bar every other line
        ****
        IF lGray 
          hpIGrayBar(hpL2I(nLine), nFont1, nPoint1+hpS2I("POINT")-nFont1, 0, 10)
          hpIGrayBar(hpL2I(nLine), nFont2, nPoint2+hpS2I("POINT")-nFont2, 0, 10)
        ENDIF

        lGray := (.NOT. lGray)
        nLine++
        SKIP
      ENDDO
      IF EOF()
        nCol := 2  // Exit for loop
      ENDIF

    NEXT       

    ****
    * Draw double line at bottom of report
    ****
    IF nCol == 2
      hpIBox(hpL2I(nLine), nFont1-.1, hpL2I(nLine), nPoint2+hpS2I("POINT"), 2)
      hpIAtSay(hpL2I(nLine+1), nFont1, "Table  1.0")
    ELSE
      hpIBox(hpL2I(nLastLn+1), nFont1-.1, hpL2I(nLastLn+1), nPoint2+hpS2I("POINT"), 2)
      hpIAtSay(hpL2I(nLastLn+2), nFont1, "Table  1.0")
    ENDIF

    EJECT
  ENDDO

  hpReset()
  hpPrintOff()

  CLOSE DATABASES
  ERASE tempfonts.ntx

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  INKEY(1)

RETURN NIL


