************************************************************************
* HPBOXSHADOW ( nBegRow, bBegCol, nEndRow, nEndCol, nWidth, nShade, cSide )
* 
* Description: Creates a shadow around a seperately drawn box that is
*              any width and any shade of gray.
* 
* Parameters:  nBegRow is the top row of box to shadow
*              nBegCol is the left column of box to shadow
*              nEndRow is the bottom row of box to shadow
*              nEndCol is the right column of box to shadow
*
*              nWidth  is the width of the shadow in inches
*              nShade  is the shade of gray to fill shadow with
*
*              cSide   determines the side of the box, R(ight) or L(eft) to
*                      print the shadow
*
* Example:     HPBOX(1, 1, 10, 20)
*              HPBOXSHADOW(1, 1, 10, 20, (1/8), 60)  // 1/8" wide, 60% gray
************************************************************************
FUNCTION hpBoxShadow(nBegRow, nBegCol, nEndRow, nEndCol, nWidth, nShade, cSide)

IF cSide == NIL
  cSide := 'R'
ENDIF

* left shadow
IF UPPER(cSide) == 'L'
  hpIGrayBox( hpL2I(nBegRow)+nWidth, hpC2I(nBegCol)-nWidth,;
        hpL2I(nEndRow), hpC2I(nBegCol), 0, nShade)

  * bottom shadow
  HPIGrayBox( hpL2I(nEndRow), hpC2I(nBegCol)-nWidth,;
        hpL2I(nEndRow)+nWidth, hpC2I(nEndCol)-nWidth, 0, nShade)

* right shadow
ELSE
  HPIGrayBox( hpL2I(nBegRow)+nWidth, hpC2I(nEndCol), ;
         hpL2I(nEndRow), hpC2I(nEndCol)+nWidth, 0, nShade)

  * bottom shadow
  HPIGrayBox( hpL2I(nEndRow), hpC2I(nBegCol)+nWidth, ;
         hpL2I(nEndRow)+nWidth, hpC2I(nEndCol)+nWidth, 0, nShade)
ENDIF

RETURN NIL

************************************************************************
* HPIBOXSHADOW ( nBegRow, bBegCol, nEndRow, nEndCol, nWidth, nShade, cSide )
* 
* Description: Creates a shadow around a seperately drawn box that is
*              any width and any shade of gray.
* 
* Parameters:  nBegRow is the top of box to shadow in inches
*              nBegCol is the left side of box to shadow in inches
*              nEndRow is the bottom of box to shadow in inches
*              nEndCol is the right side of box to shadow in inches
*
*              nWidth  is the width of the shadow in inches
*              nShade  is the shade of gray to fill shadow with
*         
*              cSide   determines the side of the box, R(ight) or L(eft) to
*                      print the shadow
*
************************************************************************
FUNCTION hpIBoxShadow(nBegRow, nBegCol, nEndRow, nEndCol, nWidth, nShade, cSide)

IF cSide == NIL
  cSide := 'R'
ENDIF

* left shadow
IF UPPER(cSide) == 'L'
  hpIGrayBox( nBegRow+nWidth, nBegCol-nWidth, ;
         nEndRow, nBegCol, 0, nShade)

  * bottom shadow
  hpIGrayBox( nEndRow, nBegCol-nWidth, ;
         nEndRow+nWidth, nEndCol-nWidth, 0, nShade)

* right shadow
ELSE
  hpIGrayBox( nBegRow+nWidth, nEndCol, ;
         nEndRow, nEndCol+nWidth, 0, nShade)

  * bottom shadow
  hpIGrayBox( nEndRow, nBegCol+nWidth, ;
         nEndRow+nWidth, nEndCol+nWidth, 0, nShade)

ENDIF

RETURN NIL

************************************************************************
* HPICOLCTR ( nBegRow, nBegCol, nWidth, cString )
*
* Description: Center a string over a column (useful for column
*              headings).
* 
* Parameters:  nBegRow is the distance for top of page to print string
*              nBegCol is where column starts in inches
*              nWidth  is width of column in inches
*              cString is the string to center over column
************************************************************************
FUNCTION hpIColCtr( nBegRow, nBegCol, nWidth, cString )

  hpICenter( cString, nBegRow, nBegCol+( nWidth/2) )

RETURN NIL


************************************************************************
* HPCOLCTR ( nBegRow, nBegCol, nWidth, cString )
*
* Description: Center a string over a column (useful for column
*              headings).
* 
* Parameters:  nBegRow is row to print string on
*              nBegCol is where column starts
*              nWidth  is width of column
*              cString is the string to center over column
************************************************************************
FUNCTION hpColCtr( nBegRow, nBegcol, nWidth, cString)

  hpCenter( cString, nBegRow, nBegCol+(nWidth/2))

RETURN NIL


************************************************************************
* HPGRAYON ()
*
* Description: Create and enable a macro for auto overlay that causes
*              the laser printer to print gray bars in simulation of
*              green bar paper.  This is useful in creating a utility that
*              turns this feature on for other, non-Clipper, applications
*              (ie, Lotus 123).
*
*              CAUTION:  Do not send a reset after setting up the laser 
*              printer for overlaying or the overlay will be disabled.
* 
* Parameters:  None.
*
************************************************************************
FUNCTION hpGrayOn
LOCAL nX,nY,lGray,nBarLength,nLPP

nBarLength := 8   // Setting for letter or legal size paper, portrait
                  // orientation. Change for other paper size/orientations.

nLPP := 60        // number of Lines Per Page, currently set for letter
                  // paper, portrait orientation.  Change for other paper
                  // size/orientations.

hpStartMacro(1)
lGray := .F.
FOR nX := 0 TO nLPP STEP 3
  FOR nY := 0 TO 2
    IF lGray
      hpIGrayBar(hpL2I(nX+nY), 0, 8, 0, 10)
    ENDIF
  NEXT
  lGray := (.NOT. lGray)
NEXT
hpEndMacro(1)
hpOverlay(1)

RETURN NIL


************************************************************************
* HPDECJUST ( cString, nRow, nCol )
*
* Description: To right justify a decimal number at its decimal point.
* 
* Parameters:  cString is the character representation of the decimal
*                      number to right justify
*              nRow    is the row to right justify the string.
*              nCol    is the column to position the decimal point on.
************************************************************************
FUNCTION hpDecJust( cString, nRow, nCol)
LOCAL cLeft, cRight

cLeft := SUBSTR( cString, 1, AT('.', cString))
cRight := SUBSTR( cString, AT('.', cString)+1)

hpRJust( cLeft, nRow, nCol)
hpAtSay( nRow, nCol, cRight)

RETURN NIL


************************************************************************
* HPIDECJUST ( cString, nRow, nCol )
*
* Description: To right justify a decimal number at it's decimal point.
*              Position is specified in inches.
*              
* 
* Parameters:  cString is the character representation of the decimal
*                      number to right justify
*              nRow    is vertical position to print the string, in inches.
*              nCol    is the horizontal position, in inches, to right justify
*                      the decimal point.
************************************************************************
FUNCTION hpIDecJust( cString, nRow, nCol)
LOCAL cLeft,cRight

cLeft := SUBSTR(cString, 1, AT('.', cString))
cRight := SUBSTR(cString, AT('.', cString)+1)

hpIRJust(cLeft, nRow, nCol)
hpIAtSay(nRow, nCol, cRight)

RETURN NIL

