**************************************************************************
*                                                                        *
*  ENV.PRG                                                               *
*                                                                        *
*  Sample envelope printing program.                                     *
*                                                                        *
**************************************************************************

PROCEDURE Env()

  LOCAL cFont    := "COURIER 10  "
  LOCAL cCart    := "I "
  LOCAL cFeed    := " "
  LOCAL cEnvType := "BUSENV"

  LOCAL cFrName  := SPACE(40)
  LOCAL cFrAdd1  := SPACE(40)
  LOCAL cFrAdd2  := SPACE(40)
  LOCAL cFrCity  := SPACE(24)
  LOCAL cFrState := SPACE(2)
  LOCAL cFrZip   := SPACE(5)

  LOCAL cToName  := SPACE(40)
  LOCAL cToAdd1  := SPACE(40)
  LOCAL cToAdd2  := SPACE(40)
  LOCAL cToCity  := SPACE(24)
  LOCAL cToState := SPACE(2)
  LOCAL cToZip   := SPACE(5)

  LOCAL nLine    := 2

  MEMVAR GetList

  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  SETCOLOR('w+/bg')
  @ 0, 0, 2, 79 BOX 'Ŀ '
  @ 1, 2 SAY 'Escape ver 3.0 - Sample Envelope Printing Program'

  // Get input necessary to print envelope
  SETCOLOR('w+/w, w+/br, , , w+/n')
  @ 4, 1, 23, 78 BOX 'Ŀ ' COLOR 'n/w'

  @ 6, 5 SAY 'Font Info'
  SETCOLOR('n/w')
  @ 7, 7  SAY 'Font Name'
  @ 8, 7  SAY 'Cartridge Letter'
  @ 9, 7  SAY 'Envelope Type'
  @ 7, 24 GET cFont PICTURE '!!!!!!!!!!!!'
  @ 8, 24 GET cCart PICTURE '!!'
  @ 9, 24 GET cEnvType PICTURE '!!!!!!' VALID cEnvType == 'BUSENV'
  @ 7, 38 SAY '(Enter valid ESCAPE names for'
  @ 8, 38 SAY ' Font & Cartridge.)'

  SETCOLOR("w+/w")
  @ 11, 5  SAY 'From'
  SETCOLOR("n/w")
  @ 12, 7  SAY 'Name'
  @ 13, 7  SAY 'Address 1'
  @ 14, 7  SAY 'Address 2'
  @ 15, 7  SAY 'City, State  Zip'
  @ 12, 24 GET cFrName
  @ 13, 24 GET cFrAdd1
  @ 14, 24 GET cFrAdd2
  @ 15, 24 GET cFrCity
  @ 15, 48 SAY ", " GET cFrState PICTURE "@!"
  @ 15, 54 GET cFrZip PICTURE "99999"

  SETCOLOR("w+/w")
  @ 17, 5  SAY 'To'
  SETCOLOR("n/w")
  @ 18, 7  SAY 'Name'
  @ 19, 7  SAY 'Address 1'
  @ 20, 7  SAY 'Address 2'
  @ 21, 7  SAY 'City, State  Zip'
  @ 18, 24 GET cToName
  @ 19, 24 GET cToAdd1
  @ 20, 24 GET cToAdd2
  @ 21, 24 GET cToCity
  @ 21, 48 SAY ", " GET cToState PICTURE "@!"
  @ 21, 54 GET cToZip PICTURE "99999"

  READ               
  IF LASTKEY() == 27
    RETURN
  ENDIF

  SETCOLOR('w/b')
  @ 3, 0 CLEAR

  // Ask whether power or manual feed
  @ 10, 15, 14, 64 BOX 'Ŀ ' COLOR 'n/w'
  Shadow(10, 15, 14, 64)
  SETCOLOR('w+/w')
  @ 12, 17 SAY 'Power Envelope Feeder, or Manual Feed? (P/M)' GET cFeed ;
    PICTURE '!' VALID cFeed $ 'P/M'
  READ
  IF LASTKEY() == 27
    RETURN
  END

  // Display screen messages
  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  IF cFeed == 'M'
    ShowBox({'Prepare to feed envelope.', 'Press any key to continue...'})
  ELSE
   ShowBox({'Make sure envelope is loaded in the feeder.','Press any key to continue...'})
  END
  INKEY(0)

  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  ShowBox('Printing Sample Envelope...')

  ************************************************************************
  * Begin Printing Envelope                                              *
  ************************************************************************

  hpPrintOn()

  // Download font IF the user specified a soft font
  IF cCart == 'SF'
    hpDownload(TRIM(cFont), 1, "LPT1")
  END

  // Set up printer to receive envelope
  hpConfig(TRIM(cEnvType), "L", 1)

  // Select desired font
  hpSetFont(TRIM(cFont), TRIM(cCart))

  /*
  Set printer to envelope feed when manually feeding envelopes.  If
  using a power envelope feeder attachment for the IID, IIID, IIISI, or IV
  printer, then envelope feed does not have to be specified.
  */

  IF cFeed == 'M'
    hpFeed('ENV')
  END

  hpTMargin(0)

  // Print return (address)
  hpIAtSay(hpL2I(nLine), .1, TRIM(cFrName))
  nLine++
  hpIAtSay(hpL2I(nLine), .1, TRIM(cFrAdd1))
  IF !EMPTY(cFrAdd2)
    nLine++
    hpIAtSay(hpL2I(nLine), .1, TRIM(cFrAdd2))
  END
  nLine++
  hpIAtSay(hpL2I(nLine), .1, TRIM(cFrCity)+", "+TRIM(cFrState)+"  "+TRIM(cFrZip))

  // Print mailing address
  nLine := 12   // appx 2"
  hpIAtSay(hpL2I(nLine), 4.5, TRIM(cToName))
  nLine++
  hpIAtSay(hpL2I(nLine), 4.5, TRIM(cToAdd1))
  IF !EMPTY(cToAdd2)
    nLine++
    hpIAtSay(hpL2I(nLine), 4.5, TRIM(cToAdd2))
  END
  nLine++
  hpIAtSay(hpL2I(nLine), 4.5, TRIM(cToCity)+", "+TRIM(cToState)+"  "+TRIM(cToZip))

  hpReset()
  hpPrintOff()

  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100, 1)
  TONE(500, 1)
  TONE(1000, 1)
  INKEY(1)

RETURN

