**************************************************************************
*                                                                        *
*  WRAP.PRG                                                              *
*                                                                        *
*  Word wrapping (fully justified) example.                              *
*                                                                        *
**************************************************************************
#include "samples.ch"

#define aTriangle { "          *", ;
                    "         ***", ;
                    "         ***", ;
                    "        *****", ;
                    "        *****", ;
                    "       *******", ;
                    "       *******", ;
                    "      *********", ;
                    "      *********", ;
                    "     ***********", ;
                    "     ***********", ;
                    "    *************", ;
                    "    *************", ;
                    "   ***************", ;
                    "   ***************", ;
                    "  *****************", ;
                    "  *****************", ;
                    " *******************", ; 
                    " *******************", ; 
                    "*********************", ;        
                    "*********************" }        


PROCEDURE Wrap()

  LOCAL Text[20]
  LOCAL nTotLines, nLines, nTextLine := 0
  LOCAL nLine        := 1.2
  LOCAL nLineSpacing := 1/6  && 6 lines per inch
  LOCAL nColWidth    := 3.3
  LOCAL nLeftCol     := .3
  LOCAL nRightCol    := 4.4

  Text[1]:=  "Unleash the power of your Hewlett Packard LaserJet printer - and produce terrific "
  Text[1]+=  "output from your Clipper applications - with " + hpBold("Escape!") + " ver. 3.0, Pinnacle Publishing's "
  Text[1]+=  "laser printer library."

  Text[2]:=  hpUnderLn("DATABASE PUBLISHING")

  Text[3]:=  hpBold("Escape!") + " allows the Clipper developer to program HP LaserJet series printers using "
  Text[3]+=  "commands embedded within Clipper source code.  " + hpBold("Escape!") + "'s command format greatly simplifies "
  Text[3]+=  'printer programming, allowing the user to create high-quality "database published '
  Text[3]+=  "documents in a fraction of the time.  A single line of " + hpBold("Escape!") + " code inserted into your "
  Text[3]+=  "Clipper application will dramatically improve the quality and impact of your printed "
  Text[3]+=  "output."

  Text[4]:=  hpUnderLn("FULL FONT SUPPORT")

  Text[5]:=  "A single " + hpBold("Escape!") + " function is all you need to select any internal, cartridge, or soft font.  "
  Text[5]+=  hpBold("Escape!") + " provides a full range of font control capabilities including -- full support for "
  Text[5]+=  "all manufacturers' soft fonts; boldface, underlining, and super- and subscripts available "
  Text[5]+=  "for every font (even when justifying text); symbol set selection and scalable typeface selection for internal scalable "
  Text[5]+=  "fonts.  With " + hpBold("Escape!") + "'s download function, you can turn a standard font into a reversed, "
  Text[5]+=  "underlined or shadowed font; you can perform partial downloads; or convert a portrait font "
  Text[5]+=  "into a landscape font."

  Text[6]:=  hpUnderLn("NO-HASTLE TEXT PRINTING")

  Text[7]:=  hpBold("Escape!") + " lets you print anywhere on a page, in any order, without worrying about page ejects.  A variety of "
  Text[7]+=  "functions handle -- text positioning (using row/columns, inches, or millimeters; margin and line spacing, "
  Text[7]+=  "centering, and right-justification of any text.  It even supports print positioning in row or "
  Text[7]+=  "column fractions (e.g., 1.5 lines down the page).  And now, with " + hpBold("Escape!") + ", you can wrap or fully "
  Text[7]+=  "justify your text, including proportionally-spaced text."

  Text[8]:=  hpUnderLn("DRAW LINES AND BOXES EASILY")

  Text[9]:=  hpBold("Escape!") + " enables you to draw ruled lines and boxes easily and quickly, using simple commands -- You can draw "
  Text[9]+=  "black lines and rules of any thickness; draw boxes with a variety of borders; fill boxes with any of six "
  Text[9]+=  "patterns or eight shades of gray; highlight individual rows and columns with patterns or gray shades."

  ****
  * We will now make the text for the right column one long text string 
  * in order to demonstrate the different ways wrapping can be achieved.
  ****
  Text[10]:=  hpUnderLn("GRAPHICS") + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  "Besides lines and boxes, your printed output can be greatly enhanced with " + hpBold("Escape!") + "'s other graphics printing "
  Text[10]+=  "capabilities -- draw circles, print monochrome or color PCX files and even create and print your own raster "
  Text[10]+=  "images." + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  hpUnderLn("PRINTER CONTROL") + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  "With " + hpBold("Escape!") + ", you can control mechanical printer operation from within your Clipper applications.  Functions "
  Text[10]+=  "handle -- print orientation; number of copies; tray, manual, or envelope, or power envelope feed; duplex "
  Text[10]+=  "printing and paper size selection."+ CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  hpUnderLn("MACRO CAPABILITIES") + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  hpBold("Escape!") + " lets you define macros to group often-used commands into a single function call.  Macros can be "
  Text[10]+=  "executed wherever needed.  You can also create overlays, to automatically overlay the same information "
  Text[10]+=  "on each printed page, such as a logo.  The addition of overlays to your print routines can dramatically "
  Text[10]+=  "reduce printing time." + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  hpUnderLn("HPPCL LEVEL 5 SUPPORT") + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  "With support for HP's HPPCL 5 printer control language, you can achieve outstanding results without "
  Text[10]+=  "purchasing a single font -- use " + hpBold("Escape!") + " to select the printer's internal scalable fonts, create reversed "
  Text[10]+=  "(white on black) and shadowed fonts, and print portrait and landscape type on the same page." + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+=  hpUnderLn("MONEY-BACK GUARANTEE") + CHR(13)+CHR(10)  + CHR(13)+CHR(10)
  Text[10]+= "If you purchase " + hpbold("Escape!") + " and decide that it's not the most powerful laser printing tool you've ever seen, "
  Text[10]+= "you can return it to the place of purchase within 30 days for a full refund.  Guaranteed." + CHR(13)+CHR(10) + CHR(13)+CHR(10)
  Text[10]+= hpBold("Escape!") + " retails for $149.00.  For further details, contact Pinnacle Publishing at (800) 788-1900 or (206) 251-1900."

  ****
  * Display screen title
  ****
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape! Ver 3.0 - Word Wrapping Example'

  ****
  * Display screen message
  ****
  ShowBox('Downloading Fonts...')

  ****
  * BEGIN PRINTING PAGE USING ESCAPE!
  ****
  HpPrintOn()

  hpDownload("OPT10.POR", 1, "LPT1",, DOWNLOADCHARS)
  hpDownload("CEN10.POR", 2, "LPT1",, DOWNLOADCHARS)

  hpPrintOff()
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Printing word wrapping example...','n/w','w+/w')
  hpPrintOn()

  HpConfig()

  ****
  * Print page heading and PCX file
  ****
  hpSetFont('CEN10.POR', 'SF')
  hpIAtSay(.5, 1.5, 'the Laser Printer Library')
  hpPCX(.3, .34, 'ESCAPE.PCX', 'I', 300, .F., 50)

  * Print Pinnacle Address at the bottom of the page
  hpIAtSay(10, 2, "Pinnacle Publishing, Inc.")
  hpIAtSay(10, 3.75, "P.O. Box 1088     Kent, WA  98035-1088")
  hpRaster( aTriangle, 9.93125, 3.6, 300, 'I' )
  hpRaster( aTriangle, 9.93125, 4.65, 300, 'I' )

  * top line
  hpIBox(.65, .2, .65, 7.75, 7)

  * middle line
  hpIBox(1.85, 4, 9.3, 4, 4 )

  HpSetFont('OPT10.POR','SF')

  * Column #1 
  nLine     := 1.2
  nTotLines := HpJust(Text[1],nLine,nLeftCol,7.4,1,"I")

  nLine     := 1.85
  nTotLines := HpJust(Text[2],nLine,nLeftCol,nColWidth,1,"I")
  nLine     := nLine+HpL2I(nTotLines)+nLineSpacing
  nTotLines := HpJust(Text[3],nLine,nLeftCol,nColWidth,1,"I")
  nLine     := nLine+HpL2I(nTotLines)+nLineSpacing
  nTotLines := HpJust(Text[4],nLine,nLeftCol,nColWidth,1,"I")
  nLine     := nLine+HpL2I(nTotLines)+nLineSpacing
  nTotLines := HpJust(Text[5],nLine,nLeftCol,nColWidth,1,"I")
  nLine     := nLine+HpL2I(nTotLines)+nLineSpacing
  nTotLines := HpJust(Text[6],nLine,nLeftCol,nColWidth,1,"I")
  nLine     := nLine+HpL2I(nTotLines)+nLineSpacing
  nTotLines := HpJust(Text[7],nLine,nLeftCol,nColWidth,1,"I")
  nLine     := nLine+HpL2I(nTotLines)+nLineSpacing
  nTotLines := HpJust(Text[8],nLine,nLeftCol,nColWidth,1,"I")
  nLine     := nLine+HpL2I(nTotLines)+nLineSpacing
  nTotLines := HpJust(Text[9],nLine,nLeftCol,nColWidth,1,"I")

  * Column #2 
  ****
  * As an example to show the different ways wrapping can be done, we will
  * print Column #2 using line extraction as you would with Clipper's
  * MLCOUNT() and MEMOLINE() functions.  In this case we use hpJustCount()
  * and hpJustLine() because we want to fully justify proportional text.
  ****
  nLine     := 1.85
  nLines    := hpJustCount(Text[10], nColWidth, 'I')

  FOR nTextLine := 1 to nLines
    hpIAtSay( nLine, nRightCol, hpJustLine(Text[10], 3.3, nTextLine, "I"))
    nLine := nLine + 1/6
  NEXT

  HpClrFonts()

  HpReset()
  HpPrintOff()

  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100, 1)
  TONE(500, 1)
  TONE(1000, 1)
  INKEY(1)

RETURN

