**************************************************************************
*                                                                        *
*  SAMPLE.PRG                                                            *
*                                                                        *
*  Prints out a sample printout of Escape features.                      *
*                                                                        *
**************************************************************************
#include "samples.ch"

PROCEDURE Sample()

LOCAL aArrow := { ;
  "                *", ;
  "                **", ;
  "                ***", ;
  "                ****", ;
  "                *****", ;
  "                ******", ;
  "                *******", ;
  "************************", ;
  "*************************", ;
  "**************************", ;
  "***************************", ;
  "****************************", ;
  "***************************", ;
  "**************************", ;
  "*************************", ;
  "************************", ;
  "                *******", ;
  "                ******", ;
  "                *****", ;
  "                ****", ;
  "                ***",;
  "                **",;
  "                *" }


LOCAL aCircle := { ;
  "               *******", ;
  "             ***********", ;
  "           ***************", ;
  "          *****************", ;
  "         *******************", ;
  "        *********************", ;
  "       ***********************", ;
  "       ***********************", ;
  "       ***********************", ;
  "      *************************", ;
  "      *************************", ;
  "      *************************", ;
  "      *************************", ;
  "      *************************", ;
  "      *************************", ;
  "      *************************", ;
  "       ***********************", ;
  "       ***********************", ;
  "       ***********************", ;
  "        *********************", ;
  "         *******************", ;
  "          *****************", ;
  "           ***************", ;
  "             ***********", ;
  "               *******" }

LOCAL aLeftFoot := { ;
  "                       *****  ", ;
  "                      ******* ", ;
  "                      ******* ", ;
  "                      ********", ;
  "                ****  ******* ", ;
  "               *****  ******* ", ;
  "               ****** ******* ", ;
  "           *** ****** ******* ", ;
  "          ***** ***** ******* ", ;
  "          ***** ****   *****  ", ;
  "          *****  **     ***   ", ;
  "      *** *****               ", ;
  "    *****  ***                ", ;
  "    *****          ******     ", ;
  "    *****      ************   ", ;
  "     ****    ***************  ", ;
  " ***  *    ****************** ", ;
  "****      ******************* ", ;
  "****    ********************* ", ;
  "****   ********************** ", ;
  " **   *********************** ", ;
  "     ************************ ", ;
  "    ************************  ", ;
  "    ************************  ", ;
  "   *************************  ", ;
  "   ************************   ", ;
  "  ************************    ", ;
  "  ***********************     ", ;
  "  **********************      ", ;
  "  *********************       ", ;
  "  *******************         ", ;
  "  *****************           ", ;
  "  ****************            ", ;
  "  ***************             ", ;
  "  ***************             ", ;
  "  ***************             ", ;
  "  **************              ", ;
  "   *************              ", ;
  "   *************              ", ;
  "   *************              ", ;
  "   *************              ", ;
  "   *************              ", ;
  "    ************              ", ;
  "    ************              ", ;
  "    ************              ", ;
  "    ************              ", ;
  "    *************             ", ;
  "     ************             ", ;
  "     *************            ", ;
  "     *************            ", ;
  "     **************           ", ;
  "      **************          ", ;
  "      ***************         ", ;
  "      ****************        ", ;
  "      ******************      ", ;
  "      ********************    ", ;
  "       ********************   ", ;
  "       *********************  ", ;
  "       *********************  ", ;
  "       ********************** ", ;
  "        ********************* ", ;
  "        ********************* ", ;
  "        ********************* ", ;
  "         ******************** ", ;
  "         ******************** ", ;
  "         ******************** ", ;
  "          ******************* ", ;
  "          ******************  ", ;
  "           *****************  ", ;
  "            ***************   ", ;
  "            **************    ", ;
  "              ***********     ", ;
  "               ********       " }

LOCAL aLeftShoe := { ;
  "                ****", ;
  "             *********", ;
  "            ************", ;
  "          ***************", ;
  "         ****************", ;
  "        ******************", ;
  "       ********************", ;
  "      *********************", ;
  "      **********************", ;
  "     ***********************", ;
  "    *************************", ;
  "    *************************", ;
  "   **************************", ;
  "   **************************", ;
  "  ****************************", ;
  "  ****************************", ;
  " *****************************", ;
  " *****************************", ;
  "******************************", ;
  "*******************************", ;
  "*******************************", ;
  "*******************************", ;
  "*******************************", ;
  "*******************************", ;
  "*******************************", ;
  "*******************************", ;
  "*******************************", ;
  "******************************", ;
  "******************************", ;
  "******************************", ;
  "******************************", ;
  " ****************************", ;
  " ****************************", ;
  "  ***************************", ;
  "    ************************", ;
  "      ********************", ;
  "         **************", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "", ;
  "   ***********************", ;
  "   ***********************", ;
  "   ***********************", ;
  "   ***********************", ;
  "   ***********************", ;
  "   ***********************", ;
  "    *********************", ;
  "    *********************", ;
  "    *********************", ;
  "     ********************", ;
  "     ********************", ;
  "     *******************", ;
  "      ******************", ;
  "      *****************", ;
  "       ****************", ;
  "        **************", ;
  "         ************", ;
  "          **********", ;
  "             ****" }

LOCAL aStar := { ;
  "                            *" , ;
  "                            *" , ;
  "                            *" , ;
  "                           ***" , ;
  "                           ***" , ;
  "                           ***" , ;
  "                          *****" , ;
  "                          *****" , ;
  "                          *****" , ;
  "                         *******" , ;
  "                         *******" , ;
  "                         *******" , ;
  "                        *********" , ;
  "                        *********" , ;
  "                        *********" , ;
  "                       ***********" , ;
  "                       ***********" , ;
  "                       ***********" , ;
  "     ***********************************************" , ;
  "      *********************************************" , ;
  "        *****************************************" , ;
  "         ***************************************" , ;
  "           ***********************************" , ;
  "            *********************************" , ;
  "             *******************************" , ;
  "               ***************************" , ;
  "                *************************" , ;
  "                 ***********************" , ;
  "                   *******************" , ;
  "                    *****************" , ;
  "                   *******************" , ;
  "                   ********************" , ;
  "                  *********************" , ;
  "                  *********************" , ;
  "                  **********************" , ;
  "                 *********** ***********" , ;
  "                 **********   **********" , ;
  "                 *********     **********" , ;
  "                *********       *********" , ;
  "                *******           *******" , ;
  "                ******             *******" , ;
  "               ******                *****" , ;
  "               ****                   ****", ;
  "               ***                     ****", ;
  "              ***                        **", ;
  "              *                           *", ;
  "              *                            *" }

LOCAL aCheck := { ;
  "                       *********", ;
  "                      *********", ;
  "                      ********", ;
  "                     ********", ;
  "                     ********", ;
  "                     *******", ;
  "                    ********", ;
  "                    ********", ;
  "                    *******", ;
  "                   *******", ;
  "                   *******", ;
  "                   *******", ;
  "                  *******", ;
  "                  *******", ;
  "                  *******", ;
  "                  *******", ;
  "                 *******", ;
  "                 *******", ;
  "                 ******", ;
  "                 ******", ;
  "  **********    *******", ;
  "    *********   ******", ;
  "      ********  ******", ;
  "        ******* ******", ;
  "         *************", ;
  "          ***********", ;
  "           **********", ;
  "            *********", ;
  "             ********",;
  "              *******",;
  "               ******",;
  "                ****" }

LOCAL aPencil := { ;
  "                                         **************", ;
  "                                        ****************", ;
  "                                       **             ***", ;
  "                                      ***              ***", ;
  "                                     ****               ***", ;
  "                                    ** **                ***", ;
  "                                   **  **                 ***", ;
  "                                  **   **       ***        ***", ;
  "                                 **    **      ******       ***", ;
  "                                **     **      *******       **", ;
  "                               **      **      ********      **", ;
  "                              **       **      *********     **", ;
  "                             **        **       ********     **", ;
  "                            **         ***       *******     **", ;
  "                           **          ****       ******     **", ;
  "                          **          ** ***       *****     **", ;
  "                         **          **   ***                **", ;
  "                        **          **     ***               **", ;
  "                       **          **       ***              **", ;
  "                      **          **         ***             **", ;
  "                     **          **           ***            **", ;
  "                    **          **             ***           **", ;
  "                   **          **               ***************", ;
  "                  **          **                **************", ;
  "                 **          **                **          **", ;
  "                **          **                **          **", ;
  "               **          **                **          **", ;
  "              **          **                **          **", ;
  "             **          **                **          **", ;
  "            **          **                **          **", ;
  "           **          **                **          **", ;
  "          **          **                **          **", ;
  "         **          **                **          **", ;
  "        **          **                **          **", ;
  "       ***         **                **          **", ;
  "       ***        **                **          **", ;
  "      *****      **                **          **", ;
  "      ** **     **                **          **", ;
  "      ** ***   **                **          **", ;
  "      **  **  **                **          **", ;
  "     ***  *****                **          **", ;
  "     **    ***                **          **", ;
  "     **    ***               **          **", ;
  "     **     ***             **          **", ;
  "    ***      **            **          **", ;
  "    **       ***          **          **", ;
  "    **        ***        **          **", ;
  "    **         ***      **          **", ;
  "   ***          ***    **          **", ;
  "   **            **** **          **", ;
  "   **             *****          **", ;
  "   **               *****       **", ;
  "  **                  *****    **", ;
  "  **                    ********", ;
  "  **                      *****", ;
  "  **                    ******", ;
  " ****               ******", ;
  " *****           *****", ;
  " ******       ****", ;
  "***************",;
  "************",;
  "********",;
  "*****" }

  LOCAL nIncr := .3   // Row incrementer

  // Display screen title
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape! ver 3.0 - Sample Printout'

  // Display screen message
  ShowBox({'Printing Sample Printouts...','Please be patient, downloading many soft fonts.'})

  *************************************************************************
  * BEGIN PRINTING SAMPLE USING ESCAPE                                    *
  *************************************************************************

  hpPrintOn()
  hpConfig('LETTER','P')
  hpSetFont('COURIER 10','I')

  // Draw outer box
  hpIBox(0, 0, 9.75, 7.75)
  // hpIBoxShadow() is a UDF which can be found in EXAMPLES.PRG
  hpIBoxShadow(0, 0, 9.75, 7.75, .125, 20)

  // Draw title box
  // Download using gray drop-shadow dropped 5 dots
  // Only download characters needed
  hpDownload( "GAR18.POR", 1, "PRN", "G5", "ESCAPEver.30-PintSampl " )
  hpSetFont( "GAR18.POR", "SF",,, 1 )
  hpCenter( "ESCAPE! ver. 3.0 - Print Sample", 4)

  hpSetFont('COURIER 10','I')
  hpBox(2, 20, 5.5, 58, 1)

  // hpBoxShadow() is a UDF which can be found in EXAMPLES.PRG
  hpBoxShadow(2.5, 20, 5.5, 58, .12, 20)

  // Draw raster images!!!
  hpAtSay(9, 6, hpBold('Raster Images:') + " (includes Rotation and Flips)" )
  hpRaster( aArrow, 11, 10, 300, "R" )
  hpCenter('Arrow',14, 11)
  hpCenter('300',15, 11)
  hpRaster( aArrow, 11, 18, 150, "R" )
  hpCenter('Arrow',14, 19)
  hpCenter('150',15, 19)
  hpRaster( aArrow, 11, 26, 100, "R" )
  hpCenter('Arrow',14, 27)
  hpCenter('100',15, 27)
  hpRaster( aArrow, 11, 34, 75, "R" )
  hpCenter('Arrow',14, 35)
  hpCenter('75',15, 35)

  hpRaster( aLeftFoot, 11, 42, 300, "R" )
  hpCenter('Left',14, 43)
  hpCenter('Foot',15, 43)
  // Use Left foot but flip along vertical axis to make a right shoe
  hpRaster( aLeftFoot, 11, 50, 300, "R", "V" )
  hpCenter('Right',14, 51)
  hpCenter('Foot',15, 51)

  hpRaster( aLeftShoe, 11, 58, 300, "R" )
  hpCenter('Left',14, 59)
  hpCenter('Shoe',15, 59)
  // Use Left shoe but flip along vertical axis to make a right shoe
  hpRaster( aLeftShoe, 11, 66, 300, "R", "V" )
  hpCenter('Right',14, 67)
  hpCenter('Shoe',15, 67)

  // Rotate raster to point down by rotating it right 90 degrees!
  hpRaster( aArrow, 18, 10, 300, "R", "R" )
  hpCenter('Arrow',21, 11)
  hpCenter('Down!',22, 11)

  hpRaster( aStar, 18, 18, 300, "R" )
  hpCenter('Star',21, 19)

  hpRaster( aCheck, 18, 26, 300, "R" )
  hpCenter('Check', 21, 27)

  hpRaster( aCircle, 18, 34, 300, "R" )
  hpCenter('Bullet', 21, 35)

  hpRaster( aPencil, 18, 42, 300, "R" )
  hpCenter('Pencil', 21, 43)

  // Some lines
  hpAtSay( 18, 49, hpBold("Line/Box types:") )
  hpBox( 19, 49, 19, 59, 1 )   // Normal single line
  hpBox( 20, 49, 20, 59, 2 )   // Double line
  hpBox( 21, 49, 21, 59, 3 )   // Dotted line
  hpBox( 22, 49, 22, 59, 4 )   // Hairline
  hpBox( 23, 49, 23, 59, 5 )   // 1/2 pt
  hpBox( 24, 49, 24, 59, 6 )   // 1 pt

  hpBox( 19, 61, 19, 71, 7 )   // 2 pt
  hpBox( 20, 61, 20, 71, 8 )   // 3 pt
  hpBox( 21, 61, 21, 71, 9 )   // 4 pt
  hpBox( 22, 61, 22, 71, 10 )  // 6 pt
  hpBox( 23, 61, 23, 71, 11 )  // 8 pt

  // Draw Shaded Circles
  hpAtSay(24.5, 6, hpBold('Shaded Circles:'))
  hpCircle( 27, 10, 2, 1, 1, 0, "R" )
  hpCenter('1-2%',30, 10.5)
  hpCircle( 27, 18, 2, 2, 10, 0, "R" )
  hpCenter('3-10%',30, 18.5)
  hpCircle( 27, 26, 2, 3, 20, 0, "R" )
  hpCenter('11-20%',30, 26.5)
  hpCircle( 27, 34, 2, 4, 30, 0, "R" )
  hpCenter('21-35%',30, 34.5)
  hpCircle( 27, 42, 2, 5, 50, 0, "R" )
  hpCenter('36-55%',30, 42.5)
  hpCircle( 27, 50, 2, 6, 75, 0, "R" )
  hpCenter('56-80%',30, 50.5)
  hpCircle( 27, 58, 2, 7, 90, 0, "R" )
  hpCenter('81-99%',30, 58.5)
  hpCircle( 27, 66, 2, 8, 100, 0, "R" )
  hpCenter('100%',30, 66.5)

  // Draw Patterned Circles
  hpAtSay(31.5, 6, hpBold('Patterned Circles:'))
  hpCircle( 34, 10, 2, 1, 0, 1, "R" )
  hpCenter('#1',37, 10.5)
  hpCircle( 34, 18, 2, 1, 0, 2, "R" )
  hpCenter('#2',37, 18.5)
  hpCircle( 34, 26, 2, 1, 0, 3, "R" )
  hpCenter('#3',37, 26.5)
  hpCircle( 34, 34, 2, 1, 0, 4, "R" )
  hpCenter('#4',37, 34.5)
  hpCircle( 34, 42, 2, 1, 0, 5, "R" )
  hpCenter('#5',37, 42.5)
  hpCircle( 34, 50, 2, 1, 0, 6, "R" )
  hpCenter('#6',37, 50.5)

  // Draw circles with no borders
  hpAtSay(31.5, 55, 'No Borders:')
  hpCircle( 34, 58, 2, 0, 50, 0, "R" )
  hpCenter('Shade',37, 58.5)
  hpCircle( 34, 66, 2, 0, 0, 5, "R" )
  hpCenter('Patt', 37, 66.5)

  // Draw Gray Shaded Boxes
  hpAtSay( 39.5, 6, hpBold('Gray Shades:') )
  hpGrayBox(41, 6, 43, 14, 1, 1)
  hpCenter('1-2%',44, 10.5)
  hpGrayBox(41, 14, 43, 22, 1, 5)
  hpCenter('3-10%',44, 18.5)
  hpGrayBox(41, 22, 43, 30, 1, 15)
  hpCenter('11-20%',44, 26.5)
  hpGrayBox(41, 30, 43, 38, 1, 25)
  hpCenter('21-35%',44, 34.5)
  hpGrayBox(41, 38, 43, 46, 1, 50)
  hpCenter('36-55%',44, 42.5)
  hpGrayBox(41, 46, 43, 54, 1, 70)
  hpCenter('56-80%',44, 50.5)
  hpGrayBox(41, 54, 43, 62, 1, 85)
  hpCenter('81-99%',44, 58.5)
  hpGrayBox(41, 62, 43, 70, 1, 100)
  hpCenter('100%',44, 66.5)

  // Draw Patterned Boxes
  hpAtSay(45.5, 6, hpbold('Patterns:') )
  hpPattBox(47, 6, 49, 14, 1, 1)
  hpCenter('#1',50, 10.5)
  hpPattBox(47, 14, 49, 22, 1, 2)
  hpCenter('#2',50, 18.5)
  hpPattBox(47, 22, 49, 30, 1, 3)
  hpCenter('#3',50, 26.5)
  hpPattBox(47, 30, 49, 38, 1, 4)
  hpCenter('#4',50, 34.5)
  hpPattBox(47, 38, 49, 46, 1, 5)
  hpCenter('#5',50, 42.5)
  hpPattBox(47, 46, 49, 54, 1, 6)
  hpCenter('#6',50, 50.5)

  // Print PCX file
  hpAtSay( 45.5, 58, hpBold('PCX Files:') )
  hpPcx( 47.5, 58, "LOGO.PCX", 'R', 300, .F. )

  // Finally wrap text at the bottom of the page
  hpSetFont('LINEPRT 16', 'I')
  hpJust( "The examples above are just a few of the many new capabilities of " + hpBold("Escape!") + " ver 3.0.  " +  ;
          "Please refer to the documentation for information on other exciting new features " + ;
          "including HPPCL 5 support.", 52, 10, 50 )

  hpAtSay( 53, 63, "(    Fully Justified!)" )
  hpRaster( aArrow, 52.5, 65, 300, "R", "U" )

  // Print second page
  eject
  hpSetFont('COURIER 10','I')

  // Draw outer box
  hpIBox(0, 0, 9.75, 7.75)
  // hpIBoxShadow() is a UDF which can be found in EXAMPLES.PRG
  hpIBoxShadow(0, 0, 9.75, 7.75, .125, 20)

  // Draw title box
  hpSetFont('COURIER 10','I')
  hpBox(2, 20, 5.5, 58, 1)
  // hpBoxShadow() is a UDF which can be found in EXAMPLES.PRG
  hpBoxShadow(2.5, 20, 5.5, 58, .12, 20)

  hpWrap("The following are just some of the special effects which can " + ;
         "be achieved with Escape's soft font download function:", 10, 15, 50)

  hpDownload( "GAR18.POR", 1, "PRN", "G5", "Downlad EfectsGryShF" )
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpCenter( 'Download Effects', 4)

  hpIAtSay( 2.6, 2, "Gray Shadowed Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "O2", "Outlined SofF" )
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+nIncr, 2, "Outlined Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "O2,D5", "Outlined aShowfF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+2*nIncr, 2, "Outlined and Shadowed Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P2", "Patern 2SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+3*nIncr, 2, "Pattern 2 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P3", "Patern 3SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+4*nIncr, 2, "Pattern 3 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P4", "Patern 4SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+5*nIncr, 2, "Pattern 4 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P5", "Patern 5SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+6*nIncr, 2, "Pattern 5 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P7", "Patern 7SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+7*nIncr, 2, "Pattern 7 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P8", "Patern 8SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+8*nIncr, 2, "Pattern 8 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P9", "Patern 9SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+9*nIncr, 2, "Pattern 9 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P10", "Patern 10SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+10*nIncr, 2, "Pattern 10 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P11", "Patern 1SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+11*nIncr, 2, "Pattern 11 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P12", "Patern 12SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+12*nIncr, 2, "Pattern 12 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "P13", "Patern 13SofF")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+13*nIncr, 2, "Pattern 13 Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "B8", "Bolded SftFn")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.6+14*nIncr, 2, "Bolded Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "S2", "2x ScaledoftFn")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.7+15*nIncr, 2, "2x Scaled Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "X2", "2x ScaledWioftFn")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.7+16*nIncr, 2, "2x Scaled Wide Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "Y2", "2x ScaledHighoftFn")
  hpSetFont( "GAR18.POR", "SF",,,1)
  hpIAtSay( 2.8+17*nIncr, 2, "2x Scaled High Soft Font")

  hpDownload( "GAR18.POR", 1, "PRN", "R", "Even CratRsdFo")
  hpSetFont( "GAR18.POR", "SF",,, 1 )
  hpIAtSay( 2.8+18*nIncr, 2, "Even Create Reversed Fonts")

  hpClrFonts()
  hpReset()
  hpprintoff()

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  INKEY(1)

RETURN

