**************************************************************************
*                                                                        *
*  OVERLAY.PRG                                                           *
*                                                                        *
*  Invoice sample to show how overlays and macros work.                  *
*                                                                        *
**************************************************************************
#include "samples.ch"

PROCEDURE Overlay()

  * Data to fill invoice with
  MEMVAR cBillName, cBillComp, cBillAddr, cBillCity, cBillSt, cBillZip,;
         cShipName, cShipComp, cShipAddr, cShipCity, cShipSt, cShipZip

  PRIVATE cBillName := SPACE(40)
  PRIVATE cBillComp := SPACE(40)
  PRIVATE cBillAddr := SPACE(40)
  PRIVATE cBillCity := SPACE(24)
  PRIVATE cBillSt   := SPACE(2)
  PRIVATE cBillZip  := SPACE(5)

  PRIVATE cShipName := SPACE(40)
  PRIVATE cShipComp := SPACE(40)
  PRIVATE cShipAddr := SPACE(40)
  PRIVATE cShipCity := SPACE(24)
  PRIVATE cShipSt   := SPACE(2)
  PRIVATE cShipZip  := SPACE(5)

  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  SETCOLOR('w+/bg')
  @ 0, 0, 2, 79 BOX 'Ŀ '
  @ 1, 2 SAY 'Escape! ver 3.0 - Invoice Sample to Demonstrate Overlays & Macros'

  ****
  * Get information to fill invoice with from the user.
  ****
  IF ! GetNames()
    RETURN
  ENDIF

  ****
  * Now, begin printing invoices using Escape.
  ****

  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  ShowBox('Downloading Fonts...')

  hpPrintOn()

  ****
  * Since we're downloading a lot of fonts, let's clear any fonts or macros
  * which may be in the printer, to avoid any memory problems.
  ****
  hpClrMacros()
  hpClrFonts()

  ****
  * Download fonts
  * (specify only the characters needed to speed up downloading)
  ****
  hpDownload("GAR24.POR",  1,"LPT1",, "INVOICE")
  hpDownload("GAR12I.POR", 2,"LPT1",, "Thank You")
  hpDownload("CEN12B.POR", 3,"LPT1",, "BilTo Shp:1234567890#" )
  hpDownload("OPT10B.POR", 5,"LPT1",, "Ofice PakngSlCustomrpy" )
  hpDownload("CEN10B.POR", 4,"LPT1",, DOWNLOADCHARS)

  hpPrintOff()
  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  ShowBox('Printing Overlay Samples...')
  hpPrintOn()

  ****
  * Set up printer, using default parameter settings
  ****
  hpConfig()

  ****
  * Define Invoice Overlay Macro
  ****
  DefOverlay()

  ****
  * Select overlay #1, which was just defined, to be overlayed on each page.
  ****
  hpOverlay(1)  

  ****
  * Now print three copies of the invoice, without having to redraw the
  * main portion of the invoice, including the PCX images. (Much faster!)
  ****
  PrintInv('Office Copy')
  PrintInv('Customer Copy')
  PrintInv('Packing Slip')

  hpReset()
  hpOveroff()
  hpClrMacros()
  hpClrFonts()
  hpPrintOff()

  SETCOLOR('w/b')
  @ 3, 0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100, 1)
  TONE(500, 1)
  TONE(1000, 1)
  INKEY(1)

RETURN

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
****
* DEFOVERLAY : Defines invoice overlay macro
****                                       

PROCEDURE DefOverlay()

  ****
  * BEGIN MACRO DEFINITION
  ****
  hpStartMac(1)

  hpPCX(0, .45, 'LOGO.PCX', 'I')
  hpPCX(5.5, 3, 'SAMPLE.PCX', 'I')

  hpSetFont("GAR24.POR","SF")
  hpIRJust(hpBold("INVOICE"),.3,7.8)
  hpIBox(0, 6.25, .04, 7.9)
  hpIGrayBox(.04, 6.25, .625, 7.9, 1, 20)

  hpSetFont("CEN12B.POR","SF")
  hpIRJust("# 12345",.5,7.8)   // Invoice # would normally come from some type of counter database
  hpIAtSay(1.7,.4, "Bill To:")
  hpIAtSay(1.7,4.2,"Ship To:")

  ****
  * Main box
  **** 
  hpIBox(3,0,3.04,7.9)              // top line (double)
  hpIBox(3,0,8,0)                   // left line
  hpIBox(3,7.9,10,7.9)              // right line
  hpIBox(7.96,0,8,5.5)              // first double bottom line
  hpIBox(7.96,5.5,7.96,7.9)         // horizontal line above total info
  hpIBox(7.96,5.5,10,5.5)           // vertical line at bottom middle
  hpIBox(9.96,5.5,10,7.9)           // second double bottom line

  hpIGrayBox(3.04,0,3.34,7.9,1,20)  // top gray box
  hpIGrayBox(3.74,0,4.04,7.9,1,20)  // second gray box

  hpSetFont("GAR12I.POR","SF")
  hpICenter(hpBold("Thank You"),7.7)

  hpSetFont("CEN10B.POR","SF")
  hpIAtSay(3.19,.16, "Invoice Date")
  hpIAtSay(3.19,1.2, "Net Days")
  hpIAtSay(3.19,2.2, "Due Date")
  hpIAtSay(3.19,3.2, "Your #")
  hpIAtSay(3.19,4.3, "Our #")
  hpIAtSay(3.19,5.3, "Ship Via")
  hpIAtSay(3.19,6.7, "F.O.B.")

  hpIAtSay(3.89,.16, "Inventory #")
  hpIAtSay(3.89,1.2, "Description")
  hpIAtSay(3.89,3.15,"Ordered")
  hpIAtSay(3.89,3.9, "Shipped")
  hpIAtSay(3.89,4.7, "Unit Price")
  hpIAtSay(3.89,5.7, "Discount %")
  hpIAtSay(3.89,6.7, "Extended Price")

  ****
  * Top set of vertical lines
  ****       
  hpIBox(3.04,1,3.34,1,1)          // first top vertical solid line
  hpIBox(3.36,2,3.74,2,3)          // second top vertical dotted line
  hpIBox(3.04,2,3.34,2,1)          // second top vertical solid line
  hpIBox(3.04,3,3.34,3,1)          // third solid
  hpIBox(3.36,4.1,3.74,4.1,3)      // fourth dotted
  hpIBox(3.04,4.1,3.34,4.1,1)      // fourth solid
  hpIBox(3.36,5.1,3.74,5.1,3)      // fifth dotted
  hpIBox(3.04,5.1,3.34,5.1,1)      // fifth solid
  hpIBox(3.04,6.5,3.34,6.5,1)      // sixth solid

  ****
  * Bottom set of vertical lines
  ****
  hpIBox(3.36,1,7.96,1,3)          // first vertical dotted line
  hpIBox(3.74,1,4.04,1,1)          // first vertical solid line
  hpIBox(3.36,3,7.96,3,3)          // second vertical dotted line
  hpIBox(3.74,3,4.04,3,1)          // second vertical solid line
  hpIBox(4.04,3.75,7.96,3.75,3)    // third vertical dotted line
  hpIBox(3.74,3.75,4.04,3.75,1)    // third vertical solid line
  hpIBox(4.04,4.5,7.96,4.5,3)      // fourth vertical dotted line
  hpIBox(3.74,4.5,4.04,4.5,1)      // fourth vertical solid line
  hpIBox(4.04,5.5,7.96,5.5,3)      // fifth vertical dotted line
  hpIBox(3.74,5.5,4.04,5.5,1)      // fifth vertical solid line
  hpIBox(3.36,6.5,9.96,6.5,3)      // last vertical dotted line
  hpIBox(3.74,6.5,4.04,6.5,1)      // last vertical solid line

  ****
  * Totals box
  ****
  hpIGrayBox(7.96,5.5,9.96,6.5,1,20)

  hpICenter("Sub-Total",8.25,6.1)
  hpICenter("Tax",8.55,6.1)
  hpICenter("Total",8.85,6.1)
  hpICenter("Net to Pay",9.75,6.1)

  ****
  * END MACRO DEFINITION
  ****                  
  hpEndMacro(1)

RETURN

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
****
* PrintInv : Prints copy of invoice
****

PROCEDURE PrintInv(cInvType)

  hpSetFont("OPT10B.POR","SF")
  hpICenter(cInvType, 10)

  FillInv(cInvType)

  EJECT

RETURN

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
****
* FillInv : Fills invoice with data
**** 

PROCEDURE FillInv(cInvType)

  LOCAL lPacking  := .F.
  LOCAL nLine     := 12

  ****
  * These values (as well as the Bill to and Ship to information) would
  * normally be retreived from some sort of customer/order database.
  ****
  LOCAL nPrice    := 199
  LOCAL nShipping := 6
  LOCAL nQty      := 1
  LOCAL nExtPrice := nPrice*nQty
  LOCAL nSubTotal := nExtPrice+nShipping
  LOCAL nTax      := nExtPrice*.082
  LOCAL nTotal    := nSubTotal+nTax
  LOCAL nNetPay   := nTotal
  LOCAL lCOD      := .F.
  LOCAL nNetDays  := 30
  LOCAL cSerialNo := '543210'
  LOCAL cRemarks  := 'Thank you for your order!'

  MEMVAR cBillName, cBillComp, cBillAddr, cBillCity, cBillSt, cBillZip,;
         cShipName, cShipComp, cShipAddr, cShipCity, cShipSt, cShipZip

  IF cInvType == 'Packing Slip'
    lPacking = .T.
  ENDIF

  hpSetFont("COURIER 10","I")

  * Fill out BILL TO to name, company and address
  IF .NOT. EMPTY(cBillName)
    hpIAtSay(hpL2I(nLine), 1, cBillName)
    nLine++
  ENDIF
  IF .NOT. EMPTY(cBillComp)
    hpIAtSay(hpL2I(nLine), 1, cBillComp)
    nLine++
  ENDIF
  IF .NOT. EMPTY(cBillAddr)
    hpIAtSay(hpL2I(nLine), 1, cBillAddr)
    nLine++
  ENDIF
  hpIAtSay(hpL2I(nLine), 1, TRIM(cBillCity) + ', ' + cBillSt + '  ' + cBillZip)

  * Fill out SHIP TO name, company and address
  nLine := 12
  IF .NOT. EMPTY(cShipName)
    hpIAtSay(hpL2I(nLine), 4.8, cShipName)
    nLine++
  ENDIF
  IF .NOT. EMPTY(cShipComp)
    hpIAtSay(hpL2I(nLine), 4.8, cShipComp)
    nLine++
  ENDIF
  IF .NOT. EMPTY(cShipAddr)
    hpIAtSay(hpL2I(nLine), 4.8, cShipAddr)
    nLine++
  ENDIF
  hpIAtSay(hpL2I(nLine), 4.8, TRIM(cShipCity) + ', ' + cShipSt + '  ' + cShipZip)

  ****
  * Fill out top portion of invoice
  *
  * This information would normally be retreived from some sort of
  * customer/order database.
  ****
  
  * Invoice date
  hpICenter(dtoc(date()),3.54,.55)

  * Net days 
  hpICenter('30', 3.54, 1.5)

  * Due date
  hpICenter(dtoc(date()+30),3.54,2.53)

  * Your #
  hpICenter('12-3456',3.54,3.5)

  * Our #

  * Ship via
  hpICenter('UPS',3.54,5.81)

  * F.O.B.
  hpICenter("shipping pt.",3.54,7.23)

  ****
  * Fill out main section of invoice
  ****                                

  * Inv # and description
  hpIAtSay(4.3,.2,"01-001")
  hpIAtSay(4.3, 1.1, "Escape! ver. 3.0")

  * Ordered
  hpIRJust(LTRIM(STR(nQty)),4.3,3.5)

  * Shipped
  hpIRJust(LTRIM(STR(nQty)),4.3,4.25)

  * Unit price
  hpIDecJust(TRANSFORM(nPrice, '$ 999.99'),4.3,5.25)
  * hpIDecJust() is a UDF which can be found in examples.prg

  * Extended price
  hpIRJust(TRANSFORM(nExtPrice, '$9,999.99'),4.3,7.7)

  * Shipping info
  hpIAtSay(4.6,1.1,"Shipping/Handling")
  hpIDecJust(TRANSFORM(nShipping, '999.99'),4.6,5.25)
  * hpIDecJust() is a UDF which can be found in examples.prg
  hpIRJust(TRANSFORM(nShipping, '999.99'),4.6,7.7)

  * Print totals
  hpIRJust(TRANSFORM(nSubTotal, '$9,999.99'),8.25,7.7)

  hpIRJust(TRANSFORM(nTax, '99.99'),8.55,7.7)

  hpIRJust(TRANSFORM(nTotal, '$9,999.99'),8.85,7.7)

  IF lPacking
    hpICenter("--",9.75,7.4)
  ELSE
    hpIRJust(TRANSFORM(nNetPay, '$9,999.99'),9.75,7.7)
  ENDIF

  * Print remarks
  nLine := 50
  hpIAtSay(hpL2I(nLine),.2,"Serial #" + cSerialNo)
  nLine++

  IF .NOT. EMPTY(cRemarks)
    hpIAtSay(hpL2I(nLine),.2,cRemarks)
    nLine++
  ENDIF

  DO CASE
    CASE nNetDays > 0
      hpIAtSay(hpL2I(nLine),.2,"Your terms are net " + ALLTRIM(STR(nNetDays)) +'.')
    CASE lCOD
      hpIAtSay(hpL2I(nLine),.2,"C.O.D.")
  ENDCASE

RETURN

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
****
* GetNames : Get Bill To and Ship To names and addresses from the user.
****

FUNCTION GetNames()

  MEMVAR cBillName, cBillComp, cBillAddr, cBillCity, cBillSt, cBillZip,;
         cShipName, cShipComp, cShipAddr, cShipCity, cShipSt, cShipZip

  MEMVAR GetList

  SETCOLOR('w+/w, w+/br, , , w+/n')
  @ 6, 1, 21, 78 BOX 'Ŀ ' COLOR 'n/w'

  @ 8, 5 SAY 'Bill To:'

  SETCOLOR('n/w')
  @ 9,  7 SAY 'Name'
  @ 10, 7 SAY 'Company'
  @ 11, 7 SAY 'Address'
  @ 12, 7 SAY 'City, State  Zip'

  @ 9,  24 GET cBillName
  @ 10, 24 GET cBillComp
  @ 11, 24 GET cBillAddr
  @ 12, 24 GET cBillCity
  @ 12, 48 SAY "," GET cBillSt PICTURE "@!"
  @ 12, 54 GET cBillZip PICTURE "99999"

  SETCOLOR("w+/w")
  @ 14, 5 SAY 'Ship To:'

  SETCOLOR("n/w")
  @ 15, 7 SAY 'Name'
  @ 16, 7 SAY 'Company'
  @ 17, 7 SAY 'Address'
  @ 18, 7 SAY 'City, State  Zip'

  @ 15, 24 GET cShipName
  @ 16, 24 GET cShipComp
  @ 17, 24 GET cShipAddr
  @ 18, 24 GET cShipCity
  @ 18, 48 SAY "," GET cShipSt PICTURE "@!"
  @ 18, 54 GET cShipZip PICTURE "99999"

  READ               

RETURN(IIF(LASTKEY()==27, .F., .T.))

