 **************************************************************************
*                                                                        *
*  ORDERFRM.PRG                                                          *
*                                                                        *
*  Prints out a sample order form                                        *
*                                                                        *
**************************************************************************
#include "samples.ch"

#define aTriangle { "          *", ;
                    "         ***", ;
                    "         ***", ;
                    "        *****", ;
                    "        *****", ;
                    "       *******", ;
                    "       *******", ;
                    "      *********", ;
                    "      *********", ;
                    "     ***********", ;
                    "     ***********", ;
                    "    *************", ;
                    "    *************", ;
                    "   ***************", ;
                    "   ***************", ;
                    "  *****************", ;
                    "  *****************", ;
                    " *******************", ; 
                    " *******************", ; 
                    "*********************", ;        
                    "*********************" }        

#define aCheck  { "                       *********", ;
                  "                      *********", ;
                  "                      ********", ;
                  "                     ********", ;
                  "                     ********", ;
                  "                     *******", ;
                  "                    ********", ;
                  "                    ********", ;
                  "                    *******", ;
                  "                   *******", ;
                  "                   *******", ;
                  "                  *******", ;
                  "                  *******", ;
                  "                  *******", ;
                  "                  *******", ;
                  "                 *******", ;
                  "                 *******", ;
                  "                 ******", ;
                  "                 ******", ;
                  "  **********    *******", ;
                  "    *********   ******", ;
                  "      ********  ******", ;
                  "        ******* ******", ;
                  "         *************", ;
                  "          ***********", ;
                  "           **********", ;
                  "            *********", ;
                  "             ********", ;
                  "              *******", ;
                  "               ******", ;
                  "                ****" }

#define aScissors  { "        *******", ;
                     "     ************", ;
                     "    ***************", ;
                     "   ******     ******", ;
                     "  ****          ****", ;
                     " ****             ****", ;
                     "****              ****", ;
                     "****              ****", ;
                     "****              ****", ;
                     "****              ****", ;
                     "****              ****                                                     *******", ;
                     "****              ****                                                *************", ;
                     " ****             ****                                             *******************", ;
                     "  ****           ****                                           ************************", ;
                     "   ****          ****                                       ***********************", ;
                     "    *****************                                   **********************", ;
                     "      *********************                         **********************", ;
                     "       ***********************                   **********************", ;
                     "            ********************              ********************* ", ;
                     "                           *******          *******************", ;
                     "                             *******    *******************", ;
                     "                              ***************************", ; 
                     "                               **********************", ;
                     "                                *******************", ;
                     "                                *******************", ;
                     "                               **********************", ;
                     "                              ***************************", ; 
                     "                             *******    *******************", ;
                     "                           *******          *******************", ;
                     "            ********************              *********************", ;
                     "       ***********************                   **********************", ;
                     "      *********************                         **********************", ;
                     "    *****************                                   **********************", ;
                     "  *****          ****                                       ***********************", ;
                     " ****             ***                                           ************************", ;
                     " ****             ****                                             *******************", ;
                     "****              ****                                                *************", ;
                     "****              ****                                                     *******", ;
                     "****              ****", ;
                     "****              ****", ;
                     "****              ****", ;
                     " ***              ****", ;
                     " ****             ****", ;
                     "  ****          ****", ;
                     "   ******     ******", ;
                     "    ***************", ;
                     "     ************", ;
                     "        *******" } 

FUNCTION OrderFrm()

  // Row Incrementers
  LOCAL nIncr  := .1875  
  LOCAL nIncr2 := .2        

  ****
  * Display screen title
  ****
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape! Ver 3.0 - Order Form Printout'

  ****
  * Display screen message
  ****
  ShowBox('Downloading Fonts...')
                      
  *************************************************************************
  * BEGIN PRINTING ORDER FORM USING ESCAPE!                               *
  *************************************************************************
  hpPrintOn()

  hpDownload("CEN10.POR", 1, "LPT1", , DOWNLOADCHARS )
  hpDownload("CEN12B.POR", 2, "LPT1", , DOWNLOADCHARS )

  hpPrintOff()
  ShowBox({'Printing Order Form...', 'This is quite complex, so please be patient.'})
  hpPrintOn()

  hpConfig('LETTER','P')
  hpSetFont()

  hpPhysical(.T.)

  // Print Escape! function list
  PrintFuncts()

  // Draw top dotted line
  hpIBox(6.3, 0, 6.3, .4, 3)
  hpIBox(6.3, 1.5, 6.3, 8.5, 3)

  hpRaster( aScissors, 6.18, .5, 300, "I" )

  // Print text which uses LINEPRT 16 font.  (reducing the number of
  // font changes makes printing slightly quicker)
  hpSetFont('LINEPRT 16','I')

  hpIAtSay(6.3, .9, 'Cut here')
  hpIAtSay( 8.2, 1.5, hpBold('PLEASE ENTER YOUR NAME AND ADDRESS BELOW:'))
  hpIAtSay(8.45, .25, hpBold('IMPORTANT:   ') + hpBold('Shipping') + ' addresses only.  We cannot deliver to P.O. boxes.')
  hpIAtSay(7.8, 5.25, 'Your Phone Number')
  hpIAtSay(7.8, 6.80, 'Your Fax Number')
  hpIAtSay(9.8, 1, 'Please fill in below if applicable.')
  hpJust( "Add $6 shipping for U.S. orders; contact Pinnacle for shipping " +  ;
          "costs to other countries.  Washington state residents add 8.2% " + ;
          "sales tax.  Orders are payable in U.S. funds drawn on a U.S. or " + ;
          "Canadian bank.", 9.5, 5.25, 1.7, .7, 'I' )
  hpIAtSay(10.75, 1.25, "All trademarks mentioned belong to their respective holders.")

  // Draw top Gray Bar
  hpGrayBox(6.7, 0, 7.1, 5.6, 4, 15, 'I')
  hpGrayBox(6.7, 8, 7.1, 8.2, 4, 15, 'I')

  // Draw phone number box
  hpIBox(6.5, 5.6, 7.3, 8, 7)

  // Print all text which uses the CEN12.POR font.
  hpSetFont('CEN12B.POR', 'SF')

  hpIAtSay( 6.94, 1, hpBold('ESCAPE! Ver. 3.0 ORDER FORM'))
  hpICenter('800/788-1900', 6.9, 6.8)
  hpIAtSay( 7.6, 5.25, '(     )')
  hpIAtSay( 7.6, 6.80, '(     )')

  // Phone number line
  hpIBox( 7.7, 5.25, 7.7, 8.5, 4)

  // Now print the rest using CEN10.POR
  hpSetFont('CEN10.POR','SF')
  hpICenter('Mail this coupon or call toll-free', 6.7, 6.8)

  hpIAtSay( 7.1, 5.78, '206/251-1900')
  hpRaster( aTriangle, 7.02, 5.78+hpS2I('206/251-1900 '), 300, 'I' )
  hpIAtSay( 7.1, 5.78+hpS2I('206/251-1900')+.2, 'Fax 206/251-5057')

  hpWrap( 'I want to take command of my LaserJet!  Send me ' +;
          hpBold('Escape! 3.0') + ' - the powerful laser printer library for ' + ;
          'CA-Clipper 5 - for the low price of just $199.', ;
          7.5, 1.5, 3.2, 1, "I" )

  hpIAtSay(8.8, .25, hpBold('Name'))
  hpIBox(8.86, 1, 8.86, 4.7, 4)

  hpIAtSay(8.8+nIncr2, .25, hpBold('Company'))
  hpIBox(8.86+nIncr2, 1, 8.86+nIncr2, 4.7, 4)

  hpIAtSay(8.8+2*nIncr2, .25, hpBold('Address'))
  hpIBox(8.86+2*nIncr2, 1, 8.86+2*nIncr2, 4.7, 4)
  hpIBox(8.86+3*nIncr2, 1, 8.86+3*nIncr2, 4.7, 4)

  hpIAtSay(8.8+4*nIncr2, .25, hpBold('City'))
  hpIAtSay(8.8+4*nIncr2, 2.75, hpBold('State'))
  hpIAtSay(8.8+4*nIncr2, 3.75, hpBold('Zip'))
  hpIBox(8.86+4*nIncr2, 1, 8.86+4*nIncr2, 2.65, 4)
  hpIBox(8.86+4*nIncr2, 3.25, 8.86+4*nIncr2, 3.65, 4)
  hpIBox(8.86+4*nIncr2, 4, 8.86+4*nIncr2, 4.7, 4)

  hpIAtSay(8.8+6*nIncr2, .25, hpBold('Card #'))
  hpIAtSay(8.8+6*nIncr2, 2.75, hpBold('Exp Dt'))
  hpIBox(8.86+6*nIncr2, 1, 8.86+6*nIncr2, 2.65, 4)
  hpIBox(8.86+6*nIncr2, 3.25, 8.86+6*nIncr2, 4.7, 4)

  hpIAtSay(8.8+7*nIncr2, .25, hpBold('Signature'))
  hpIBox(8.86+7*nIncr2, 1, 8.86+7*nIncr2, 4.7, 4)

  hpIAtSay(8.2, 6, hpBold('Payment method (    one ):'))
  hpRaster( aCheck, 8.1, 6+hpS2I('Payment method( '), 300, 'I' )

  CheckBox(8.4, 5.25)
  hpIAtSay(8.5, 5.5, 'VISA')

  CheckBox(8.4, 5.9)
  hpIAtSay(8.5, 6.15, 'MasterCard')

  CheckBox(8.4, 6.9)
  hpIAtSay(8.5, 7.15, 'American Express')

  CheckBox(8.7, 5.25)
  hpIAtSay(8.8, 5.5, 'Check enclosed')

  CheckBox(9, 5.25)
  hpIAtSay(9.1, 5.5, 'P.O. #                           (provide copy of P.O.)')
  // P.O. # line
  hpIBox(9.2, 5.9, 9.2, 6.8, 4)

  hpIAtSay(10.55, 1, "Pinnacle Publishing, Inc.")
  hpIAtSay(10.55, 2.75, "P.O. Box 1088     Kent, WA  98035-1088")
  hpRaster( aTriangle, 10.47, 2.6, 300, 'I' )
  hpRaster( aTriangle, 10.47, 3.65, 300, 'I' )

  hpPcx( 9.3, 7.2, "LOGO.PCX",'I', 300, .F., 100 )
  hpPcx( 7.2, .25, "YES.PCX",'I', 300, .F., 100 )
  hpPCX(5.5, 3, 'SAMPLE.PCX', 'I')

  hpClrFonts()
  hpReset()

  hpPrintOff()

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox({'Finished Printing.', 'Thank you for Ordering ESCAPE!'})
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  INKEY(1)

RETURN NIL

**************************************************************************
* ESCAPE! Function Summary                                               *
**************************************************************************
PROCEDURE PrintFuncts()
  LOCAL nTop  := 1.3
  LOCAL nRow  := nTop
  LOCAL nIncr := .1875

  // Print title and the line below it.
  hpSetFont('CEN12B.POR', 'SF')
  hpIAtSay(.75, 1.5, 'ver. 3.0 FUNCTION SUMMARY')
  hpPCX(.48, .34, 'ESCAPE.PCX', 'I', 300, .F., 50)
  hpIBox(.9, .2, .9, 8, 7)
  hpSetFont('CEN10.POR', 'SF')

  // 1st Row
  hpIGrayBox( nTop-.15, .4, 5.6, .4+1.75, 0, 3)
  hpIAtSay(nTop, .7, hpBold('Printer / Font'))
  nRow += nIncr
  hpIAtSay(nRow, .7, hpBold('Configuration Functs.'))
  hpIGrayBox(nTop-.15, .4, nRow+.1, .4+1.75, 4, 15)
  nRow += 2*nIncr

  hpIAtSay(nRow, .7, 'hpCallMacro( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpClrFonts( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpClrMacros( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpClrMargins( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpConfig( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpCopy( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpDownload( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpDuplex( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpEndMacro( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpExecMacro( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpFeed( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpHMI( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpLRMargin( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpOverlay( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpOverOff( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpPageSize( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpPhysical( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpPrintOff( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpPrintOn( )')
  nRow += nIncr
  hpIAtSay(nRow, .7, 'hpReset( )')

  // 2nd Row
  nRow := nTop
  hpIGrayBox( nTop-.15, 2.4, 5.6, 2.4+1.75, 0, 3)

  hpIAtSay(nRow, 2.7, 'hpSetFont( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpSetLPI( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpSetUp( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpStartMacro( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpTMargin( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpVMI( )')
  nRow += 2*nIncr
                   
  hpIAtSay(nRow, 2.7, hpBold('Positioning /'))
  nRow += nIncr
  hpIAtSay(nRow, 2.7, hpBold('Text Functions'))
  hpIGrayBox(nRow-nIncr-.15, 2.4, nRow+.1, 2.4+1.75, 4, 15)
  nRow += 2*nIncr

  hpIAtSay(nRow, 2.7, 'hpAtSay( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpBold( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpCenter( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpIAtSay( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpICenter( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpIRJust( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpJust( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpJustCount( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpJustLine( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpMLCount( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpMemoLine( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpRJust( )')
  nRow += nIncr
  hpIAtSay(nRow, 2.7, 'hpSub( )')

  // 3rd Row
  nRow := nTop
  hpIGrayBox( nTop-.15, 4.4, 5.6, 4.4+1.75, 0, 3)

  hpIAtSay(nRow, 4.7, 'hpSuper( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpTrans( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpUnderLn( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpWrap( )')
  nRow += 2*nIncr
                   
  hpIAtSay(nRow, 4.7, hpBold('Graphics'))
  nRow += nIncr
  hpIAtSay(nRow, 4.7, hpBold('Functions'))
  hpIGrayBox(nRow-nIncr-.15, 4.4, nRow+.1, 4.4+1.75, 4, 15)

  nRow += 2*nIncr
  hpIAtSay(nRow, 4.7, 'hpBox( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpCircle( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpGrayBar( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpGrayBox( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpGrayCol( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpIBox( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpIGrayBar( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpIGrayBox( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpIGrayCol( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpIPattBar( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpIPattBox( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpIPattCol( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpPattBar( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpPattBox( )')
  nRow += nIncr
  hpIAtSay(nRow, 4.7, 'hpPattCol( )')

  // 4th Row
  nRow := nTop
  hpIGrayBox( nTop-.15, 6.4, 5.6, 6.4+1.75, 0, 3)

  hpIAtSay(nRow, 6.7, 'hpPCX( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpRaster( )')
  nRow += 2*nIncr

  hpIAtSay(nRow, 6.7, hpBold('HPPCL 5'))
  nRow += nIncr
  hpIAtSay(nRow, 6.7, hpBold('Functions'))
  hpIGrayBox(nRow-nIncr-.15, 6.4, nRow+.1, 6.4+1.75, 4, 15)
  nRow += 2*nIncr

  hpIAtSay(nRow, 6.7, 'hpPattern( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpReverse( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpRotate( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpShade( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpShadow( )')
  nRow += 2*nIncr

  hpIAtSay(nRow, 6.7, hpBold('Conversion'))
  nRow += nIncr
  hpIAtSay(nRow, 6.7, hpBold('Functions'))
  hpIGrayBox(nRow-nIncr-.15, 6.4, nRow+.1, 6.4+1.75, 4, 15)
  nRow += 2*nIncr

  hpIAtSay(nRow, 6.7, 'hpC2I( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpC2M( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpI2M( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpL2I( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpLC2M( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpM2I( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpS2I( )')
  nRow += nIncr
  hpIAtSay(nRow, 6.7, 'hpS2M( )')
  nRow +=  2*nIncr

  // bottom line of function summary
  hpIBox(nRow, .2, nRow, 8, 7)

RETURN

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
PROCEDURE CheckBox(nTop, nLeft)
  hpIBox(nTop, nLeft, nTop+.12, nLeft+.12)
  hpIBoxShadow(nTop, nLeft, nTop+.12, nLeft+.12, .03, 100)
  // hpIBoxShadow() is a UDF which can be found in EXAMPLES.PRG
RETURN
