**************************************************************************
*                                                                        *
*  INVOICE.PRG                                                           *
*                                                                        *
*  Sample invoice printing program utilizing HPPCL 5 functions.          *
*  Requires an HP LaserJet series IIIP, III, IIID, IIIsi, IV, or         *
*  or later model printer.                                               *
*                                                                        *
**************************************************************************

FUNCTION INVOICE()
  LOCAL nRow   := 1.25
  LOCAL nDiff  := 0.28
  LOCAL nTopRow

  LOCAL aCheck := { "                       *********", ;
                    "                      *********", ;
                    "                      ********", ;
                    "                     ********", ;
                    "                     ********", ;
                    "                     *******", ;
                    "                    ********", ;
                    "                    ********", ;
                    "                    *******", ;
                    "                   *******", ;
                    "                   *******", ;
                    "                   *******", ;
                    "                  *******", ;
                    "                  *******", ;
                    "                  *******", ;
                    "                  *******", ;
                    "                 *******", ;
                    "                 *******", ;
                    "                 ******", ;
                    "                 ******", ;
                    "  **********    *******", ;
                    "    *********   ******", ;
                    "      ********  ******", ;
                    "        ******* ******", ;
                    "         *************", ;
                    "          ***********", ;
                    "           **********", ;
                    "            *********", ;
                    "             ********",;
                    "              *******",;
                    "               ******",;
                    "                ****" }

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape ver 3.0 - Sample Invoice Printing Program'

  ****
  * Display screen message
  ****
  ShowBox('Printing Sample Invoice...')

  *************************************************************************
  * BEGIN PRINTING INVOICE USING ESCAPE                                   *
  *************************************************************************

  hpPrintOn()
  hpConfig('LETTER', 'P', 1, 'III')
  hpSetFont( 'UNIVERS','I',, 15 )

  hpPhysical(.T.)

  ****
  * Draw the company logo
  ****

  ****
  * Parameters for circle are <center row>, <center col>, <radius>,
  * <border thickness in dots>, <% gray>, <pattern #>, <units of measure>
  ****
  hpIGrayBox( .25, .3, 1.9, 2.8, 1, 20 )
  hpCircle( 1.2, 1.05, .55, 1, 100, 0, 'I' )
  hpAtSay( 1.1, .65, hpReverse( "THE", 100), "I" )
  hpSetFont( 'UNIVERS','I',, 24 )
  hpAtSay( 1.4, .65, hpReverse( "SPOT",100 ) + " SHOP", "I" )
  hpIGrayBox( 1.5, 1.05, 1.55, 2.65, 1, 80 )
  hpIGrayBox( 1.6, 1.05, 1.65, 2.65, 1, 80 )
  hpIGrayBox( 1.7, 1.05, 1.75, 2.65, 1, 80 )

  hpSetFont( 'CGTIMES','I',, 18 )
  hpIRJust( hpReverse( " INVOICE ", 100 ), .75 )

  ****
  * Sold to
  ****
  hpSetFont( 'CGTIMES','I',, 12 )
  hpIGrayBox( nRow, 3.5, nRow+.05, 4.5, 1, 100 )
  hpIAtSay( nRow+.05, 4.75, hpBold( "Sold to:" ) )

  hpSetFont( 'CGTIMESI','I',, 8 )
  hpIBox( nRow+.4, 4.75, nRow+.4, 8.25, 4 )
  hpIAtSay( nRow+.47, 4.75, "Name" )
  hpIBox( nRow+.65, 4.75, nRow+.65, 8.25, 4 )
  hpIAtSay( nRow+.72, 4.75, "Address" )
  hpIBox( nRow+.9, 4.75, nRow+.9, 8.25, 4 )
  hpIAtSay( nRow+.97, 4.75, "City" )
  hpIAtSay( nRow+.97, 7.25, "State" )
  hpIAtSay( nRow+.97, 7.75, "Zip" )
  hpIBox( nRow+1.15, 4.75, nRow+1.15, 8.25, 4 )
  hpIAtSay( nRow+1.22, 4.75, "Phone" )

  ****
  * Ship to
  ****
  hpSetFont( 'CGTIMES','I',, 12 )
  hpIGraybox( nRow+1.5, 3.5, nRow+1.55, 4.5, 1, 100 )
  hpIAtSay( nRow+1.55, 4.75, hpBold( "Ship to:" ) )

  hpSetFont( 'CGTIMESI','I',, 8 )
  hpIBox( nRow+1.9, 4.75, nRow+1.9, 8.25, 4 )
  hpIAtSay( nRow+1.97, 4.75, "Name" )
  hpIBox( nRow+2.15, 4.75, nRow+2.15, 8.25, 4 )
  hpIAtSay( nRow+2.22, 4.75, "Address" )
  hpIBox( nRow+2.4, 4.75, nRow+2.4, 8.25, 4 )
  hpIAtSay( nRow+2.47, 4.75, "City" )
  hpIAtSay( nRow+2.47, 7.25, "State" )
  hpIAtSay( nRow+2.47, 7.75, "Zip" )
  hpIBox( nRow+2.65, 4.75, nRow+2.65, 8.25, 4 )
  hpIAtSay( nRow+2.72, 4.75, "Phone" )

  ****
  * Date
  ****
  hpSetFont( 'CGTIMES','I',, 12 )
  hpIGrayBox( 2.35, .25, 2.4, 1.25, 1, 100 )
  hpIAtSay( 2.38, 1.5, hpBold( "Date:" ) )
  hpIBox( 2.4, 1.5 + hpS2I( "Date: " ), 2.4, 3, 4 )
  hpIAtSay( 2.55, 1.5, hpBold( "Payment:" ) )

  hpSetFont( 'CGTIMES','I',, 9 )
  hpIBox( 2.70, 1.5, 2.80, 1.6, 4 )
  hpRaster( aCheck, 2.65, 1.55, 300, "I" )
  hpIAtSay( 2.75, 1.7, "Check enclosed" )
  hpIBox( 2.9, 1.5, 3, 1.6, 4 )
  hpIAtSay( 2.95, 1.7, "COD" )
  hpIBox( 3.1, 1.5, 3.2, 1.6, 4 )
  hpIAtSay( 3.15, 1.7, "Charge card" )

  hpSetFont( 'CGTIMESI','I',, 8 )

  hpIBox( 3.30, 1.7, 3.30, 3.5, 4 )
  hpIAtSay( 3.37, 1.7, "Card name" )
  hpIBox( 3.5, 1.7, 3.5, 3.5, 4 )
  hpIAtSay( 3.57, 1.7, "Number" )
  hpIBox( 3.7, 1.7, 3.7, 3.5, 4 )
  hpIAtSay( 3.77, 1.7, "Expiration date" )
  hpIBox( 3.9, 1.7, 3.9, 3.5, 4 )
  hpIAtSay( 3.97, 1.7, "Signature" )

  ****
  * Start of body
  ****
  hpSetFont( 'CGTIMES','I',, 9 )
  hpIGrayBox( 4.25, 0.25, 4.30, 1.25, 1, 100 )
  hpIAtSay( 4.28, 1.5, "Item" )
  hpICenter( "Size", 4.28, 5.1 )
  hpICenter( "Quantity", 4.28, 5.8 )
  hpICenter( "Unit", 4.15, 6.5 )
  hpICenter( "Price", 4.28, 6.5 )
  hpICenter( "Total", 4.28, 7.2 )
  hpICenter( "Weight", 4.28, 7.9 )

  ****
  * Draw the lines of the items
  ****
  hpIGrayBox( 4.40, 1.5, 4.43, 8.25, 1, 100 )
  nRow := 4.40
  DO WHILE .T.
    hpIBox( nRow, 1.5, nRow, 8.25, 4 )
    nRow += nDiff
    IF nRow >= 8.75
      EXIT
    ENDIF
  ENDDO

  nTopRow := nRow-nDiff

  hpSetFont( 'CGTIMES','I',, 12 )
  hpIAtSay( nRow - nDiff - .075, 1.5, "Minimum order: $15" )

  ****
  * Draw the shades
  ****
  hpIGrayBox( 4.07, 4.75, nRow-nDiff, 5.45, 0, 10, 4 )
  hpIGrayBox( 4.07, 6.15, nRow-nDiff, 6.85, 0, 10, 4 )
  hpIGrayBox( 4.07, 7.55, nRow-nDiff, 8.25, 0, 10, 4 )

  hpIGrayBox( nRow-0.025, 1.5, nRow+0.025, 2.5, 1, 100 )
  hpIAtSay( nRow, 2.75, hpBold( "Shipping:" ) )

  nRow += 0.15

  hpSetFont( 'CGTIMES','I',, 9 )
  hpIBox( nRow, 2.75, nRow + 0.1, 2.85, 4 )
  hpIAtSay( nRow+.05, 2.95, "UPS" )
  nRow += 0.2
  hpIBox( nRow, 2.75, nRow + 0.1, 2.85, 4 )
  hpIAtSay( nRow+.05, 2.95, "Parcel Post" )
  nRow += 0.2
  hpIBox( nRow, 2.75, nRow + 0.1, 2.85, 4 )
  hpIAtSay( nRow+.05, 2.95, "Federal Express" )

  ****
  * Draw totals
  ****
  hpIGrayBox( nTopRow, 6.15, nTopRow + 1.25, 6.85, 4, 10 )
  hpIGrayBox( nTopRow, 7.55, nTopRow + 1, 8.2, 4, 10 )
  hpIBox( nTopRow + 0.5, 6.15, nTopRow+0.5, 8.2, 4 )
  hpIBox( nTopRow + .75, 6.15, nTopRow+.75, 7.55, 4 )
  hpIBox( nTopRow + 1, 6.15, nTopRow+1.25, 7.55, 4 )
  hpIGrayBox( nTopRow + 0.98, 6.15, nTopRow+1, 7.55, 1, 100 )
  hpIGrayBox( nTopRow - 0.02, 6.85, nTopRow, 8.2, 1, 100 )

  hpIRJust( "Subtotal", nTopRow + 0.4, 6.8 )
  hpIRJust( "Sales tax", nTopRow + 0.65, 6.8 )
  hpIRJust( "Shipping", nTopRow + 0.9, 6.8 )
  hpIRJust( "Total", nTopRow + 1.15, 6.8 )

  hpIAtSay( nTopRow + 0.65, 7.65, "Shipping" )
  hpIAtSay( nTopRow + 0.77, 7.65, "weight" )

  ****
  * Draw little address at bottom left corner
  ****
  hpSetFont( 'CGTIMES','I',, 8 )
  hpIGrayBox( 9.9, .25, 9.93, 1.375, 1, 100 )

  hpIAtSay( 10, .35, hpbold( "The Spot Shop" ) )
  hpIAtSay( 10.13, .35, "PO Box 89073" )
  hpIAtSay( 10.26, .35, "Portland, OR  93502" )
  hpIAtSay( 10.39, .35, "800/426-3410" )

  hpReset()
  hpPrintOff()    

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  INKEY(1)

RETURN NIL
