**************************************************************************
*                                                                        *
*  HPCARTS.PRG                                                           *
*                                                                        *
*  Prints out a list of the HP cartridge fonts using the Escape library. *
*                                                                        *
**************************************************************************
#include "samples.ch"

FUNCTION hpCarts()

  LOCAL nCart   := .45
  LOCAL nFont   := 2.25
  LOCAL nPitch  := 4.25
  LOCAL nPoint  := 5.4
  LOCAL nOrient := 6.5
  LOCAL nRight  := 7.8

  LOCAL nPg     := 0      && page number
  LOCAL nLastLn := 57     && maximum number of lines per page
  LOCAL nLine   := 58     && line counter
  LOCAL lGray   := .F.    && specifies whether a GRAY bar should be printed

  FIELD fontname, cart, orient, cartname, cartnumber, pitch, point

  ****
  * Display screen title
  ****
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape ver 3.0 - Sample Report Written with Escape'

  ****
  * Display screen message
  ****
  ShowBox('Indexing...')

  SELE 0
  USE fonts
  INDEX ON fontname TO tempfont

  SELE 0
  USE cartcont
  INDEX ON cart+fontname TO tempcont

  SELE 0
  USE cartrdge
  INDEX ON cart TO tempcart

  ****
  * Display screen message
  ****
  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Downloading Fonts...')

  *************************************************************************
  * BEGIN PRINTING REPORT USING ESCAPE                                    *
  *************************************************************************
 
  hpPrintOn()

  hpDownload("CEN10.POR", 1, "LPT1",, DOWNLOADCHARS)
  hpDownload("CEN10I.POR", 2, "LPT1",, DOWNLOADCHARS)
  hpDownload("CEN12B.POR", 3, "LPT1", "", " Table ofHPLsrJtCidgFn")

  hpPrintOff()

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Printing Cartridge Report...')

  ****
  * Select the internal 10 pitch Courier font, and letter size paper.
  * (3rd and 4th parameters default to Portrait orientation and 1 copy.
  *
  * Include an error check of the return values to make sure hpConfig()
  * executes correctly.
  ****
  hpPrintOn()
  hpConfig('LETTER', 'P')

  DO WHILE .NOT. EOF()

    IF nLine > nLastLn
      nLine := 1
      nPg++

      ****
      * print page number and title
      ****                         
      hpSetFont('CEN12B.POR', 'SF')
      HPICENTER("Table of HP LaserJet", hpL2I(nLine))
      HPICENTER("Cartridge Fonts", hpL2I(nLine + 1.1))

      hpSetFont('CEN10.POR', 'SF')
      hpICenter( "Page " + STR(nPg,2), hpL2I(nLastln +3) )

      nLine += 4.75

      ****
      * print column headings
      ****                   
      hpIAtSay( hpltoi(nLine), nFont, "Font Name")
      hpIAtSay( hpltoi(nLine), nPitch, "Pitch")
      hpIAtSay( hpltoi(nLine), nPoint, "Point")
      hpIAtSay( hpltoi(nLine), nOrient, "Orientation")

      ****
      * draw double lines at top and bottom of page
      ****                                         
      nLine += 1.25
      HPIBOX( hpL2I(nLine), nCart-.1, hpltoi(nLine), nRight, 2)
      HPIBOX( hpltoi(nLastLn+1), nCart-.1, hpltoi(nLastLn+1), nRight, 2)
    ENDIF

    ****
    * Check if there is room on the page to print data for the next cartridge.
    ****
    IF .NOT. IsRoom(@nLine, nLastLn)
      LOOP
    ENDIF

    ****
    * Print dotted underline
    ****                    
    HPIBOX( hpL2I(nLine), nCart-.1, hpL2I(nLine), nRight, 3)
    nLine++

    ****
    * print cartridge name
    ****                  
    hpSetFont('CEN10I.POR', 'SF')
    hpIAtSay( hpL2I(nLine + 2), nCart, cartnumber )

    hpSetFont('CEN10.POR', 'SF')
    hpIAtSay( hpL2I(nLine), nCart, hpBold("Cartridge " + cart) )
    hpIAtSay( hpL2I(nLine + 1), nCart, cartname )

    ****
    *  print cartridge contents
    ****                       
    SELE cartcont
    GO TOP
    SEEK cartrdge->cart

    DO WHILE cart = cartrdge->cart
      SELE fonts
      SEEK cartcont->fontname

      HPIATSAY( hpL2I(nLine), nFont, fontname)
      HPIATSAY( hpL2I(nLine), nPitch, IIF(EMPTY(pitch), "Prop", pitch))
      HPIATSAY( hpL2I(nLine), nPoint, point)

      DO CASE
        CASE cartcont->orient == "P "
          HPIATSAY( hpL2I(nLine), nOrient, "Portrait")
        CASE cartcont->orient == "L "
          HPIATSAY( hpL2I(nLine), nOrient, "Landscape")
        CASE cartcont->orient == "PL"
          HPIATSAY( hpL2I(nLine), nOrient, "Port & Land")
      ENDCASE

      ****
      * draw a GRAY bar every other line
      ****                              
      IF lGray
        HPIGRAYBAR( hpL2I(nLine), nFont, nRight-nFont, 0, 10)
      ENDIF
      lGray := (.NOT. lGray)

      SELE cartcont
      nLine++
      SKIP
    ENDDO

    lGray := .F.            && no GRAY shading on first line
    nLine++
    IF nLine > nLastLn
      EJECT
    ENDIF
    SELE cartrdge
    SKIP
  ENDDO

  hpClrFonts()
  hpReset()
  hpPrintOff()

  CLOSE DATA
  ERASE tempfont.ntx
  ERASE tempcont.ntx
  ERASE tempcart.ntx

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  INKEY(1)

RETURN NIL

* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ *
****
* Before printing cartridge contents:
* 
* Count the number of fonts that are contained in the cartridge.
* If there is enough room to fit it all on the same page, then
* print, otherwise begin the next page.
****

FUNCTION IsRoom(nLine, nLastLn)

  LOCAL nCurrArea := SELECT()
  LOCAL nLines := 0

  SELE CARTCONT
  SEEK CARTRDGE->cart

  DO WHILE cartcont->cart == cartrdge->cart
    nLines++
    SKIP
  ENDDO

  SELECT(nCurrArea)

  IF nLine + nLines <=nLastLn
    RETURN(.T.)
  ELSE
    nLine := nLastLn + 1
    EJECT
    RETURN(.F.)
  ENDIF

RETURN .F.
