**************************************************************************
*                                                                        *
*  GENLEDGR.PRG                                                          *
*                                                                        *
*  Prints out General Ledger Paper using Escape box drawing functions.   *
*                                                                        *
**************************************************************************

FUNCTION Genledgr()

  LOCAL nRow, nCol, nCounter

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  SETCOLOR('w+/bg')
  @ 0,0,2,79 BOX 'Ŀ '
  @ 1,2 SAY 'Escape ver 3.0 - Sample General Ledger Paper Program'

  ****
  * Display screen message
  ****
  ShowBox('Printing General Ledger Paper...')

  *************************************************************************
  * BEGIN PRINTING GENERAL LEDGER PAPER USING ESCAPE                      *
  *************************************************************************

  hpPrintOn()

  ****
  * Select 16 pitch line printer font, letter-size paper, portrait, 1 copy
  * 4 lines per inch to get lines spaced correctly
  ****
  hpConfig('LETTER','P', 1)
  hpSetFont('LINEPRT 16', 'I')

  hpSetLPI(4)

  hpBox(2,6,40,132,2)                      && outer box

  FOR nRow = 3 TO 39
    hpBox(nRow,6,nRow,132,iif(nRow=5,2,4)) && hairline horizontal lines
  NEXT                                     && at line 5 draw double line

  hpBox(2,13,40,13,1)                      && first single line
  hpBox(2,19,40,19,2)                      && first vertical double line

  nCol := 52
  FOR nCounter = 1 TO 4
    hpBox(2,nCol,40,nCol,2)                && first vertical double line
    hpGrayBox(5,nCol,40,nCol+4,1,10)       && gray 2 char box
    hpbox(5,nCol+6,40,nCol+8,1)   	       && single line box
    hpGrayBox(5,nCol+10,40,nCol+16,1,10)
    hpBox(5,nCol+12,40,nCol+14,1)          && single line box
    nCol+= 20
  NEXT

  ****
  * Switch to 10 pitch for title
  ****
  hpSetFont("COURIER 10", "I")
  @ 0,5 SAY hpBold( 'SAMPLE GENERAL LEDGER SHEET ') + '- Produced with '

  hpSetFont("COURIER 10I", "I")
  @ PROW(),PCOL() SAY 'Escape'

  ****
  * Switch back to Line Printer for line numbers
  ****
  hpSetFont("LINEPRT 16", "I")

  ****
  * Print line numbers
  ****
  FOR nRow = 6 TO 40
    hpAtSay( nRow-.5, 3, STR(nRow-5,2,0) )
  NEXT

  hpReset()
  hpPrintOff()

  SETCOLOR('w/b')
  @ 3,0 CLEAR
  ShowBox('Finished Printing.')
  TONE(100,1)
  TONE(500,1)
  TONE(1000,1)
  INKEY(1)

RETURN NIL
